/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.hcompress;

import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;

public class HCompressorOption
implements ICompressOption {
    private ICompressParameters parameters;
    private int scale;
    private boolean smooth;
    private int tileHeight;
    private int tileWidth;

    @Override
    public HCompressorOption copy() {
        try {
            return (HCompressorOption)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("option could not be cloned", e);
        }
    }

    @Override
    public ICompressParameters getCompressionParameters() {
        return this.parameters;
    }

    public int getScale() {
        return this.scale;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public boolean isLossyCompression() {
        return this.scale > 1 || this.smooth;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    @Override
    public void setParameters(ICompressParameters parameters) {
        this.parameters = parameters;
    }

    public HCompressorOption setScale(int value) {
        this.scale = value;
        return this;
    }

    public HCompressorOption setSmooth(boolean value) {
        this.smooth = value;
        return this;
    }

    @Override
    public HCompressorOption setTileHeight(int value) {
        this.tileHeight = value;
        return this;
    }

    @Override
    public HCompressorOption setTileWidth(int value) {
        this.tileWidth = value;
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }
}

