/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.utilities;

public class FitsSubString {
    private int length;
    private int offset;
    private final String originalString;

    public FitsSubString(String originalString) {
        this.originalString = originalString == null ? "" : originalString;
        this.offset = 0;
        this.length = this.originalString.length();
    }

    public void appendTo(StringBuilder buffer) {
        buffer.append(this.originalString, this.offset, this.offset + this.length);
    }

    public char charAt(int pos) {
        return this.originalString.charAt(pos + this.offset);
    }

    public int fullLength() {
        return this.originalString.length() - this.offset;
    }

    public void getAdjustedLength(int max) {
        if (max <= 0) {
            this.length = 0;
        } else if (this.length > max) {
            int pos = max - 1;
            while (this.charAt(pos) == '\'') {
                --pos;
            }
            pos += (max - 1 - pos) / 2 * 2;
            this.length = pos + 1;
        }
    }

    public int length() {
        return this.length;
    }

    public void rest() {
        this.offset += this.length;
        this.length = this.originalString.length() - this.offset;
    }

    public void skip(int count) {
        this.offset += count;
        this.length -= count;
    }

    public boolean startsWith(String string) {
        return this.originalString.regionMatches(this.offset, string, 0, string.length());
    }
}

