
#include "SqlSchema.hpp"


using namespace std;

SqlSchema::SqlSchema()
{
   reset();
}


void SqlSchema::reset(void)
{
   headersRow
      = {
         {headersColId::filename,   "filename   VARCHAR(4096)   NOT NULL"},
         {headersColId::hdunum,     "hdunum     INTEGER         NOT NULL"},
         {headersColId::pubdid,     "pubdid     VARCHAR(4096)   UNIQUE"},
         {headersColId::header,     "header     TEXT            NOT NULL"},
         {headersColId::survey_id,  "survey_id  INTEGER"},
         {headersColId::header_id,  "header_id  INTEGER         PRIMARY KEY"}
      };


   boundsgalRow
      = {
         {bgheader_id,  "header_id  INTEGER       PRIMARY KEY"},
         {lfrom,   "lon_from  DECIMAL(21,16) NOT NULL" },
         {lto,     "lon_to    DECIMAL(21,16) NOT NULL" },
         {lunit,   "lon_unit  VARCHAR(16)" },

         {bfrom,   "lat_from  DECIMAL(21,16) NOT NULL" },
         {bto,     "lat_to    DECIMAL(21,16) NOT NULL" },
         {bunit,   "lat_unit  VARCHAR(16)" },

         {vfrom,   "vel_from  DECIMAL(21,8)" },// FIXME check why 8 not 16
         {vto,     "vel_to    DECIMAL(21,8)" },
         {vunit,   "vel_unit  VARCHAR(16)" },
      };

   boundsicrsRow
      = {
         {biheader_id,  "header_id  INTEGER       PRIMARY KEY"},
         {rfrom,   "ra_from  DECIMAL(21,16) NOT NULL" },
         {rto,     "ra_to    DECIMAL(21,16) NOT NULL" },
         {runit,   "ra_unit  VARCHAR(16)" },

         {dfrom,   "dec_from  DECIMAL(21,16) NOT NULL" },
         {dto,     "dec_to    DECIMAL(21,16) NOT NULL" },
         {dunit,   "dec_unit  VARCHAR(16)" },
      };

   verticesgalRow
      = {
         {vgheader_id,  "header_id  INTEGER        PRIMARY KEY"},
         {p1lon, "p1_lon DECIMAL(21,16) NOT NULL"},
         {p1lat, "p1_lat DECIMAL(21,16) NOT NULL"},
         {p2lon, "p2_lon DECIMAL(21,16) NOT NULL"},
         {p2lat, "p2_lat DECIMAL(21,16) NOT NULL"},
         {p3lon, "p3_lon DECIMAL(21,16) NOT NULL"},
         {p3lat, "p3_lat DECIMAL(21,16) NOT NULL"},
         {p4lon, "p4_lon DECIMAL(21,16) NOT NULL"},
         {p4lat, "p4_lat DECIMAL(21,16) NOT NULL"}
      };

   verticesicrsRow
      = {
         {viheader_id,  "header_id  INTEGER           PRIMARY KEY"},
         {p1ra,  "p1_ra  DECIMAL(21,16) NOT NULL"},
         {p1dec, "p1_dec DECIMAL(21,16) NOT NULL"},
         {p2ra,  "p2_ra  DECIMAL(21,16) NOT NULL"},
         {p2dec, "p2_dec DECIMAL(21,16) NOT NULL"},
         {p3ra,  "p3_ra  DECIMAL(21,16) NOT NULL"},
         {p3dec, "p3_dec DECIMAL(21,16) NOT NULL"},
         {p4ra,  "p4_ra  DECIMAL(21,16) NOT NULL"},
         {p4dec, "p4_dec DECIMAL(21,16) NOT NULL"}
      };



   obscoreRow
      = {
         {dataproduct_type, "dataproduct_type   VARCHAR"},
         {calib_level,      "calib_level        INTEGER     NOT NULL"},
         {obs_collection,   "obs_collection     VARCHAR     NOT NULL"},
         {obs_title,        "obs_title          VARCHAR"},
         {obs_id,           "obs_id             VARCHAR     NOT NULL"},
         {obs_publisher_id, "obs_publisher_did  VARCHAR     PRIMARY KEY"},
         {bib_reference,    "bib_reference      VARCHAR"},
         {data_rights,      "data_rights        VARCHAR"},
         {access_url,       "access_url         TEXT"},
         {access_format,    "access_format      VARCHAR"},
         {access_estsize,   "access_estsize     BIGINT"},
         {target_name,      "target_name        VARCHAR"},
         {s_ra,             "s_ra               double precision"},
         {s_dec,            "s_dec              double precision"},
         {s_fov,            "s_fov              double precision"},
         {s_region,         "s_region           VARCHAR"},
         {s_region_galactic,"s_region_galactic  VARCHAR"},
         {s_xel1,           "s_xel1             bigint"},
         {s_xel2,           "s_xel2             bigint"},
         {s_resolution,     "s_resolution       double precision"},
         {t_min,            "t_min              double precision"},
         {t_max,            "t_max              double precision"},
         {t_exptime,        "t_exptime          double precision"},
         {t_resolution,     "t_resolution       double precision"},
         {t_xel,            "t_xel              bigint"},
         {em_min,           "em_min             double precision"},
         {em_max,           "em_max             double precision"},
         {vel_min,          "vel_min            double precision"},
         {vel_max,          "vel_max            double precision"},
         {em_res_power,     "em_res_power       double precision"},
         {em_xel,           "em_xel             bigint"},
         {o_ucd,            "o_ucd              VARCHAR"},
         {pol_states,       "pol_states         VARCHAR"},
         {pol_xel,          "pol_xel            bigint"},
         {facility_name,    "facility_name      VARCHAR"},
         {instrument_name,  "instrument_name    VARCHAR"},
         {coordinates,      "coordinates        spoint"},
         {polygon_region_galactic,   "polygon_region_galactic     spoly"},
         {polygon_region,   "polygon_region     spoly"},
         {proposal_id,      "proposal_id        VARCHAR"},
         {policy ,          "policy             auth_policy NOT NULL"},
         {groups,           "groups             TEXT[]      NULL"}
      };


   initCols();
}


void SqlSchema::initCols(void)
{
//   using namespace columns;

   m_columns[headers]         = "(" + headersRow.concat_val_first_word() + ")";
   m_columns[boundsgal]       = "(" + boundsgalRow.concat_val_first_word() + ")";
   m_columns[boundsicrs]      = "(" + boundsicrsRow.concat_val_first_word() + ")";
   m_columns[verticesgal]     = "(" + verticesgalRow.concat_val_first_word() + ")";
   m_columns[verticesicrs]    = "(" + verticesicrsRow.concat_val_first_word() + ")";
   m_columns[obscore]         = "(" + obscoreRow.concat_val_first_word() + ")";
};



void SqlSchema::appendRow(void)
{
//   using namespace columns;

   m_values[headers]     += "(" + headersRow.concat_val_all()  + "),";
   m_values[boundsgal]   += "(" + boundsgalRow.concat_val_all()   + "),";
   m_values[boundsicrs]  += "(" + boundsicrsRow.concat_val_all()   + "),";
   m_values[verticesgal] += "(" + verticesgalRow.concat_val_all() + "),";
   m_values[verticesicrs] += "(" + verticesicrsRow.concat_val_all() + "),";
   m_values[obscore]     += "(" + obscoreRow.concat_val_all()  + "),";
};





// skip last character
string SqlSchema::skl(string str)
{
   return str.substr(0, str.size() - 1);
}




#if 0
vector<string> SqlSchema::concatedValues(void)
{
   vector<string> vVals;
   std::map<Tables, std::string>::const_iterator it = m_values.begin();
   while(it != m_values.end())
   {
      Tables t = it->first;
      string cmd =  it->second;

      vVals.push_back(cmd);
      it++;
   }
   return vVals;
}


vector<string> SqlSchema::map2vect(const map<SqlSchema::Tables, string>& amap)
{
   vector<string> vVals;
   std::map<SqlSchema::Tables, std::string>::const_iterator it = amap.begin();
   while(it != amap.end())
   {
      SqlSchema::Tables t = it->first;
      string cmd =  it->second;

      vVals.push_back(cmd);
      it++;
   }
   return vVals;
}

vector<string> SqlSchema::concatedColumns(void)
{
   return map2vect(m_columns);
}
#endif


