/*
 * Decompiled with CFR 0.152.
 */
package uws.service.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.file.LocalUWSFileManager;
import uws.service.file.UWSFileManager;
import uws.service.log.UWSLog;

public class DefaultUWSLog
implements UWSLog {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected final UWS uws;
    protected final UWSFileManager fileManager;
    protected final PrintWriter defaultOutput;
    protected UWSLog.LogLevel minLogLevel = UWSLog.LogLevel.DEBUG;

    public DefaultUWSLog(UWS uws) {
        this.uws = uws;
        this.fileManager = null;
        this.defaultOutput = null;
    }

    public DefaultUWSLog(UWSFileManager fm) {
        this.uws = null;
        this.fileManager = fm;
        this.defaultOutput = null;
    }

    public DefaultUWSLog(OutputStream output) {
        this.uws = null;
        this.fileManager = null;
        this.defaultOutput = new PrintWriter(output);
    }

    public DefaultUWSLog(PrintWriter writer) {
        this.uws = null;
        this.fileManager = null;
        this.defaultOutput = writer;
    }

    @Override
    public String getConfigString() {
        return "minimum log level: \"" + (Object)((Object)this.minLogLevel) + (this.fileManager instanceof LocalUWSFileManager ? "\", log rotation: \"" + ((LocalUWSFileManager)this.fileManager).getLogRotationFreq() : "") + "\"";
    }

    public final UWSLog.LogLevel getMinLogLevel() {
        return this.minLogLevel;
    }

    public final void setMinLogLevel(UWSLog.LogLevel newMinLevel) {
        if (newMinLevel != null) {
            this.minLogLevel = newMinLevel;
        }
    }

    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final void setDateFormat(DateFormat dateFormat) {
        if (dateFormat != null) {
            this.dateFormat = dateFormat;
        }
    }

    protected PrintWriter getOutput(UWSLog.LogLevel level, String context) {
        try {
            if (this.uws != null) {
                if (this.uws.getFileManager() != null) {
                    return this.uws.getFileManager().getLogOutput(level, context);
                }
            } else {
                if (this.fileManager != null) {
                    return this.fileManager.getLogOutput(level, context);
                }
                if (this.defaultOutput != null) {
                    return this.defaultOutput;
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        return new PrintWriter(System.err);
    }

    protected String normalizeMessage(String message) {
        if (message == null) {
            return null;
        }
        return message.replaceAll("[\n\t]", " ").replaceAll("\r", "");
    }

    protected boolean canLog(UWSLog.LogLevel msgLevel) {
        if (msgLevel == null) {
            msgLevel = UWSLog.LogLevel.DEBUG;
        }
        switch (this.minLogLevel) {
            case INFO: {
                return msgLevel != UWSLog.LogLevel.DEBUG;
            }
            case WARNING: {
                return msgLevel != UWSLog.LogLevel.DEBUG && msgLevel != UWSLog.LogLevel.INFO;
            }
            case ERROR: {
                return msgLevel == UWSLog.LogLevel.ERROR || msgLevel == UWSLog.LogLevel.FATAL;
            }
            case FATAL: {
                return msgLevel == UWSLog.LogLevel.FATAL;
            }
        }
        return true;
    }

    @Override
    public void log(UWSLog.LogLevel level, String context, String message, Throwable error) {
        this.log(level, context, null, null, message, null, error);
    }

    protected final void log(UWSLog.LogLevel level, String context, String event, String ID, String message, String addColumn, Throwable error) {
        if ((message == null || message.length() <= 0) && error == null) {
            return;
        }
        if (level == null) {
            UWSLog.LogLevel logLevel = level = error != null ? UWSLog.LogLevel.ERROR : UWSLog.LogLevel.INFO;
        }
        if (!this.canLog(level)) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.dateFormat.format(new Date())).append('\t');
        buf.append(level.toString()).append('\t');
        buf.append(context == null ? "" : context).append('\t');
        buf.append(event == null ? "" : event).append('\t');
        buf.append(ID == null ? "" : ID).append('\t');
        if (message != null) {
            buf.append(this.normalizeMessage(message));
        } else if (error != null) {
            buf.append("[EXCEPTION ").append(error.getClass().getName()).append("] ").append(this.normalizeMessage(error.getMessage()));
        }
        if (addColumn != null) {
            buf.append('\t').append(this.normalizeMessage(addColumn));
        }
        PrintWriter out = this.getOutput(level, context);
        out.println(buf.toString());
        this.printException(error, out);
        out.flush();
    }

    protected void printException(Throwable error, PrintWriter out) {
        if (error != null) {
            if (error instanceof UWSException) {
                if (error.getCause() != null) {
                    this.printException(error.getCause(), out);
                } else {
                    out.println("Caused by a " + error.getClass().getName() + " " + this.getExceptionOrigin(error));
                    if (error.getMessage() != null) {
                        out.println("\t" + error.getMessage());
                    }
                }
            } else {
                out.print("Caused by a ");
                error.printStackTrace(out);
            }
        }
    }

    protected String getExceptionOrigin(Throwable error) {
        if (error != null && error.getStackTrace() != null && error.getStackTrace().length > 0) {
            StackTraceElement src = error.getStackTrace()[0];
            return "at " + src.getClassName() + "." + src.getMethodName() + (src.getFileName() != null ? "(" + src.getFileName() + (src.getLineNumber() >= 0 ? ":" + src.getLineNumber() : "") + ")" : "");
        }
        return "";
    }

    @Override
    public void debug(String msg) {
        this.log(UWSLog.LogLevel.DEBUG, null, msg, null);
    }

    @Override
    public void debug(Throwable t) {
        this.log(UWSLog.LogLevel.DEBUG, null, null, t);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(UWSLog.LogLevel.DEBUG, null, msg, t);
    }

    @Override
    public void info(String msg) {
        this.log(UWSLog.LogLevel.INFO, null, msg, null);
    }

    @Override
    public void warning(String msg) {
        this.log(UWSLog.LogLevel.WARNING, null, msg, null);
    }

    @Override
    public void error(String msg) {
        this.log(UWSLog.LogLevel.ERROR, null, msg, null);
    }

    @Override
    public void error(Throwable t) {
        this.log(UWSLog.LogLevel.ERROR, null, null, t);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(UWSLog.LogLevel.ERROR, null, msg, t);
    }

    @Override
    public void logHttp(UWSLog.LogLevel level, HttpServletRequest request, String requestId, String message, Throwable error) {
        if (request != null) {
            if (level == null) {
                UWSLog.LogLevel logLevel = level = error != null ? UWSLog.LogLevel.ERROR : UWSLog.LogLevel.INFO;
            }
            if (!this.canLog(level)) {
                return;
            }
            StringBuffer str = new StringBuffer();
            str.append(request.getMethod());
            str.append(" as ");
            if (request.getContentType() != null) {
                if (request.getContentType().indexOf(59) > 0) {
                    str.append(request.getContentType().substring(0, request.getContentType().indexOf(59)));
                } else {
                    str.append(request.getContentType());
                }
            }
            str.append(" at ").append(request.getRequestURL());
            str.append(" from ").append(request.getRemoteAddr());
            str.append(" using ").append(request.getHeader("User-Agent") == null ? "" : request.getHeader("User-Agent"));
            str.append(" with parameters (");
            Map<String, String> params = UWSToolBox.getParamsMap(request);
            int i = -1;
            for (Map.Entry<String, String> p : params.entrySet()) {
                if (++i > 0) {
                    str.append('&');
                }
                str.append(p.getKey()).append('=').append(p.getValue() != null ? p.getValue() : "");
            }
            str.append(')');
            this.log(level, "HTTP", "REQUEST_RECEIVED", requestId, message != null ? message : str.toString(), message != null ? str.toString() : null, error);
        } else {
            this.log(level, "HTTP", "REQUEST_RECEIVED", requestId, message, null, error);
        }
    }

    @Override
    public void logHttp(UWSLog.LogLevel level, HttpServletResponse response, String requestId, JobOwner user, String message, Throwable error) {
        if (response != null) {
            if (level == null) {
                UWSLog.LogLevel logLevel = level = error != null ? UWSLog.LogLevel.ERROR : UWSLog.LogLevel.INFO;
            }
            if (!this.canLog(level)) {
                return;
            }
            StringBuffer str = new StringBuffer();
            str.append("HTTP-").append(response.getStatus());
            str.append(" to the user ");
            if (user != null) {
                str.append("(id:").append(user.getID());
                if (user.getPseudo() != null) {
                    str.append(";pseudo:").append(user.getPseudo());
                }
                str.append(')');
            } else {
                str.append("ANONYMOUS");
            }
            if (response.getContentType() != null) {
                str.append(" as ").append(response.getContentType());
            }
            this.log(level, "HTTP", "RESPONSE_SENT", requestId, message, str.toString(), error);
        } else {
            this.log(level, "HTTP", "RESPONSE_SENT", requestId, message, null, error);
        }
    }

    @Override
    public void logUWS(UWSLog.LogLevel level, Object obj, String event, String message, Throwable error) {
        if (level == null) {
            UWSLog.LogLevel logLevel = level = error != null ? UWSLog.LogLevel.ERROR : UWSLog.LogLevel.INFO;
        }
        if (!this.canLog(level)) {
            return;
        }
        String report = null;
        if (event != null && event.equalsIgnoreCase("BACKUPED") && obj != null && obj.getClass().getName().equals("[I")) {
            int[] backupReport = (int[])obj;
            report = backupReport.length == 2 ? "(" + backupReport[0] + "/" + backupReport[1] + " jobs backuped for this user)" : "(" + backupReport[0] + "/" + backupReport[1] + " jobs backuped ; " + backupReport[2] + "/" + backupReport[3] + " users backuped)";
        } else if (event != null && event.equalsIgnoreCase("RESTORED") && obj != null && obj.getClass().getName().equals("[I")) {
            int[] restoreReport = (int[])obj;
            report = "(" + restoreReport[0] + "/" + restoreReport[1] + " jobs restored ; " + restoreReport[2] + "/" + restoreReport[3] + " users restored)";
        }
        this.log(level, "UWS", event, null, message, report, error);
    }

    @Override
    public void logJob(UWSLog.LogLevel level, UWSJob job, String event, String message, Throwable error) {
        this.log(level, "JOB", event, job == null ? null : job.getJobId(), message, null, error);
    }

    @Override
    public void logThread(UWSLog.LogLevel level, Thread thread, String event, String message, Throwable error) {
        if (thread != null) {
            if (level == null) {
                UWSLog.LogLevel logLevel = level = error != null ? UWSLog.LogLevel.ERROR : UWSLog.LogLevel.INFO;
            }
            if (!this.canLog(level)) {
                return;
            }
            StringBuffer str = new StringBuffer();
            str.append(thread.getName()).append(" (thread ID: ").append(thread.getId()).append(")");
            str.append(" is ").append((Object)thread.getState());
            str.append(" in the group " + thread.getThreadGroup().getName());
            str.append(" where ").append(thread.getThreadGroup().activeCount()).append(" threads are active");
            this.log(level, "THREAD", event, thread.getName(), message, str.toString(), error);
        } else {
            this.log(level, "THREAD", event, null, message, null, error);
        }
    }
}

