/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.AbstractTableData;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.PaddingException;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ByteFormatter;
import nom.tam.util.ByteParser;
import nom.tam.util.Cursor;
import nom.tam.util.FormatException;
import nom.tam.util.RandomAccess;

public class AsciiTable
extends AbstractTableData {
    private static final int MAX_INTEGER_LENGTH = 10;
    private static final int FLOAT_MAX_LENGTH = 16;
    private static final int LONG_MAX_LENGTH = 20;
    private static final int INT_MAX_LENGTH = 10;
    private static final int DOUBLE_MAX_LENGTH = 24;
    private static final Logger LOG = Logger.getLogger(AsciiTable.class.getName());
    private int nRows;
    private int nFields;
    private int rowLen;
    private String[] nulls;
    private Class<?>[] types;
    private int[] offsets;
    private int[] lengths;
    private byte[] buffer;
    private boolean[] isNull;
    private Object[] data;
    private ByteParser bp;
    private ArrayDataInput currInput;

    public AsciiTable() {
        this.data = new Object[0];
        this.buffer = null;
        this.nFields = 0;
        this.nRows = 0;
        this.rowLen = 0;
        this.types = new Class[0];
        this.lengths = new int[0];
        this.offsets = new int[0];
        this.nulls = new String[0];
    }

    public AsciiTable(Header hdr) throws FitsException {
        this.nRows = hdr.getIntValue(Standard.NAXIS2);
        this.nFields = hdr.getIntValue(Standard.TFIELDS);
        this.rowLen = hdr.getIntValue(Standard.NAXIS1);
        this.types = new Class[this.nFields];
        this.offsets = new int[this.nFields];
        this.lengths = new int[this.nFields];
        this.nulls = new String[this.nFields];
        for (int i = 0; i < this.nFields; ++i) {
            this.offsets[i] = hdr.getIntValue(Standard.TBCOLn.n(i + 1)) - 1;
            String s = hdr.getStringValue(Standard.TFORMn.n(i + 1));
            if (this.offsets[i] < 0 || s == null) {
                throw new FitsException("Invalid Specification for column:" + (i + 1));
            }
            s = s.trim();
            char c = s.charAt(0);
            if ((s = s.substring(1)).indexOf(46) > 0) {
                s = s.substring(0, s.indexOf(46));
            }
            this.lengths[i] = Integer.parseInt(s);
            switch (c) {
                case 'A': {
                    this.types[i] = String.class;
                    break;
                }
                case 'I': {
                    if (this.lengths[i] > 10) {
                        this.types[i] = Long.TYPE;
                        break;
                    }
                    this.types[i] = Integer.TYPE;
                    break;
                }
                case 'E': 
                case 'F': {
                    this.types[i] = Float.TYPE;
                    break;
                }
                case 'D': {
                    this.types[i] = Double.TYPE;
                    break;
                }
                default: {
                    throw new FitsException("could not parse column type of ascii table");
                }
            }
            this.nulls[i] = hdr.getStringValue(Standard.TNULLn.n(i + 1));
            if (this.nulls[i] == null) continue;
            this.nulls[i] = this.nulls[i].trim();
        }
    }

    int addColInfo(int col, Cursor<String, HeaderCard> iter) throws HeaderCardException {
        String tform = null;
        if (this.types[col] == String.class) {
            tform = "A" + this.lengths[col];
        } else if (this.types[col] == Integer.TYPE || this.types[col] == Long.TYPE) {
            tform = "I" + this.lengths[col];
        } else if (this.types[col] == Float.TYPE) {
            tform = "E" + this.lengths[col] + ".0";
        } else if (this.types[col] == Double.TYPE) {
            tform = "D" + this.lengths[col] + ".0";
        }
        Standard.context(AsciiTable.class);
        IFitsHeader key = Standard.TFORMn.n(col + 1);
        iter.add(new HeaderCard(key.key(), tform, key.comment()));
        key = Standard.TBCOLn.n(col + 1);
        iter.add(new HeaderCard(key.key(), this.offsets[col] + 1, key.comment()));
        Standard.context(null);
        return this.lengths[col];
    }

    @Override
    public int addColumn(Object newCol) throws FitsException {
        int maxLen = 1;
        if (newCol instanceof String[]) {
            String[] sa;
            for (String element : sa = (String[])newCol) {
                if (element == null || element.length() <= maxLen) continue;
                maxLen = element.length();
            }
        } else if (newCol instanceof double[]) {
            maxLen = 24;
        } else if (newCol instanceof int[]) {
            maxLen = 10;
        } else if (newCol instanceof long[]) {
            maxLen = 20;
        } else if (newCol instanceof float[]) {
            maxLen = 16;
        } else {
            throw new FitsException("Adding invalid type to ASCII table");
        }
        this.addColumn(newCol, maxLen);
        this.buffer = null;
        return this.nFields;
    }

    public int addColumn(Object newCol, int length) throws FitsException {
        if (this.nFields > 0 && Array.getLength(newCol) != this.nRows) {
            throw new FitsException("New column has different number of rows");
        }
        if (this.nFields == 0) {
            this.nRows = Array.getLength(newCol);
        }
        Object[] newData = new Object[this.nFields + 1];
        int[] newOffsets = new int[this.nFields + 1];
        int[] newLengths = new int[this.nFields + 1];
        Class[] newTypes = new Class[this.nFields + 1];
        String[] newNulls = new String[this.nFields + 1];
        System.arraycopy(this.data, 0, newData, 0, this.nFields);
        System.arraycopy(this.offsets, 0, newOffsets, 0, this.nFields);
        System.arraycopy(this.lengths, 0, newLengths, 0, this.nFields);
        System.arraycopy(this.types, 0, newTypes, 0, this.nFields);
        System.arraycopy(this.nulls, 0, newNulls, 0, this.nFields);
        this.data = newData;
        this.offsets = newOffsets;
        this.lengths = newLengths;
        this.types = newTypes;
        this.nulls = newNulls;
        newData[this.nFields] = newCol;
        this.offsets[this.nFields] = this.rowLen + 1;
        this.lengths[this.nFields] = length;
        this.types[this.nFields] = ArrayFuncs.getBaseClass(newCol);
        this.rowLen += length + 1;
        if (this.isNull != null) {
            boolean[] newIsNull = new boolean[this.nRows * (this.nFields + 1)];
            int add = 0;
            for (int i = 0; i < this.isNull.length; ++i) {
                if (i % this.nFields == 0) {
                    ++add;
                }
                if (!this.isNull[i]) continue;
                newIsNull[i + add] = true;
            }
            this.isNull = newIsNull;
        }
        ++this.nFields;
        this.buffer = null;
        return this.nFields;
    }

    @Override
    public int addRow(Object[] newRow) throws FitsException {
        try {
            if (this.nFields == 0) {
                for (Object element : newRow) {
                    this.addColumn(element);
                }
            } else {
                for (int i = 0; i < this.nFields; ++i) {
                    Object o = ArrayFuncs.newInstance(this.types[i], this.nRows + 1);
                    System.arraycopy(this.data[i], 0, o, 0, this.nRows);
                    System.arraycopy(newRow[i], 0, o, this.nRows, 1);
                    this.data[i] = o;
                }
                ++this.nRows;
            }
            this.buffer = null;
            return this.nRows;
        }
        catch (FitsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FitsException("Error deleting row:" + e.getMessage(), e);
        }
    }

    @Override
    public void deleteColumns(int start, int len) throws FitsException {
        this.ensureData();
        Object[] newData = new Object[this.nFields - len];
        int[] newOffsets = new int[this.nFields - len];
        int[] newLengths = new int[this.nFields - len];
        Class[] newTypes = new Class[this.nFields - len];
        String[] newNulls = new String[this.nFields - len];
        System.arraycopy(this.data, 0, newData, 0, start);
        System.arraycopy(this.lengths, 0, newLengths, 0, start);
        System.arraycopy(this.types, 0, newTypes, 0, start);
        System.arraycopy(this.nulls, 0, newNulls, 0, start);
        System.arraycopy(this.data, start + len, newData, start, this.nFields - start - len);
        System.arraycopy(this.lengths, start + len, newLengths, start, this.nFields - start - len);
        System.arraycopy(this.types, start + len, newTypes, start, this.nFields - start - len);
        System.arraycopy(this.nulls, start + len, newNulls, start, this.nFields - start - len);
        for (int i = start; i < start + len; ++i) {
            this.rowLen -= this.lengths[i] + 1;
        }
        this.data = newData;
        this.offsets = newOffsets;
        this.lengths = newLengths;
        this.types = newTypes;
        this.nulls = newNulls;
        if (this.isNull != null) {
            boolean found = false;
            boolean[] newIsNull = new boolean[this.nRows * (this.nFields - len)];
            for (int i = 0; i < this.nRows; ++i) {
                int col;
                int oldOff = this.nFields * i;
                int newOff = (this.nFields - len) * i;
                for (col = 0; col < start; ++col) {
                    newIsNull[newOff + col] = this.isNull[oldOff + col];
                    found = found || this.isNull[oldOff + col];
                }
                for (col = start + len; col < this.nFields; ++col) {
                    newIsNull[newOff + col - len] = this.isNull[oldOff + col];
                    found = found || this.isNull[oldOff + col];
                }
            }
            this.isNull = (boolean[])(found ? newIsNull : null);
        }
        this.buffer = null;
        this.nFields -= len;
    }

    @Override
    public void deleteRows(int start, int len) throws FitsException {
        try {
            if (this.nRows == 0 || start < 0 || start >= this.nRows || len <= 0) {
                return;
            }
            if (start + len > this.nRows) {
                len = this.nRows - start;
            }
            this.ensureData();
            for (int i = 0; i < this.nFields; ++i) {
                Object o = ArrayFuncs.newInstance(this.types[i], this.nRows - len);
                System.arraycopy(this.data[i], 0, o, 0, start);
                System.arraycopy(this.data[i], start + len, o, start, this.nRows - len - start);
                this.data[i] = o;
            }
            this.nRows -= len;
        }
        catch (FitsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FitsException("Error deleting row:" + e.getMessage(), e);
        }
    }

    private void ensureData() throws FitsException {
        this.getData();
    }

    private boolean extractElement(int offset, int length, Object[] array, int col, int row, String nullFld) throws FitsException {
        block9: {
            this.bp.setOffset(offset);
            if (nullFld != null) {
                String s = this.bp.getString(length);
                if (s.trim().equals(nullFld)) {
                    return false;
                }
                this.bp.skip(-length);
            }
            try {
                if (array[col] instanceof String[]) {
                    ((String[])array[col])[row] = this.bp.getString(length);
                    break block9;
                }
                if (array[col] instanceof int[]) {
                    ((int[])array[col])[row] = this.bp.getInt(length);
                    break block9;
                }
                if (array[col] instanceof float[]) {
                    ((float[])array[col])[row] = this.bp.getFloat(length);
                    break block9;
                }
                if (array[col] instanceof double[]) {
                    ((double[])array[col])[row] = this.bp.getDouble(length);
                    break block9;
                }
                if (array[col] instanceof long[]) {
                    ((long[])array[col])[row] = this.bp.getLong(length);
                    break block9;
                }
                throw new FitsException("Invalid type for ASCII table conversion:" + array[col]);
            }
            catch (FormatException e) {
                throw new FitsException("Error parsing data at row,col:" + row + "," + col + "  " + e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillHeader(Header hdr) {
        try {
            Standard.context(AsciiTable.class);
            hdr.setXtension("TABLE");
            hdr.setBitpix(8);
            hdr.setNaxes(2);
            hdr.setNaxis(1, this.rowLen);
            hdr.setNaxis(2, this.nRows);
            Cursor<String, HeaderCard> iter = hdr.iterator();
            iter.setKey(Standard.NAXIS2.key());
            iter.next();
            iter.add(new HeaderCard(Standard.PCOUNT.key(), 0, Standard.PCOUNT.comment()));
            iter.add(new HeaderCard(Standard.GCOUNT.key(), 1, Standard.GCOUNT.comment()));
            iter.add(new HeaderCard(Standard.TFIELDS.key(), this.nFields, Standard.TFIELDS.comment()));
            for (int i = 0; i < this.nFields; ++i) {
                this.addColInfo(i, iter);
            }
        }
        catch (HeaderCardException e) {
            LOG.log(Level.SEVERE, "ImpossibleException in fillHeader:" + e.getMessage(), e);
        }
        finally {
            Standard.context(null);
        }
    }

    private void getBuffer(int size, long offset) throws IOException, FitsException {
        if (this.currInput == null) {
            throw new IOException("No stream open to read");
        }
        this.buffer = new byte[size];
        if (offset != 0L) {
            FitsUtil.reposition(this.currInput, offset);
        }
        this.currInput.readFully(this.buffer);
        this.bp = new ByteParser(this.buffer);
    }

    @Override
    public Object getColumn(int col) throws FitsException {
        this.ensureData();
        return this.data[col];
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public Object getData() throws FitsException {
        if (this.data == null) {
            this.data = new Object[this.nFields];
            for (int i = 0; i < this.nFields; ++i) {
                this.data[i] = ArrayFuncs.newInstance(this.types[i], this.nRows);
            }
            if (this.buffer == null) {
                long newOffset = FitsUtil.findOffset(this.currInput);
                try {
                    this.getBuffer(this.nRows * this.rowLen, this.fileOffset);
                }
                catch (IOException e) {
                    throw new FitsException("Error in deferred read -- file closed prematurely?:" + e.getMessage(), e);
                }
                FitsUtil.reposition(this.currInput, newOffset);
            }
            this.bp.setOffset(0);
            for (int i = 0; i < this.nRows; ++i) {
                int rowOffset = this.rowLen * i;
                for (int j = 0; j < this.nFields; ++j) {
                    if (this.extractElement(rowOffset + this.offsets[j], this.lengths[j], this.data, j, i, this.nulls[j])) continue;
                    if (this.isNull == null) {
                        this.isNull = new boolean[this.nRows * this.nFields];
                    }
                    this.isNull[j + i * this.nFields] = true;
                }
            }
        }
        return this.data;
    }

    @Override
    public Object getElement(int row, int col) throws FitsException {
        if (this.data != null) {
            return this.singleElement(row, col);
        }
        return this.parseSingleElement(row, col);
    }

    @Override
    public int getNCols() {
        return this.nFields;
    }

    @Override
    public int getNRows() {
        return this.nRows;
    }

    @Override
    public Object[] getRow(int row) throws FitsException {
        if (this.data != null) {
            return this.singleRow(row);
        }
        return this.parseSingleRow(row);
    }

    public int getRowLen() {
        return this.rowLen;
    }

    @Override
    protected long getTrueSize() {
        return (long)this.nRows * (long)this.rowLen;
    }

    public boolean isNull(int row, int col) {
        if (this.isNull != null) {
            return this.isNull[row * this.nFields + col];
        }
        return false;
    }

    private Object parseSingleElement(int row, int col) throws FitsException {
        Object[] res = new Object[1];
        try {
            this.getBuffer(this.lengths[col], this.fileOffset + (long)row * (long)this.rowLen + (long)this.offsets[col]);
        }
        catch (IOException e) {
            this.buffer = null;
            throw new FitsException("Unable to read element");
        }
        res[0] = ArrayFuncs.newInstance(this.types[col], 1);
        if (this.extractElement(0, this.lengths[col], res, 0, 0, this.nulls[col])) {
            this.buffer = null;
            return res[0];
        }
        this.buffer = null;
        return null;
    }

    private Object[] parseSingleRow(int row) throws FitsException {
        Object[] res = new Object[this.nFields];
        try {
            this.getBuffer(this.rowLen, this.fileOffset + (long)row * (long)this.rowLen);
        }
        catch (IOException e) {
            throw new FitsException("Unable to read row");
        }
        for (int i = 0; i < this.nFields; ++i) {
            res[i] = ArrayFuncs.newInstance(this.types[i], 1);
            if (this.extractElement(this.offsets[i], this.lengths[i], res, i, 0, this.nulls[i])) continue;
            res[i] = null;
        }
        this.buffer = null;
        return res;
    }

    @Override
    public void read(ArrayDataInput str) throws FitsException {
        try {
            this.setFileOffset(str);
            this.currInput = str;
            if (str instanceof RandomAccess) {
                str.skipAllBytes((long)this.nRows * (long)this.rowLen);
            } else {
                if ((long)this.rowLen * (long)this.nRows > Integer.MAX_VALUE) {
                    throw new FitsException("Cannot read ASCII table > 2 GB");
                }
                this.getBuffer(this.rowLen * this.nRows, 0L);
            }
            str.skipAllBytes(FitsUtil.padding(this.nRows * this.rowLen));
        }
        catch (EOFException e) {
            throw new PaddingException("EOF skipping padding after ASCII Table", this, e);
        }
        catch (IOException e) {
            throw new FitsException("Error skipping padding after ASCII Table", e);
        }
    }

    @Override
    public void setColumn(int col, Object newData) throws FitsException {
        this.ensureData();
        if (col < 0 || col >= this.nFields || newData.getClass() != this.data[col].getClass() || Array.getLength(newData) != Array.getLength(this.data[col])) {
            throw new FitsException("Invalid column/column mismatch:" + col);
        }
        this.data[col] = newData;
        this.buffer = null;
    }

    @Override
    public void setElement(int row, int col, Object newData) throws FitsException {
        this.ensureData();
        try {
            System.arraycopy(newData, 0, this.data[col], row, 1);
        }
        catch (Exception e) {
            throw new FitsException("Incompatible element:" + row + "," + col);
        }
        this.setNull(row, col, false);
        this.buffer = null;
    }

    public void setNull(int row, int col, boolean flag) {
        if (flag) {
            if (this.isNull == null) {
                this.isNull = new boolean[this.nRows * this.nFields];
            }
            this.isNull[col + row * this.nFields] = true;
        } else if (this.isNull != null) {
            this.isNull[col + row * this.nFields] = false;
        }
        this.buffer = null;
    }

    void setNullString(int col, String newNull) {
        if (col >= 0 && col < this.nulls.length) {
            this.nulls[col] = newNull;
        }
    }

    @Override
    public void setRow(int row, Object[] newData) throws FitsException {
        if (row < 0 || row > this.nRows) {
            throw new FitsException("Invalid row in setRow");
        }
        this.ensureData();
        for (int i = 0; i < this.nFields; ++i) {
            try {
                System.arraycopy(newData[i], 0, this.data[i], row, 1);
            }
            catch (Exception e) {
                throw new FitsException("Unable to modify row: incompatible data:" + row);
            }
            this.setNull(row, i, false);
        }
        this.buffer = null;
    }

    private Object singleElement(int row, int col) {
        Object res = null;
        if (this.isNull == null || !this.isNull[row * this.nFields + col]) {
            res = ArrayFuncs.newInstance(this.types[col], 1);
            System.arraycopy(this.data[col], row, res, 0, 1);
        }
        return res;
    }

    private Object[] singleRow(int row) {
        Object[] res = new Object[this.nFields];
        for (int i = 0; i < this.nFields; ++i) {
            if (this.isNull != null && this.isNull[row * this.nFields + i]) continue;
            res[i] = ArrayFuncs.newInstance(this.types[i], 1);
            System.arraycopy(this.data[i], row, res[i], 0, 1);
        }
        return res;
    }

    @Override
    public void updateAfterDelete(int oldNCol, Header hdr) throws FitsException {
        int i;
        int offset = 0;
        for (i = 0; i < this.nFields; ++i) {
            this.offsets[i] = offset;
            hdr.addValue(Standard.TBCOLn.n(i + 1), offset + 1);
            offset += this.lengths[i] + 1;
        }
        for (i = this.nFields; i < oldNCol; ++i) {
            hdr.deleteKey(Standard.TBCOLn.n(i + 1));
        }
        hdr.addValue(Standard.NAXIS1, this.rowLen);
    }

    @Override
    public void write(ArrayDataOutput str) throws FitsException {
        this.ensureData();
        if (this.buffer == null) {
            if (this.data == null) {
                throw new FitsException("Attempt to write undefined ASCII Table");
            }
            if ((long)this.nRows * (long)this.rowLen > Integer.MAX_VALUE) {
                throw new FitsException("Cannot write ASCII table > 2 GB");
            }
            this.buffer = new byte[this.nRows * this.rowLen];
            this.bp = new ByteParser(this.buffer);
            for (int i = 0; i < this.buffer.length; ++i) {
                this.buffer[i] = 32;
            }
            ByteFormatter bf = new ByteFormatter();
            for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < this.nFields; ++j) {
                    int offset = i * this.rowLen + this.offsets[j];
                    int len = this.lengths[j];
                    if (this.isNull != null && this.isNull[i * this.nFields + j]) {
                        if (this.nulls[j] == null) {
                            throw new FitsException("No null value set when needed");
                        }
                        bf.format(this.nulls[j], this.buffer, offset, len);
                        continue;
                    }
                    if (this.types[j] == String.class) {
                        String[] s = (String[])this.data[j];
                        bf.format(s[i], this.buffer, offset, len);
                        continue;
                    }
                    if (this.types[j] == Integer.TYPE) {
                        int[] ia = (int[])this.data[j];
                        bf.format(ia[i], this.buffer, offset, len);
                        continue;
                    }
                    if (this.types[j] == Float.TYPE) {
                        float[] fa = (float[])this.data[j];
                        bf.format(fa[i], this.buffer, offset, len);
                        continue;
                    }
                    if (this.types[j] == Double.TYPE) {
                        double[] da = (double[])this.data[j];
                        bf.format(da[i], this.buffer, offset, len);
                        continue;
                    }
                    if (this.types[j] != Long.TYPE) continue;
                    long[] la = (long[])this.data[j];
                    bf.format(la[i], this.buffer, offset, len);
                }
            }
        }
        try {
            str.write(this.buffer);
            FitsUtil.pad(str, this.buffer.length, (byte)32);
        }
        catch (IOException e) {
            throw new FitsException("Error writing ASCII Table data");
        }
    }
}

