#ifndef OBSCOREKEYS_HPP
#define OBSCOREKEYS_HPP

#include <string>
#include <set>


namespace ObsCoreKeys
{
   const std::set<std::string> strKeys
      = {
         "OBJECT",    
         "DATE-OBS",  
         "DATE-END",  
         "CUNIT1",  
         "CUNIT2",  
         "CUNIT3"
      };
   const std::set<std::string> uintKeys
      = {
         "NAXIS1",
         "NAXIS2",
         "NAXIS3"
      };
   const std::set<std::string> doubleKeys
      = {
         "CDELT1",            
         "CDELT2",
         "CDELT3"
      };

   inline std::set<std::string> add_str_keys(const std::set<std::string> strSet1, std::set<std::string> strSet2)
            { std::set<std::string> str_set{strSet1}; str_set.insert(strSet2.begin(),strSet2.end()); return str_set;}
};

#endif

