
#include "json.hpp"
#include "io.hpp"
#include "my_assert.hpp"
#include "mcutout.hpp"
#include "cutout_nljson.hpp" // needs json<->coordinates conversions
#include "mcutout_nljson.hpp"

#include <string>

using namespace std;

using json = nlohmann::json;

NLOHMANN_JSON_SERIALIZE_ENUM( content_type, {
      {content_type::FILENAME, "FILENAME"},
      {content_type::BAD_REQUEST, "BAD_REQUEST"},
      {content_type::SERVICE_ERROR, "SERVICE_ERROR"}});


void to_json(json& j, const cut_param_s& p)
{
   j = json{
      {"pubdid", p.pubdid},
         {"coord", p.coord},
         {"countNullVals", p.countNullVals},
         {"filename", p.filename},
         {"hdunum", p.hdunum},
         {"extra_cards", p.cards}
   };
}


void from_json(const json& j, cut_param_s& p) 
{
   j.at("pubdid").get_to(p.pubdid);

   const json& jw = j.at("coord");
   struct coordinates temp_coord;
   from_json(jw, temp_coord);
   p.coord = temp_coord;

   if(j.contains("countNullVals"))
      j.at("countNullVals").get_to(p.countNullVals);
   else
      p.countNullVals = false;

   j.at("filename").get_to(p.filename);
   j.at("hdunum").get_to(p.hdunum);

   if(j.contains("extra_cards"))
   {
      json jcards = j.at("extra_cards");
      p.cards = jcards.get<std::vector<struct fits_card>>();
   }
}



void to_json(json& j, const mcutout_res_s& p)
{
   j = json{
      {"filesize", p.filesize},
         {"filename", p.tgz_filename},
         {"responses", p.responses}  // arr of cut_resp_s
   };
}


void to_json(json& j, const cut_resp_s& p)
{
   j = json{ {"input", p.input}, {"type", p.type}, {"content", p.content} };
}

void from_json(const json& j, cut_resp_s& p)
{
   j.at("input").get_to(p.input);  // cut_param_s
   j.at("type").get_to(p.type);
   j.at("content").get_to(p.content);
}


