
#include "cutout.hpp"
#include "cutout_nljson.hpp"
#include "mcutout.hpp"
#include "mcutout_nljson.hpp"
#include "json.hpp"

#include <vector>
#include <string>

/* All nlohmann-json exception are json::exception <- std::exception.
 * So let them be caught by std::excpetion as 'Internal errors' in rpc-call's infinite loop,
 * assuming all API syntactic errors were caught in servlet API parser */

class json_reply
{
   public:
      json_reply() {j = nlohmann::json::object();};
      void put_cutout_result(cutout_res_s res) { j = res; };
      void put_mcutout_result(mcutout_res_s res) { j = res; };
      std::string json_str() { return j.dump();};

   private:
      nlohmann::json j;
};

