/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.rice;

import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.algorithm.rice.RiceCompressOption;
import nom.tam.fits.compression.provider.param.base.CompressHeaderParameter;
import nom.tam.fits.header.Compression;

public final class RiceBytePixParameter
extends CompressHeaderParameter<RiceCompressOption> {
    public RiceBytePixParameter(RiceCompressOption riceCompressOption) {
        super("BYTEPIX", riceCompressOption);
    }

    @Override
    public void getValueFromHeader(Header header) {
        HeaderCard value = this.findZVal(header);
        if (value != null) {
            ((RiceCompressOption)this.getOption()).setBytePix(value.getValue(Integer.class, RiceCompressOption.DEFAULT_RICE_BYTEPIX));
        } else {
            ((RiceCompressOption)this.getOption()).setBytePix(RiceCompressOption.DEFAULT_RICE_BYTEPIX);
        }
    }

    @Override
    public void setValueInHeader(Header header) throws HeaderCardException {
        int zvalIndex = this.nextFreeZVal(header);
        header.addValue(Compression.ZNAMEn.n(zvalIndex), this.getName());
        header.addValue(Compression.ZVALn.n(zvalIndex), ((RiceCompressOption)this.getOption()).getBytePix());
    }
}

