/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import java.nio.Buffer;
import nom.tam.image.compression.tile.TileCompressionOperation;
import nom.tam.image.compression.tile.TileCompressor;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.image.tile.operation.ITileOperationInitialisation;
import nom.tam.image.tile.operation.TileArea;

final class TileCompressorInitialisation
implements ITileOperationInitialisation<TileCompressionOperation> {
    private final Buffer buffer;
    private final TiledImageCompressionOperation imageTilesOperation;
    private int compressedOffset = 0;

    protected TileCompressorInitialisation(TiledImageCompressionOperation imageTilesOperation, Buffer buffer) {
        this.imageTilesOperation = imageTilesOperation;
        this.buffer = buffer;
    }

    @Override
    public TileCompressionOperation createTileOperation(int tileIndex, TileArea area) {
        return new TileCompressor(this.imageTilesOperation, tileIndex, area);
    }

    @Override
    public void init(TileCompressionOperation tileOperation) {
        tileOperation.setCompressedOffset(this.compressedOffset);
        tileOperation.setWholeImageBuffer(this.buffer);
        tileOperation.setWholeImageCompressedBuffer(this.imageTilesOperation.getCompressedWholeArea());
        this.compressedOffset += tileOperation.getPixelSize();
    }

    @Override
    public void tileCount(int tileCount) {
    }
}

