/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.client.call;

import it.inaf.ia2.client.BaseCall;
import it.inaf.ia2.rap.client.RapClient;
import it.inaf.ia2.rap.data.RapUser;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GetUserCall<T>
extends BaseCall<RapClient<T>> {
    public GetUserCall(RapClient client) {
        super(client);
    }

    public RapUser getUser(String userId, T context) {
        Object wsUri = ((RapClient)this.client).getWsUserUri().toString();
        if (!((String)wsUri).endsWith("/")) {
            wsUri = (String)wsUri + "/";
        }
        wsUri = (String)wsUri + userId;
        HttpRequest request = ((RapClient)this.client).newAuthRequest(URI.create((String)wsUri), context).header("Accept", "application/json").GET().build();
        return ((RapClient)this.client).call(request, HttpResponse.BodyHandlers.ofInputStream(), 200, res -> GetUserCall.parseJson(res, RapUser.class));
    }

    public List<RapUser> getUsers(String searchText, T context) {
        if (searchText == null || searchText.trim().isEmpty()) {
            return new ArrayList<RapUser>();
        }
        String uri = ((RapClient)this.client).getWsUserUri().toString() + "?search=" + URLEncoder.encode(searchText, StandardCharsets.UTF_8);
        HttpRequest request = ((RapClient)this.client).newAuthRequest(URI.create(uri), context).header("Accept", "application/json").GET().build();
        return ((RapClient)this.client).call(request, HttpResponse.BodyHandlers.ofInputStream(), 200, res -> GetUserCall.parseJsonList(res, RapUser.class));
    }

    public List<RapUser> getUsers(Set<String> identifiers, T context) {
        if (identifiers.isEmpty()) {
            return new ArrayList<RapUser>();
        }
        String uri = ((RapClient)this.client).getWsUserUri().toString() + "?identifiers=" + String.join((CharSequence)",", identifiers);
        HttpRequest request = ((RapClient)this.client).newAuthRequest(URI.create(uri), context).header("Accept", "application/json").GET().build();
        return ((RapClient)this.client).call(request, HttpResponse.BodyHandlers.ofInputStream(), 200, res -> GetUserCall.parseJsonList(res, RapUser.class));
    }
}

