/*
 * Decompiled with CFR 0.152.
 */
package uws.job.parameters;

import java.io.Serializable;
import uws.UWSException;
import uws.job.parameters.InputParamController;

public class ExecutionDurationController
implements InputParamController,
Serializable {
    private static final long serialVersionUID = 1L;
    protected long defaultDuration = 0L;
    protected long maxDuration = 0L;
    protected boolean allowModification = true;

    public ExecutionDurationController() {
    }

    public ExecutionDurationController(long defaultDuration, long maxDuration, boolean allowModification) {
        this.setDefaultExecutionDuration(defaultDuration);
        this.setMaxExecutionDuration(maxDuration);
        this.allowModification(allowModification);
    }

    @Override
    public Object getDefault() {
        return this.defaultDuration > 0L ? this.defaultDuration : this.getMaxExecutionDuration();
    }

    @Override
    public Object check(Object value) throws UWSException {
        if (value == null) {
            return this.getDefault();
        }
        Long duration = null;
        if (value instanceof Long) {
            duration = (Long)value;
        } else if (value instanceof Integer) {
            duration = (long)((Integer)value);
        } else if (value instanceof String) {
            String strValue = (String)value;
            try {
                duration = Long.parseLong(strValue);
            }
            catch (NumberFormatException nfe) {
                throw new UWSException(400, "Wrong format for the maximum duration parameter: \"" + strValue + "\"! It should be a long numeric value between " + 0L + " and " + this.maxDuration + " (Default value: " + this.defaultDuration + ").");
            }
        } else {
            throw new UWSException(500, "Wrong type for the maximum duration parameter: class \"" + value.getClass().getName() + "\"! It should be long or a string containing only a long value.");
        }
        if (duration <= 0L) {
            duration = 0L;
        }
        if (this.maxDuration > 0L && (duration > this.maxDuration || duration <= 0L)) {
            duration = this.maxDuration;
        }
        return duration;
    }

    @Deprecated
    public final long getDefaultExecutionDuration() {
        return (Long)this.getDefault();
    }

    public final boolean setDefaultExecutionDuration(long defaultExecutionDuration) {
        long l = defaultExecutionDuration = defaultExecutionDuration <= 0L ? 0L : defaultExecutionDuration;
        if (defaultExecutionDuration != 0L && this.maxDuration != 0L && defaultExecutionDuration > this.maxDuration) {
            return false;
        }
        this.defaultDuration = defaultExecutionDuration;
        return true;
    }

    public final long getMaxExecutionDuration() {
        return this.maxDuration;
    }

    public final void setMaxExecutionDuration(long maxExecutionDuration) {
        long l = this.maxDuration = maxExecutionDuration <= 0L ? 0L : maxExecutionDuration;
        if (this.defaultDuration != 0L && this.maxDuration != 0L && this.defaultDuration > this.maxDuration) {
            this.defaultDuration = this.maxDuration;
        }
    }

    @Override
    public final boolean allowModification() {
        return this.allowModification;
    }

    public final void allowModification(boolean allowModification) {
        this.allowModification = allowModification;
    }
}

