/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.AcceptHeader;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.JobList;
import uws.job.JobThread;
import uws.job.serializer.JSONSerializer;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.XMLSerializer;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.UWSFactory;
import uws.service.UWSUrl;
import uws.service.UserIdentifier;
import uws.service.actions.AddJob;
import uws.service.actions.DestroyJob;
import uws.service.actions.GetJobParam;
import uws.service.actions.JobSummary;
import uws.service.actions.ListJobs;
import uws.service.actions.SetJobParam;
import uws.service.actions.SetUWSParameter;
import uws.service.actions.ShowHomePage;
import uws.service.actions.UWSAction;
import uws.service.backup.UWSBackupManager;
import uws.service.error.DefaultUWSErrorWriter;
import uws.service.error.ServiceErrorWriter;
import uws.service.file.UWSFileManager;
import uws.service.log.DefaultUWSLog;
import uws.service.log.UWSLog;
import uws.service.request.RequestParser;
import uws.service.wait.BlockingPolicy;

public class UWSService
implements UWS {
    protected String name = null;
    protected String description = null;
    protected final Map<String, JobList> mapJobLists;
    protected UWSUrl urlInterpreter = null;
    protected final Map<String, UWSSerializer> serializers;
    protected String defaultSerializer = null;
    protected UWSSerializer choosenSerializer = null;
    protected String homePage = null;
    protected boolean homeRedirection = false;
    protected String homePageMimeType = "text/html";
    protected final Vector<UWSAction> uwsActions;
    protected UWSAction executedAction = null;
    protected UserIdentifier userIdentifier = null;
    protected final UWSFactory factory;
    protected final UWSFileManager fileManager;
    protected UWSBackupManager backupManager;
    protected UWSLog logger;
    protected final RequestParser requestParser;
    protected ServiceErrorWriter errorWriter;
    protected BlockingPolicy waitPolicy = null;
    protected static String lastRequestID = null;

    public UWSService(UWSFactory jobFactory, UWSFileManager fileManager) throws UWSException {
        this(jobFactory, fileManager, (UWSLog)null);
    }

    public UWSService(UWSFactory jobFactory, UWSFileManager fileManager, UWSLog logger) throws UWSException {
        if (jobFactory == null) {
            throw new NullPointerException("Missing UWS factory! Can not create a UWSService.");
        }
        this.factory = jobFactory;
        if (fileManager == null) {
            throw new NullPointerException("Missing UWS file manager! Can not create a UWSService.");
        }
        this.fileManager = fileManager;
        this.logger = logger == null ? new DefaultUWSLog(this) : logger;
        this.requestParser = jobFactory.createRequestParser(fileManager);
        this.errorWriter = new DefaultUWSErrorWriter(this.logger);
        this.mapJobLists = new LinkedHashMap<String, JobList>();
        this.serializers = new HashMap<String, UWSSerializer>();
        this.addSerializer(new XMLSerializer());
        this.addSerializer(new JSONSerializer());
        this.uwsActions = new Vector();
        this.uwsActions.add(new ShowHomePage(this));
        this.uwsActions.add(new ListJobs(this));
        this.uwsActions.add(new AddJob(this));
        this.uwsActions.add(new SetUWSParameter(this));
        this.uwsActions.add(new DestroyJob(this));
        this.uwsActions.add(new JobSummary(this));
        this.uwsActions.add(new GetJobParam(this));
        this.uwsActions.add(new SetJobParam(this));
    }

    public UWSService(UWSFactory jobFactory, UWSFileManager fileManager, String baseURI) throws UWSException {
        this(jobFactory, fileManager, null, baseURI);
    }

    public UWSService(UWSFactory jobFactory, UWSFileManager fileManager, UWSLog logger, String baseURI) throws UWSException {
        this(jobFactory, fileManager, logger);
        try {
            this.urlInterpreter = new UWSUrl(baseURI);
            this.name = this.urlInterpreter.getUWSName();
            this.logger.logUWS(UWSLog.LogLevel.INFO, this, "INIT", "UWS successfully initialized!", null);
        }
        catch (NullPointerException ex) {
            logger.logUWS(UWSLog.LogLevel.FATAL, null, "INIT", "Invalid base UWS URI: " + baseURI + "! You should check the configuration of the service.", ex);
            throw new UWSException(400, (Throwable)ex, "Invalid base UWS URI (" + baseURI + ")!");
        }
    }

    public UWSService(UWSFactory jobFactory, UWSFileManager fileManager, UWSUrl urlInterpreter) throws UWSException {
        this(jobFactory, fileManager, null, urlInterpreter);
    }

    public UWSService(UWSFactory jobFactory, UWSFileManager fileManager, UWSLog logger, UWSUrl urlInterpreter) throws UWSException {
        this(jobFactory, fileManager, logger);
        this.setUrlInterpreter(urlInterpreter);
        if (this.urlInterpreter != null) {
            this.logger.logUWS(UWSLog.LogLevel.INFO, this, "INIT", "UWS successfully initialized.", null);
        }
    }

    @Override
    public void destroy() {
        if (this.backupManager != null) {
            this.backupManager.setEnabled(true);
            this.backupManager.saveAll();
            this.backupManager.setEnabled(false);
        }
        for (JobList jl : this.mapJobLists.values()) {
            jl.getExecutionManager().stopAll();
            jl.getDestructionManager().stop();
        }
        JobThread.tg.interrupt();
        if (this.logger != null) {
            this.logger.logUWS(UWSLog.LogLevel.INFO, this, "STOP", "UWS Service \"" + this.getName() + "\" stopped!", null);
        }
    }

    @Override
    public UWSLog getLogger() {
        return this.logger;
    }

    public final ServiceErrorWriter getErrorWriter() {
        return this.errorWriter;
    }

    public final void setErrorWriter(ServiceErrorWriter errorWriter) {
        if (errorWriter != null) {
            this.errorWriter = errorWriter;
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getBaseURI() {
        return this.urlInterpreter == null ? null : this.urlInterpreter.getBaseURI();
    }

    @Override
    public final UWSUrl getUrlInterpreter() {
        return this.urlInterpreter;
    }

    public final void setUrlInterpreter(UWSUrl urlInterpreter) {
        this.urlInterpreter = urlInterpreter;
        if (this.name == null && urlInterpreter != null) {
            this.name = urlInterpreter.getUWSName();
        }
        if (this.urlInterpreter != null) {
            this.urlInterpreter.setUwsURI(null);
        }
    }

    @Override
    public final UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public final void setUserIdentifier(UserIdentifier identifier) {
        this.userIdentifier = identifier;
    }

    @Override
    public final UWSFactory getFactory() {
        return this.factory;
    }

    @Override
    public final UWSFileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public final UWSBackupManager getBackupManager() {
        return this.backupManager;
    }

    public final void setBackupManager(UWSBackupManager backupManager) {
        this.backupManager = backupManager;
    }

    @Override
    public final RequestParser getRequestParser() {
        return this.requestParser;
    }

    public final BlockingPolicy getWaitPolicy() {
        return this.waitPolicy;
    }

    public final void setWaitPolicy(BlockingPolicy waitPolicy) {
        this.waitPolicy = waitPolicy;
    }

    public final String getHomePage() {
        return this.homePage;
    }

    public final boolean isHomePageRedirection() {
        return this.homeRedirection;
    }

    public final void setHomePage(URL homePageUrl, boolean redirect) {
        this.homePage = homePageUrl.toString();
        this.homeRedirection = redirect;
    }

    public final void setHomePage(String homePageURI) {
        this.homePage = homePageURI;
        this.homeRedirection = true;
    }

    public final boolean isDefaultHomePage() {
        return this.homePage == null;
    }

    public final void setDefaultHomePage() {
        this.homePage = null;
        this.homeRedirection = false;
    }

    public final String getHomePageMimeType() {
        return this.homePageMimeType;
    }

    public final void setHomePageMimeType(String mime) {
        this.homePageMimeType = mime == null || mime.trim().length() == 0 ? "text/html" : mime.trim();
    }

    public final String getDefaultSerializer() {
        return this.defaultSerializer;
    }

    public final void setDefaultSerializer(String mimeType) throws UWSException {
        if (!this.serializers.containsKey(mimeType)) {
            throw new UWSException(500, "Missing UWS serializer for the MIME types: " + mimeType + "! The default serializer won't be set.");
        }
        this.defaultSerializer = mimeType;
    }

    public final boolean addSerializer(UWSSerializer serializer) {
        if (serializer != null) {
            this.serializers.put(serializer.getMimeType(), serializer);
            if (this.serializers.size() == 1) {
                this.defaultSerializer = serializer.getMimeType();
            }
            return true;
        }
        return false;
    }

    public final boolean hasSerializerFor(String mimeType) {
        return this.serializers.containsKey(mimeType);
    }

    public final int getNbSerializers() {
        return this.serializers.size();
    }

    public final Iterator<UWSSerializer> getSerializers() {
        return this.serializers.values().iterator();
    }

    @Override
    public final UWSSerializer getSerializer(String mimeTypes) throws UWSException {
        this.choosenSerializer = null;
        if (mimeTypes != null) {
            AcceptHeader accept = new AcceptHeader(mimeTypes);
            List<String> lstMimeTypes = accept.getOrderedMimeTypes();
            for (int i = 0; this.choosenSerializer == null && i < lstMimeTypes.size(); ++i) {
                this.choosenSerializer = this.serializers.get(lstMimeTypes.get(i));
            }
        }
        if (this.choosenSerializer == null) {
            this.choosenSerializer = this.serializers.get(this.defaultSerializer);
            if (this.choosenSerializer == null) {
                throw new UWSException(500, "No UWS Serializer available neither for \"" + mimeTypes + "\" (given MIME types) nor \"" + this.defaultSerializer + "\" (default serializer MIME type) !");
            }
        }
        return this.choosenSerializer;
    }

    public final UWSSerializer getChoosenSerializer() {
        return this.choosenSerializer;
    }

    public final UWSSerializer removeSerializer(String mimeType) {
        return this.serializers.remove(mimeType);
    }

    public final String getXsltURL() {
        XMLSerializer serializer = (XMLSerializer)this.serializers.get("text/xml");
        if (serializer != null) {
            return serializer.getXSLTPath();
        }
        return null;
    }

    public final boolean setXsltURL(String xsltPath) {
        XMLSerializer serializer = (XMLSerializer)this.serializers.get("text/xml");
        if (serializer != null) {
            serializer.setXSLTPath(xsltPath);
            return true;
        }
        return false;
    }

    @Override
    public final Iterator<JobList> iterator() {
        return this.mapJobLists.values().iterator();
    }

    @Override
    public final JobList getJobList(String name) {
        return this.mapJobLists.get(name);
    }

    @Override
    public final int getNbJobList() {
        return this.mapJobLists.size();
    }

    @Override
    public final boolean addJobList(JobList jl) {
        if (jl == null) {
            return false;
        }
        if (this.mapJobLists.containsKey(jl.getName())) {
            return false;
        }
        try {
            jl.setUWS(this);
            this.mapJobLists.put(jl.getName(), jl);
        }
        catch (IllegalStateException ise) {
            this.logger.logUWS(UWSLog.LogLevel.ERROR, jl, "ADD_JOB_LIST", "The jobs list \"" + jl.getName() + "\" can not be added into the UWS " + this.getName() + ": it may already be associated with one!", ise);
            return false;
        }
        return true;
    }

    @Override
    public final boolean destroyJobList(String name) {
        return this.destroyJobList(this.mapJobLists.get(name));
    }

    public boolean destroyJobList(JobList jl) {
        if (jl == null) {
            return false;
        }
        if ((jl = this.mapJobLists.remove(jl.getName())) != null) {
            try {
                jl.clear();
                jl.setUWS(null);
            }
            catch (IllegalStateException ise) {
                this.logger.logUWS(UWSLog.LogLevel.WARNING, jl, "DESTROY_JOB_LIST", "Impossible to erase completely the association between the jobs list \"" + jl.getName() + "\" and the UWS \"" + this.getName() + "\"!", ise);
            }
        }
        return jl != null;
    }

    public final void destroyAllJobLists() {
        ArrayList<String> jlNames = new ArrayList<String>(this.mapJobLists.keySet());
        for (String jlName : jlNames) {
            this.destroyJobList(jlName);
        }
    }

    public final boolean addUWSAction(UWSAction action) {
        if (!this.uwsActions.contains(action)) {
            return this.uwsActions.add(action);
        }
        return false;
    }

    public final boolean addUWSAction(int indAction, UWSAction action) throws ArrayIndexOutOfBoundsException {
        if (!this.uwsActions.contains(action)) {
            this.uwsActions.add(indAction, action);
            return true;
        }
        return false;
    }

    public final boolean setUWSAction(int indAction, UWSAction action) throws ArrayIndexOutOfBoundsException {
        if (!this.uwsActions.contains(action)) {
            this.uwsActions.set(indAction, action);
            return true;
        }
        return false;
    }

    public final UWSAction replaceUWSAction(UWSAction action) {
        if (action == null) {
            return null;
        }
        for (int i = 0; i < this.uwsActions.size(); ++i) {
            if (!this.uwsActions.get(i).equals(action)) continue;
            return this.uwsActions.set(i, action);
        }
        return null;
    }

    public final int getNbUWSActions() {
        return this.uwsActions.size();
    }

    public final UWSAction getUWSAction(String actionName) {
        for (int i = 0; i < this.uwsActions.size(); ++i) {
            if (!this.uwsActions.get(i).getName().equals(actionName)) continue;
            return this.uwsActions.get(i);
        }
        return null;
    }

    public final Iterator<UWSAction> getUWSActions() {
        return this.uwsActions.iterator();
    }

    public final UWSAction getExecutedAction() {
        return this.executedAction;
    }

    public final UWSAction removeUWSAction(int indAction) throws ArrayIndexOutOfBoundsException {
        return this.uwsActions.remove(indAction);
    }

    public final UWSAction removeUWSAction(String actionName) {
        for (int i = 0; i < this.uwsActions.size(); ++i) {
            if (!this.uwsActions.get(i).getName().equals(actionName)) continue;
            return this.uwsActions.remove(i);
        }
        return null;
    }

    protected synchronized String generateRequestID(HttpServletRequest request) {
        String id;
        do {
            id = System.currentTimeMillis() + "";
        } while (lastRequestID != null && lastRequestID.startsWith(id));
        lastRequestID = id;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRequest(HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        String reqID;
        if (request == null || response == null) {
            return false;
        }
        String string = reqID = request.getAttribute("UWS_REQUEST_ID") == null ? this.generateRequestID(request) : request.getAttribute("UWS_REQUEST_ID").toString();
        if (request.getAttribute("UWS_REQUEST_ID") == null) {
            request.setAttribute("UWS_REQUEST_ID", (Object)reqID);
        }
        this.logger.logHttp(UWSLog.LogLevel.INFO, request, reqID, null, null);
        boolean actionApplied = false;
        UWSAction action = null;
        JobOwner user = null;
        try {
            if (this.urlInterpreter == null) {
                this.setUrlInterpreter(new UWSUrl(request));
                this.logger.logUWS(UWSLog.LogLevel.INFO, this, "INIT", "UWS successfully initialized.", null);
            }
            UWSUrl urlInterpreter = new UWSUrl(this.urlInterpreter);
            urlInterpreter.load(request);
            user = UWSToolBox.getUser(request, this.userIdentifier);
            response.setCharacterEncoding("UTF-8");
            if (request.getAttribute("UWS_PARAMETERS") == null) {
                request.setAttribute("UWS_PARAMETERS", this.requestParser.parse(request));
            }
            for (int i = 0; action == null && i < this.uwsActions.size(); ++i) {
                if (!this.uwsActions.get(i).match(urlInterpreter, user, request)) continue;
                action = this.uwsActions.get(i);
                this.choosenSerializer = null;
                actionApplied = action.apply(urlInterpreter, user, request, response);
            }
            if (action == null) {
                throw new UWSException(501, "Unknown UWS action!");
            }
            response.flushBuffer();
            this.logger.logHttp(UWSLog.LogLevel.INFO, response, reqID, user, "UWS action \"" + (action != null ? action.getName() : null) + "\" successfully executed.", null);
        }
        catch (IOException ioe) {
            this.logger.logHttp(UWSLog.LogLevel.INFO, response, reqID, user, "HTTP request aborted or connection with the client closed => the UWS action \"" + action.getName() + "\" has stopped and the body of the HTTP response can not have been partially or completely written!", null);
        }
        catch (UWSException ex) {
            if (ex.getHttpErrorCode() == 303) {
                actionApplied = true;
            }
            this.sendError(ex, request, reqID, user, action != null ? action.getName() : null, response);
        }
        catch (IllegalStateException ise) {
            this.errorWriter.writeError(ise, response, request, reqID, user, action != null ? action.getName() : null);
            this.getLogger().logHttp(UWSLog.LogLevel.FATAL, response, reqID, user, "HTTP response already partially committed => the UWS action \"" + action.getName() + "\" has stopped and the body of the HTTP response can not have been partially or completely written!", ise.getCause() != null ? ise.getCause() : ise);
        }
        catch (Throwable t) {
            this.sendError(t, request, reqID, user, action != null ? action.getName() : null, response);
        }
        finally {
            this.executedAction = action;
            UWSToolBox.deleteUploads(request);
        }
        return actionApplied;
    }

    public void redirect(String url, HttpServletRequest request, JobOwner user, String uwsAction, HttpServletResponse response) throws IOException, UWSException {
        response.setStatus(303);
        response.setContentType(request.getContentType());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Location", url);
        response.flushBuffer();
    }

    public final void sendError(UWSException error, HttpServletRequest request, String reqID, JobOwner user, String uwsAction, HttpServletResponse response) throws IOException, UWSException {
        if (error.getHttpErrorCode() == 303) {
            this.logger.logHttp(UWSLog.LogLevel.INFO, response, reqID, user, "HTTP 303 [Redirection toward " + error.getMessage() + "] - Action \"" + uwsAction + "\" successfully executed.", null);
            this.redirect(error.getMessage(), request, user, uwsAction, response);
        } else {
            this.sendError((Throwable)error, request, reqID, user, uwsAction, response);
        }
    }

    public final void sendError(Throwable error, HttpServletRequest request, String reqID, JobOwner user, String uwsAction, HttpServletResponse response) throws IOException {
        this.errorWriter.writeError(error, response, request, reqID, user, uwsAction);
        if (error instanceof UWSException) {
            this.logger.logHttp(UWSLog.LogLevel.ERROR, response, reqID, user, "UWS action \"" + uwsAction + "\" FAILED with the error: \"" + error.getMessage() + "\"!", null);
        } else {
            this.logger.logHttp(UWSLog.LogLevel.FATAL, response, reqID, user, "UWS action \"" + uwsAction + "\" execution FAILED with a GRAVE error!", error);
        }
    }
}

