/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSExceptionFactory;
import uws.job.JobList;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;
import uws.service.log.UWSLog;

public class AddJob
extends UWSAction {
    private static final long serialVersionUID = 1L;

    public AddJob(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Add Job";
    }

    @Override
    public String getDescription() {
        return "Lets adding to the specified jobs list a job whose the parameters are given. (URL: {baseUWS_URL}/{jobListName}, Method: HTTP-POST, Parameters: job parameters)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && !urlInterpreter.hasJob() && request.getMethod().equalsIgnoreCase("post");
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        UWSJob newJob;
        JobList jobsList = this.getJobsList(urlInterpreter);
        if (user != null && !user.hasWritePermission(jobsList)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, true, jobsList.getName()));
        }
        try {
            newJob = this.uws.getFactory().createJob(request, user);
        }
        catch (UWSException ue) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, urlInterpreter, "ADD_JOB", "Can not create a new job!", ue);
            throw ue;
        }
        if (jobsList.addNewJob(newJob) != null) {
            this.uws.redirect(urlInterpreter.jobSummary(jobsList.getName(), newJob.getJobId()).getRequestURL(), request, user, this.getName(), response);
            return true;
        }
        throw new UWSException(500, "Unable to add the new job to the jobs list for an unknown reason. (ID of the new job = \"" + newJob.getJobId() + "\" ; ID already used = " + (jobsList.getJob(newJob.getJobId()) != null) + ")");
    }
}

