/*
 * Decompiled with CFR 0.152.
 */
package uws.service.log;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uws.UWSToolBox;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.log.UWSLog;

public class Slf4jUWSLog
implements UWSLog {
    protected static final String DEFAULT_ROOT_LOG_ID = "uws.service";
    protected static final String UWS_LOG_ID_SUFFIX = "UWS";
    protected static final String HTTP_LOG_ID_SUFFIX = "HTTP";
    protected static final String JOB_LOG_ID_SUFFIX = "JOB";
    protected static final String THREAD_LOG_ID_SUFFIX = "THREAD";
    protected final Logger rootLogger;
    protected final Logger uwsLogger;
    protected final Logger httpLogger;
    protected final Logger jobLogger;
    protected final Logger threadLogger;

    public Slf4jUWSLog() {
        this(DEFAULT_ROOT_LOG_ID);
    }

    protected Slf4jUWSLog(String logId) {
        String rootLogId = logId == null || logId.trim().length() == 0 ? DEFAULT_ROOT_LOG_ID : logId;
        this.rootLogger = LoggerFactory.getLogger((String)rootLogId);
        this.uwsLogger = LoggerFactory.getLogger((String)(rootLogId + "." + UWS_LOG_ID_SUFFIX));
        this.httpLogger = LoggerFactory.getLogger((String)(rootLogId + "." + HTTP_LOG_ID_SUFFIX));
        this.jobLogger = LoggerFactory.getLogger((String)(rootLogId + "." + JOB_LOG_ID_SUFFIX));
        this.threadLogger = LoggerFactory.getLogger((String)(rootLogId + "." + THREAD_LOG_ID_SUFFIX));
    }

    @Override
    public String getConfigString() {
        return "type: \"SLF4J\", loggers: [\"" + this.rootLogger.getName() + "\", \"" + this.uwsLogger.getName() + "\", \"" + this.httpLogger.getName() + "\", \"" + this.jobLogger.getName() + "\", \"" + this.threadLogger.getName() + "\"]";
    }

    @Override
    public void log(UWSLog.LogLevel level, String context, String message, Throwable error) {
        Logger logger = this.rootLogger;
        if (context != null) {
            if (HTTP_LOG_ID_SUFFIX.equalsIgnoreCase(context)) {
                logger = this.httpLogger;
            } else if (UWS_LOG_ID_SUFFIX.equalsIgnoreCase(context)) {
                logger = this.uwsLogger;
            } else if (JOB_LOG_ID_SUFFIX.equalsIgnoreCase(context)) {
                logger = this.jobLogger;
            } else if (THREAD_LOG_ID_SUFFIX.equalsIgnoreCase(context)) {
                logger = this.threadLogger;
            }
        }
        this.log(level, logger, null, null, message, null, error);
    }

    protected final void log(UWSLog.LogLevel level, Logger logger, String event, String ID, String message, String addColumn, Throwable error) {
        if ((message == null || message.length() <= 0) && error == null) {
            return;
        }
        if (level == null) {
            UWSLog.LogLevel logLevel = level = error != null ? UWSLog.LogLevel.ERROR : UWSLog.LogLevel.INFO;
        }
        if (logger == null) {
            logger = this.rootLogger;
        }
        switch (level) {
            case DEBUG: {
                logger.debug("{} - {} - {}{}", new Object[]{event == null ? "" : event, ID == null ? "" : ID, message, addColumn == null ? "" : " - " + addColumn, error});
                break;
            }
            case INFO: {
                logger.info("{} - {} - {}{}", new Object[]{event == null ? "" : event, ID == null ? "" : ID, message, addColumn == null ? "" : " - " + addColumn, error});
                break;
            }
            case WARNING: {
                logger.warn("{} - {} - {}{}", new Object[]{event == null ? "" : event, ID == null ? "" : ID, message, addColumn == null ? "" : " - " + addColumn, error});
                break;
            }
            case ERROR: {
                logger.error("{} - {} - {}{}", new Object[]{event == null ? "" : event, ID == null ? "" : ID, message, addColumn == null ? "" : " - " + addColumn, error});
                break;
            }
            case FATAL: {
                logger.error("{} - {} - GRAVE: {}{}", new Object[]{event == null ? "" : event, ID == null ? "" : ID, message, addColumn == null ? "" : " - " + addColumn, error});
            }
        }
    }

    @Override
    public void debug(String msg) {
        this.log(UWSLog.LogLevel.DEBUG, this.rootLogger, null, null, msg, null, null);
    }

    @Override
    public void debug(Throwable t) {
        this.log(UWSLog.LogLevel.DEBUG, this.rootLogger, null, null, "Debugging stack trace:", null, t);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(UWSLog.LogLevel.DEBUG, this.rootLogger, null, null, msg, null, t);
    }

    @Override
    public void info(String msg) {
        this.log(UWSLog.LogLevel.INFO, this.rootLogger, null, null, msg, null, null);
    }

    @Override
    public void warning(String msg) {
        this.log(UWSLog.LogLevel.WARNING, this.rootLogger, null, null, msg, null, null);
    }

    @Override
    public void error(String msg) {
        this.log(UWSLog.LogLevel.ERROR, this.rootLogger, null, null, msg, null, null);
    }

    @Override
    public void error(Throwable t) {
        this.log(UWSLog.LogLevel.ERROR, this.rootLogger, null, null, "Unexpected error:", null, t);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(UWSLog.LogLevel.ERROR, this.rootLogger, null, null, msg, null, t);
    }

    @Override
    public void logHttp(UWSLog.LogLevel level, HttpServletRequest request, String requestId, String message, Throwable error) {
        if (request != null) {
            StringBuffer str = new StringBuffer(message != null ? message + ": " : "");
            str.append(request.getMethod());
            str.append(" as ");
            if (request.getContentType() != null) {
                if (request.getContentType().indexOf(59) > 0) {
                    str.append(request.getContentType().substring(0, request.getContentType().indexOf(59)));
                } else {
                    str.append(request.getContentType());
                }
            }
            str.append(" at ").append(request.getRequestURL());
            str.append(" from ").append(request.getRemoteAddr());
            str.append(" using ").append(request.getHeader("User-Agent") == null ? "" : request.getHeader("User-Agent"));
            str.append(" with parameters (");
            Map<String, String> params = UWSToolBox.getParamsMap(request);
            int i = -1;
            for (Map.Entry<String, String> p : params.entrySet()) {
                if (++i > 0) {
                    str.append('&');
                }
                str.append(p.getKey()).append('=').append(p.getValue() != null ? p.getValue() : "");
            }
            str.append(')');
            if (message == null) {
                this.log(level, this.httpLogger, "REQUEST_RECEIVED", requestId, str.toString(), null, error);
            } else {
                this.log(level, this.httpLogger, "REQUEST_RECEIVED", requestId, str.toString(), null, error);
            }
        } else {
            this.log(level, this.httpLogger, "REQUEST_RECEIVED", requestId, message, null, error);
        }
    }

    @Override
    public void logHttp(UWSLog.LogLevel level, HttpServletResponse response, String requestId, JobOwner user, String message, Throwable error) {
        if (response != null) {
            StringBuffer str = new StringBuffer();
            str.append("HTTP-").append(response.getStatus());
            str.append(" to the user ");
            if (user != null) {
                str.append("(id:").append(user.getID());
                if (user.getPseudo() != null) {
                    str.append(";pseudo:").append(user.getPseudo());
                }
                str.append(')');
            } else {
                str.append("ANONYMOUS");
            }
            if (response.getContentType() != null) {
                str.append(" as ").append(response.getContentType());
            }
            this.log(level, this.httpLogger, "RESPONSE_SENT", requestId, message, str.toString(), error);
        } else {
            this.log(level, this.httpLogger, "RESPONSE_SENT", requestId, message, null, error);
        }
    }

    @Override
    public void logUWS(UWSLog.LogLevel level, Object obj, String event, String message, Throwable error) {
        String report = null;
        if (event != null && event.equalsIgnoreCase("BACKUPED") && obj != null && obj.getClass().getName().equals("[I")) {
            int[] backupReport = (int[])obj;
            report = backupReport.length == 2 ? "(" + backupReport[0] + "/" + backupReport[1] + " jobs backuped for this user)" : "(" + backupReport[0] + "/" + backupReport[1] + " jobs backuped ; " + backupReport[2] + "/" + backupReport[3] + " users backuped)";
        } else if (event != null && event.equalsIgnoreCase("RESTORED") && obj != null && obj.getClass().getName().equals("[I")) {
            int[] restoreReport = (int[])obj;
            report = "(" + restoreReport[0] + "/" + restoreReport[1] + " jobs restored ; " + restoreReport[2] + "/" + restoreReport[3] + " users restored)";
        }
        this.log(level, this.uwsLogger, event, null, message, report, error);
    }

    @Override
    public void logJob(UWSLog.LogLevel level, UWSJob job, String event, String message, Throwable error) {
        this.log(level, this.jobLogger, event, job == null ? null : job.getJobId(), message, null, error);
    }

    @Override
    public void logThread(UWSLog.LogLevel level, Thread thread, String event, String message, Throwable error) {
        if (thread != null) {
            StringBuffer str = new StringBuffer();
            str.append(thread.getName()).append(" (thread ID: ").append(thread.getId()).append(")");
            str.append(" is ").append((Object)thread.getState());
            str.append(" in the group " + thread.getThreadGroup().getName());
            str.append(" where ").append(thread.getThreadGroup().activeCount()).append(" threads are active");
            this.log(level, this.threadLogger, event, thread.getName(), message, str.toString(), error);
        } else {
            this.log(level, this.threadLogger, event, null, message, null, error);
        }
    }
}

