/*
 * Decompiled with CFR 0.152.
 */
package uws.service.request;

import java.io.IOException;
import java.io.InputStream;
import uws.job.UWSJob;
import uws.service.file.UWSFileManager;

public class UploadFile {
    public final String paramName;
    public final String fileName;
    protected String location;
    protected UWSJob owner = null;
    protected boolean used = false;
    public String mimeType = null;
    public long length = -1L;
    protected final UWSFileManager fileManager;

    public UploadFile(String paramName, String location, UWSFileManager fileManager) {
        this(paramName, null, location, fileManager);
    }

    public UploadFile(String paramName, String fileName, String location, UWSFileManager fileManager) {
        if (paramName == null) {
            throw new NullPointerException("Missing name of the parameter in which the uploaded file content was => can not create UploadFile!");
        }
        if (location == null) {
            throw new NullPointerException("Missing server location of the uploaded file => can not create UploadFile!");
        }
        if (fileManager == null) {
            throw new NullPointerException("Missing file manager => can not create the UploadFile!");
        }
        this.paramName = paramName;
        this.fileName = fileName == null ? "" : fileName;
        this.location = location;
        this.fileManager = fileManager;
    }

    public String getLocation() {
        return this.location;
    }

    public UWSJob getOwner() {
        return this.owner;
    }

    public final boolean isUsed() {
        return this.used;
    }

    public InputStream open() throws IOException {
        this.used = true;
        return this.fileManager.getUploadInput(this);
    }

    public void deleteFile() throws IOException {
        this.fileManager.deleteUpload(this);
        this.used = true;
    }

    public void move(UWSJob destination) throws IOException {
        if (destination == null) {
            throw new NullPointerException("Missing move destination (i.e. the job in which the uploaded file must be stored)!");
        }
        this.location = this.fileManager.moveUpload(this, destination);
        this.used = true;
        this.owner = destination;
    }

    public String toString() {
        return this.owner != null && this.owner.getJobList() != null && this.owner.getUrl() != null ? this.owner.getUrl().jobParameter(this.owner.getJobList().getName(), this.owner.getJobId(), this.paramName).toString() : this.fileName;
    }
}

