
#include "cutout.hpp"
#include "cutout_nljson.hpp"
#include "mcutout.hpp"
#include "mcutout_nljson.hpp"

#include "json.hpp"
#include "io.hpp"
#include <string>
#include <vector>

using json = nlohmann::json;

/* All nlohmann-json exception are json::exception <- std::exception.
 * So let them be caught by std::excpetion as 'Internal errors' in rpc-call's infinite loop,
 * assuming all API syntactic errors were caught in servlet API parser
 */


class json_region
{
   public:

      json_region(std::string request_json)
      {
         LOG_trace(__func__);

         const bool ASSERTS = true;
         m_jservice = json::parse(request_json, nullptr, ASSERTS);

         LOG_STREAM << m_jservice.dump() << std::endl;
      }


      position get_pos()
      {
         return (m_jservice.contains("pos") ? (position) m_jservice.at("pos") : pos_none );
      }


      band get_band()
      {
         return (m_jservice.contains("band") ? (band) m_jservice.at("band") : band_none);
      }


      time_axis get_time()
      {
         return (m_jservice.contains("time") ? (time_axis) m_jservice.at("time") : time_none);
      }


      std::vector<std::string> get_pol()
      {
         std::vector<std::string> str;
         if(m_jservice.contains("pol"))
         {
            json j = m_jservice.at("pol");
            str = j.get<std::vector<std::string>>();
         }
         return str;
      }


   private:
      json m_jservice;
};

