/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.job.JobList;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.log.UWSLog;

public abstract class UWSAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LIST_JOBS = "List Jobs";
    public static final String ADD_JOB = "Add Job";
    public static final String SET_UWS_PARAMETER = "Set UWS Parameter";
    public static final String DESTROY_JOB = "Destroy Job";
    public static final String JOB_SUMMARY = "Get Job";
    public static final String GET_JOB_PARAM = "Get Job Parameter";
    public static final String SET_JOB_PARAM = "Set Job Parameter";
    public static final String HOME_PAGE = "Show UWS Home Page";
    protected final UWSService uws;

    protected UWSAction(UWSService u) {
        this.uws = u;
    }

    public final UWSService getUWS() {
        return this.uws;
    }

    public final UWSLog getLogger() {
        return this.uws.getLogger();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getDescription() {
        return "";
    }

    protected final JobList getJobsList(UWSUrl urlInterpreter) throws UWSException {
        String jlName = urlInterpreter.getJobListName();
        JobList jobsList = null;
        if (jlName != null) {
            jobsList = this.uws.getJobList(jlName);
            if (jobsList == null) {
                throw new UWSException(404, "Incorrect job list name! The jobs list " + jlName + " does not exist.");
            }
        } else {
            throw new UWSException(400, "Missing job list name!");
        }
        return jobsList;
    }

    protected final UWSJob getJob(UWSUrl urlInterpreter) throws UWSException {
        return this.getJob(urlInterpreter, (JobOwner)null);
    }

    protected final UWSJob getJob(UWSUrl urlInterpreter, JobOwner user) throws UWSException {
        String jobId = urlInterpreter.getJobId();
        UWSJob job = null;
        if (jobId != null) {
            JobList jobsList = this.getJobsList(urlInterpreter);
            job = jobsList.getJob(jobId, user);
            if (job == null) {
                throw new UWSException(404, "Incorrect job ID! The job \"" + jobId + "\" does not exist in the jobs list \"" + jobsList.getName() + "\".");
            }
        } else {
            throw new UWSException(400, "Missing job ID!");
        }
        return job;
    }

    protected final UWSJob getJob(UWSUrl urlInterpreter, JobList jobsList) throws UWSException {
        return this.getJob(urlInterpreter, jobsList, null);
    }

    protected final UWSJob getJob(UWSUrl urlInterpreter, JobList jobsList, JobOwner user) throws UWSException {
        String jobId = urlInterpreter.getJobId();
        UWSJob job = null;
        if (jobId != null) {
            if (jobsList == null) {
                throw new UWSException(400, "Missing job list name!");
            }
            job = jobsList.getJob(jobId, user);
            if (job == null) {
                throw new UWSException(404, "Incorrect job ID! The job \"" + jobId + "\" does not exist in the jobs list \"" + jobsList.getName() + "\".");
            }
        } else {
            throw new UWSException(400, "Missing job ID!");
        }
        return job;
    }

    public abstract boolean match(UWSUrl var1, JobOwner var2, HttpServletRequest var3) throws UWSException;

    public abstract boolean apply(UWSUrl var1, JobOwner var2, HttpServletRequest var3, HttpServletResponse var4) throws UWSException, IOException;

    public final boolean equals(Object obj) {
        if (obj instanceof UWSAction) {
            return this.getName().equals(((UWSAction)obj).getName());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getName();
    }
}

