# Foundational Data Products Knowledge Inventory

This repository houses raw foundational data product data information in JSON format inside of the data directory. Data are organized by major body. In addition to housing the data, this repo renders the [Foundational Data Products](https://fdp.astrogeology.usgs.gov) webpage.

Contributing to the community that is building around [analysis ready data] for the planetary sciences and planetary spatial data infrastructures is not hard. In fact, we seek to make the process as easy as possible because we want to engage with as many users as possible to share what we know and learn around the myriad of topics we do not know about. 

Data are stored here, on GitHub to maintain the lineage of changes, to provide a place for anyone to submit new entries, and finally to have a conversation about one or more data sets. We hope that using a code repository is not an undue burden to potential contributors, but understand that for a new user, making use of a new website can be daunting. If that is the case, please feel free to email [jlaura@usgs.gov](mailto:jlaura@usgs.gov) with your contribution and they will get an issue, pull request, or discussion started over on the GitHub repository.

There are many ways to contribute as alluded to above:

  1. [Open an issue](https://github.com/USGS-Astrogeology/FoundationalDataProducts/issues/new). This is a great way to suggest a new product or to identify a specific problem with an entry.
  1. [Browse or start a new discussion](https://github.com/USGS-Astrogeology/FoundationalDataProducts/discussions). This is a great way to ask a question or start a conversation with the other community members about adding a new product, modifying an existing entry, or seeking clarification about something.
  1. [Open a pull request with a change](https://github.com/USGS-Astrogeology/FoundationalDataProducts/pulls). This is how the community tracks changes in the knowledge inventory and this process means that changes to the inventory are being peer-reviewed by maintainers.

As above, if you want to participate and are funding the process too burdensome, please email [jlaura@usgs.gov](mailto:jlaura@usgs.gov) with your contribution.
