---
title: "Archiving Gaps in Foundational Data Products"
date: 2021-11-15T10:52:04-07:00
draft: true
weight: 12
---

On this page, we enumerate products that, to the best of our knowledge, are not being stored in a Planetary Data System (PDS) archive or PDS equivalent archive (e.g, JAXA DARTS, USGS Image Annex). Some of these products are available on journal publisher websites or personal websites. Others are, to the best of our knowledge unreleased for the general public. These unreleased products have been described in one or more journal articles or abstracts. For each entry, please see the body specific foundational data product page for more information, such as citation. 

We have omitted products collected by other space agencies (e.g., the CSA) when those products are available on an agency website (e.g., GRAS in the case of the CSA).

# Mercury
  - Mariner 10 DEM (Cook, et al.)
  - Fassett Regional DEMs (Fassett, et al.)
# Venus
  - Magellan SAR Regional Stereo DEMs (Herrick, et al.)
  - Magellan SAR Cycle 3 Stereo DEMs (Nunes, et al.)
# Moon
  - LMMP Generated LRO-NAC DEMs (?)
  - LROC NAC DEMs (>450 created) (Henriksen, et al.; Arizona State University)
  - Uncontrolled LROC NAC Polar Orthomosaics (Henriksen, et al.;Arizona State University)
# Mars
  - Phobos Oberst Control Network (Oberst, et al.;DLR)
  - Phobos Stereo-photoclinometry Derived Shape Model (Ernst, et al.;SBMT)
  - Phobos Co-registered Image Data (Ernst, et al.;SBMT)
  - Deimos Stereo-photoclinometry Derived Shape Model (Ernst, et al.;SBMT)
  - Deimos Co-registered Image Data (Ernst, et al.;SBMT)
  - Mars CaSSIS DEM (Conway, et al.; CaSSIS Team)
  - Mars University College London Co-Registered Hi-resolution Data (Sidiropoulos, et al.;UCL)
  - Murray Lab Global CTX (Dickson, et al.; California Institute of Technology)
# Jupiter
  - Io Rand Control Network (Davies, et al.; USGS)
  - Io Stereo-derived DEM (White, et al.; AGU)
  - Io Photoclinometry-derived DEM (White, et al.; AGU)
  - Europa Europa Supermosaic (Collins, et al.)
  - Ganymede RAND Control Network (Davies, et al.; USGS)
  - Callisto Rand Control Network (Davies, et al.; USGS)
  - Jupiter Gravity Model (Iess, et al.)
# Saturn
  - Mimas Cassini Stereo Derived Topography (Schenk, et al.)
  - Enceladus Gravity Model (Iess, et al.)
  - Enceladus Shape Model (Iess, et al.)
  - Enceladus Cassini Stereo Derived Topography (Schenk, et al.)
  - Tethys Cassini Stereo Derived Topography (Schenk, et al.)
  - Dione Gravity Model (Zannoni, et al.)
  - Dione Cassini Stereo Derived Topography (Schenk, et al.)
  - Rhea Gravity Model (Tortora, et al.)
  - Rhea Cassini Stereo Derived Topography (Schenk, et al.)
  - Titan Cassini SAR Spline Interpolated Global Topography (Lorenz, et al.; Icarus; University of Arizona)
  - Titan Radar Stereo-photogrammetric DEMs (Kirk, et al.; USGS)
  - Titan Altimeter Echo DEMs (Zebker, et al.)
  - Titan SAR Topo DEM (Stiles, et al.)
  - Titan Merged / Interpolated Global DEM (Corlies, et al.)
  - Titan Cassini VIMS Global Mosaic (Le Mouélic, et al.)
  - Iapetus	Cassini Stereo Derived Topography (Schenk, et al.)
# Uranus
  - Ariel Stereoscopically Derived Topography (Schenk, et al.)
  - Titania	Stereoscopically Derived Topography (Schenk, et al.)
  - Miranda	Stereoscopically Derived Topography (Schenk, et al.)
# Neptune
  - Triton Control Network (Bland, et al.;USGS)
  - Triton Control Network (Bland, et al.;USGS)
  - Triton Stereoscopically Derived Topography (Schenk, et al.)
# Pluto
  - Charon Control Network (Schenk, et al.)
  - Pluto Control Network (Schenk, et al.)
# Small Bodies
  - Bennu Shape Model (SPC) (Barnouin, et al.)
  - Bennu Shape Model (Laser Altimieter) (Barnouin, et al.)
  - Ryugu Structure From Motion (SfM) Shape Model (University of Aizu)
  - Ryugu Stereo-photoclinometric (SPC)) Shape Model (University of Aizu)
  - Arrokoth LORRI Global Shape Model (Spencer, et al.; Science)
  - Arrokoth Stereo-photogrammetric Shape Model (Spencer, et al.; Science)
  