#ifndef ProjectionConfigDialog_h
#define ProjectionConfigDialog_h

#include <QDialog>

#include <QPointer>

class QLabel;
class QPushButton;
class QTextEdit;

namespace Isis {
  class MosaicSceneWidget;
  class Projection;
  class Pvl;

  /**
   * This is the configuration dialog for the MosaicSceneWidget's projection parameters (map file).
   *
   * @author 2012-08-06 Steven Lambright
   *
   * @internal
   */
  class ProjectionConfigDialog : public QDialog {
      Q_OBJECT

    public:
      ProjectionConfigDialog(MosaicSceneWidget *scene, QWidget *parent = NULL);
      virtual ~ProjectionConfigDialog();

      void setQuickConfig(bool quick);

    signals:
      void shown();

    public slots:
      void applySettings();
      void readSettings();

    protected:
      void showEvent(QShowEvent *);

    private:
      Q_DISABLE_COPY(ProjectionConfigDialog);
      Pvl addMissingKeywords(Pvl mappingPvl);
      Projection *createProjection();

    private slots:
      void beginQuickLoad();
      void loadFromFile();
      void saveToFile();
      void refreshWidgetStates();
      void showErrors(int);

    private:
      //! This shows a general idea of the current state of the mapping pvl (always shown)
      QPointer<QLabel> m_stateLabel;
      //! This shows errors generated by trying to create a projection from the current mapping pvl
      QPointer<QLabel> m_errorsLabel;
      //! This is the text area that a user can type in for editing the projection
      QPointer<QTextEdit> m_mapFileEdit;

      //! This button corresponds to 'Load Map File...' and causes a prompt for file input
      QPointer<QPushButton> m_readFromFileButton;

      //! This button applies the current projection to the scene
      QPointer<QPushButton> m_applyButton;
      //! This button applies the current projection to the scene and closes the dialog
      QPointer<QPushButton> m_okayButton;

      //! The mosaic scene we're configuring the projection for
      QPointer<MosaicSceneWidget> m_scene;

      //! To reduce redundant computations, keep track of dirty state of the dialog
      bool m_dirty;

      //! Should we minimize the user interaction?
      bool m_quick;
  };
}

#endif
