<?php
/*  Feed2inc : RSS feed to PHP include file
	
	ABOUT
	This PHP code can be used as an include to provide the
	same functionality of our Feed2JS concept, but without
	the need to generate content via JavaScript
	
	Developed by Alan Levine 04.aug.2004
	http://cogdogblog.com/
	
	This is a modified version of Fee22JS and merely replaces
	the output of Javascript to that for a PHP. See the original
	feed2js.php for change history.
	 
	USAGE:
	See http://feed2js.org/index.php?s=php
		
	HISTORY
    See:
      http://feed2js.org/index.php?s=history
    
    or the RSS feed:
      http://feed2js.org/content/feed2js.xml

	
	This makes use of the Magpie RSS parser from
	 http://magpierss.sourceforge.net/
	 
   ------------- small print ---------------------------------------
	GNU General Public License 
	Copyright (C) 2004 Alan Levine
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details
	http://www.gnu.org/licenses/gpl.html
	------------- small print ---------------------------------------

*/

require_once('feed2js_config.php');

/// trap for missing src param for the feed, use a dummy one so it gets displayed.

if (!$src or strpos($src, 'http://')!=0) $src=  'http://' . $_SERVER['SERVER_NAME'] . dirname($_SERVER['PHP_SELF']) . '/nosource.rss';

//  check for utf encoding type
if (!isset($utf)) $utf = 'n';

if ($utf == 'y') {
	define('MAGPIE_CACHE_DIR', MAGPIE_DIR . 'cache_utf8/');
	// character encoding
	define('MAGPIE_OUTPUT_ENCODING', 'UTF-8');

} else {
	define('MAGPIE_CACHE_DIR', MAGPIE_DIR . 'cache/');
	
}


// GET VARIABLES ---------------------------------------------
// retrieve values from posted variables

// flag to show channel info
if (!isset($chan)) $chan = 'n';

// variable to limit number of displayed items; default = 0 (show all, 20 is a safe bet to list a big list of feeds)

if (!isset($num)) $num = 0;
if ($num==0) $num = 100;

// indicator to show item description,  0 = no; 1=all; n>1 = characters to display
// values of -1 indicate to display item without the title as a link
// (default=0)
if (!isset($desc)) $desc = 0;

// flag to show date of posts, values: no/yes (default=no)
$date = (isset($date)) ? $date : 'n';

// time zone offset for making local time, 
// e.g. +7, =-10.5; 'feed' = print the time string in the RSS w/o conversion
$tz = (isset($tz)) ? $tz : 'feed';

// flag to open target window in new window; n = same window, y = new window,
// other = targeted window, 'popup' = call JavaScript function popupfeed to display
// in new window
// (default is n)

if (!isset($targ)) $targ = 'n';

if ($targ == 'n') {
	$target_window = ' target="_self"';
} elseif ($targ == 'y' ) {
	$target_window = ' target="_blank"';
} elseif ($targ == 'popup') {
	$target_window = ' onClick="popupfeed(this.href);return false"';
} else {
	$target_window = ' target="' . $targ . '"';
}

// flag to show feed as full html output rather than JavaScript, used for alternative
// views for JavaScript-less users. 
//     y = display html only for non js browsers
//     n = default (JavaScript view)
//     a = display javascript output but allow HTML 
//     p  = display text only items but convert linefeeds to BR tags

// default setting for no conversion of linebreaks
if (!isset($html)) $html = 'n';

$br = ' ';
if ($html == 'a') {
	$desc = 1;
} elseif ($html == 'p') {
	$br = '<br />';
}

// optional parameter to use different class for the CSS container
if (isset($css)) {
	$rss_box_id = '-' . $css;
} else {
	$rss_box_id = '';
}

if (isset($pc)) {
	$play_podcast = $pc;
} else {
	$play_podcast = 'n';
}


// PARSE FEED and GENERATE OUTPUT -------------------------------
// This is where it all happens!

// Fetch the data, thanks Magpie
$rss = @fetch_rss( $src );

// begin javascript output string for channel info
$str = "<div class=\"rss-box" . $rss_box_id . "\">\n";

// no feed found by magpie, return error statement
if  (!$rss) {
	// error, nothing grabbed
	$str.= "<p class=\"rss-item\"><em>Error:</em> Feed failed! Causes may be (1) No data  found for RSS feed $src; (2) There are no items are available for this feed; (3) The RSS feed does not validate.<br /><br /> Please verify that the URL <a href=\"$src\">$src</a> works first in your browser and that the feed passes a <a href=\"http://feedvalidator.org/check.cgi?url=" . urlencode($src) . "\">validator test</a>.</p>\n";
} else {

	if ($chan == 'y') {
	
		// output channel title and description	
		$str.= "<p class=\"rss-title\"><a class=\"rss-title\" href=\"" . trim($rss->channel['link']) . "\" target=\"" . $target_window . "\">" . strip_returns($rss->channel['title']) . "</a><br /><span class=\"rss-item\">" . strip_returns($rss->channel['description']) . "</span></p>\n";
	
	} elseif ($chan == 'title') {
		// output title only
		$str.= "<p class=\"rss-title\"><a class=\"rss-title\" href=\"" . trim($rss->channel['link']) . "\" target=\"" . $target_window . "\">" . strip_returns($rss->channel['title']) . "</a></p>\n";
	
	}	
	
	// begin item listing
	$str.= "<ul class=\"rss-items\">\n";
	
	
	// Walk the items and process each one
	$all_items = array_slice($rss->items, 0, $num);
	
	foreach ( $all_items as $item ) {
		
		if ($item['link']) {
			// link url
			$my_url = $item['link'];
		} elseif  ($item['guid']) {
			//  feeds lacking item -> link
			$my_url = ($item['guid']);
		}
		
		
		if ($desc < 0) {
			$str.= "<li class=\"rss-item\">\n";
			
		} elseif  ($item['title']) {
			// format item title
			$my_title = strip_returns($item['title']);

			// create a title attribute. thanks Seb!
			$title_str = substr(strip_returns(strip_tags($item['summary'])), 0, 255) . '...'; 

			// write the item
			$str.= "<li class=\"rss-item\"><a class=\"rss-item\" href=\"" . trim($my_url) . "\"  title=\"$title_str\"" . $target_window . ">" . $my_title . "</a><br />\n";

		} else {
			// if no title, build a link to tag on the description
			$str.= "<li class=\"rss-item\">\n";
			$more_link = " <a class=\"rss-item\" href=\"" .trim($my_url) . '"' . $target_window . ">&laquo;details&raquo;</a>";
		}

	
		// print out date if option indicated and feed returns a value. 
		// Use the new date_timestamp function in Magpie 0.71
		if ($date == 'y') {
			if ($tz == 'feed') {
			//   echo the date/time stamp reported in the feed

				if ($item['pubdate'] != '') {
					// RSS 2.0 is already formatted, so just use it
					$pretty_date = 'published on ' . $item['pubdate'];
				} elseif ($item['published'] != "") {
					// ATOM 1.0 format, remove the "T" and "Z" and the time zone offset
					$pretty_date = str_replace("T", " ", $item['published']);
					$pretty_date= 'published on ' . str_replace("Z", " ", $pretty_date);
	
				} elseif ($item['issued'] != "") {
					// ATOM 0.3 format, remove the "T" and "Z" and the time zone offset
					$pretty_date = str_replace("T", " ", $item['issued']);
					$pretty_date= 'published on ' . str_replace("Z", " ", $pretty_date);
				} elseif ( $item['dc']['date'] != "") {
					// RSS 1.0, remove the "T" and the time zone offset
					$pretty_date = str_replace("T", " ", $item['dc']['date']);
					$pretty_date = 'published on ' . substr($pretty_date, 0,-6);
				} else {
				
					// no time/date stamp, just use the server time
					$pretty_date =  'published date n/a';
				}

			} else {
				// convert to local time via conversion to GMT + offset
				
				// adjust local server time to GMT and then adjust time according to user
				// entered offset.
				
				$pretty_date = 'published on ' . date($date_format, $item['date_timestamp'] - $tz_offset + $tz * 3600);
			
			}
	


			$str.= "<span class=\"rss-date\">$pretty_date</span><br />\n"; 
		}

		// link to podcast media if available
		
		if ($play_podcast == 'y' and is_array($item['enclosure'])) {
			$str.= "<div class=\"pod-play-box\">Media: ";
			
			for ($i = 0; $i < count($item['enclosure']); $i++) {
			
				// display only if enclosure is a valid URL
				//if (strpos($item['enclosure'][$i]['url'], 'http://')!=0) {
					$str.= "<a class=\"pod-play\"><a href=\"" . trim($item['enclosure'][$i]['url']) . "\" title=\"Play Now\" target=\"_blank\"><em>Play</em> <span>" .  substr(trim($item['enclosure'][$i]['url']), -3)  . "</span></a> ";
				//}
		
			}
				$str.= "</div>";
		
		}


		
	
		// output description of item if desired
		if ($desc) {

		 	// Atom/encoded content support (thanks David Carter-Tod)

			if ($item['content']['encoded']) {
				$my_blurb = html_entity_decode ( $item['content']['encoded'], ENT_NOQUOTES);
	
			} else {   
				$my_blurb = $item['summary'];
			}



			// strip html
			if ($html != 'a') $my_blurb = strip_tags($my_blurb);
			
			// trim descriptions
			if ($desc > 1) {
			
				// display specified substring numbers of chars;
				//   html is stripped to prevent cut off tags
				$my_blurb = substr($my_blurb, 0, $desc) . '...';
			}

			$str.= strip_returns($my_blurb, $br) . "\n"; 
		}
			
		$str.= "$more_link</li>\n";	
	}
}

$str .= "</ul></div>\n";
echo $str;

?>
