#include "ControlPoint.h"
#include "iTime.h"
#include "LidarControlPoint.h"
#include "Preference.h"

using namespace std;
using namespace Isis;

int main() {
  Preference::Preferences(true);
  
  cout << "LidarControlPoint Unit Test" << endl;
  
  // LidarControlPoint lcp(iTime(13.00), 10, 12);
  LidarControlPoint lcp;
  
  
  cout << "Testing EditLocking" << endl;
  lcp.SetEditLock(true);
  
  if (lcp.IsEditLocked()) {
    cout << "Edit locked" << endl;
  }
  else {
    cout << "Error: Not edit locked" << endl;
  }
  
  if (lcp.setRange(12.0) == ControlPoint::Status::PointLocked) {
    cout << "Cannot set range because the point is edit locked" << endl;
  }
  else {
    cout << "Error: The point was not properly edit locked. Was able to set the range." << endl;
  }
  if (lcp.setSigmaRange(100.0) == ControlPoint::Status::PointLocked) {
    cout << "Cannot set sigma range because the point is edit locked" << endl;
  }
  else {
    cout << "Error: The point was not properly edit locked. Was able to set the sigma range." << endl;
  }
  if (lcp.setTime(iTime(42.0)) == ControlPoint::Status::PointLocked) {
    cout << "Cannot set time because the point is edit locked" << endl;
  }
  else {
    cout << "Error: The point was not properly edit locked. Was able to set the time." << endl;
  }
  
  
  cout << "Testing Setters and Getters" << endl;
  lcp.SetEditLock(false);
  
  if (lcp.setRange(12.0) == ControlPoint::Status::Success) {
    cout << "Set the range" << endl;
    
    if (lcp.range() != 12.0) {
      cout << "Incorrect range!" << endl;
    }
  }
  else {
    cout << "Error: Could not set the range" << endl;
  }
  if (lcp.setSigmaRange(100.0) == ControlPoint::Status::Success) {
    cout << "Set the sigma range" << endl;
    
    if (lcp.sigmaRange() != 100.0) {
      cout << "Error: Incorrect sigma range!" << endl;
    }
  }
  else {
    cout << "Error: Could not set the sigma range." << endl;
  }
  if (lcp.setTime(iTime(42.0)) == ControlPoint::Status::Success) {
    cout << "Set the time" << endl;
    
    if (lcp.time() != iTime(42.0)) {
      cout << "Error: Incorrect time!" << endl;
    }
  }
  else {
    cout << "Error: Could not set the time." << endl;
  }

  cout << "Testing addSimultaneous and getter" << endl;
  QString newSerial = "LRO/1/286265995:36824/NACL";
  if (lcp.addSimultaneous(newSerial) == ControlPoint::Status::Success) {
    cout << "Serial number for simultaneous image added successfully" << endl;
    QList < QString > simultaneousList = lcp.snSimultaneous();
    if (simultaneousList[0] != "LRO/1/286265995:36824/NACL") {
      cout << "Error:  Incorrect serial number added to list:  " <<
        simultaneousList[0] << endl;
    }
  }
  else {
      cout << "Add to simultaneous image list failed!" << endl;
  }
}
