# ISIS Project public API

The public API is considered to be all the interfaces that the ISIS
project provides to the community from which the ISIS user base can
build more complex tools. This API therefore includes code-level
structures accessible via software calls to libraries, but also
more user-facing structures like command-line programs and graphical
user interface (GUI) programs. Any "interface" via which a user can
reasonably interact with components of the ISIS project should be
considered part of the "ISIS Project public API" for the purposes
of [Semantic Versioning](https://semver.org).

Examples are provided below, but are not meant to be exhaustive or
complete. The above philosophy should guide our thinking in what
the public API is.  The above API definition should be used with Semantic
Versioning policies to determine when and how the ISIS version
number changes. A FAQ and some examples can be found on the [Semantic
Versioning website](https://semver.org/).


## General Guidance

The public API consists of the following.

**Code-level structures**: Public function, member, and class names,
argument signatures, and their return signatures.  Where "public"
is defined as those elements that are typically provided for use external
to a library or module, dependent on the language.

Some examples are:

- C++ public structures are those that can be access by including
  the distributed header files for libraries.
- Python public structures are those that do not begin with an underbar
  ("_"), as described in PEP 8.


**User-facing command-line and GUI programs**: program name, argument
list, argument defaults, configuration or preference names and their
defaults, and for those programs with structured output files, the
structure of those output files are analogous to the return signatures
of code-level structures.


This guidance may be more straightforward to understand and apply
for code-level structures which have more formalized argument and
return signatures.  User-facing command-line and GUI programs should
include verbose information in their documentation that describes what
a user can expect as far as the structure of the output.


## More Specific Examples

Adding new arguments to code level structures does not violate the
existing public API as long as they provide a default value. For
example changing a function *doThing(int a, double b)* to *doThing(int
a, double b, double c=1.0)* does not violate the existing API for
the *doThing* function as code that calls the *doThing* function will
still compile without modification.

Adding new optional arguments or arguments with default values to
command line programs does not violate the existing public API. For
example, adding a new argument called "check" that has a default
value of "false" to a command line program does not violate the
program's public API as scripts and commands that were valid
previously are still valid after the addition.


### Unstructured text files

For anything of an inherently unstructured file-type, like .txt;
there is no guarantee of its contents; just that it will exist.
For example, no guarantee of the contents of the bundleout.txt files
generated by jigsaw is expected. They are purely human-readable
output and not designed to be parsed programmatically. So sections
can be added, removed, spacings on tables can be changed, etc.


### CSV output files

Column names and data types are part of the API.

For example, a program that writes out a CSV should clearly describe
the output columns which include the fieldname, data type, and
whether non-data-type values can be present (e.g. a column of
floating point numbers named "minimum" that could contain the string
"NULL" instead of a floating point value).

New columns can be added (feature), but if a column's characteristics are 
changed or removed, that's a breaking change.


### PVL files

Object, group, and keyword names are a part of the API.

For example, the "minimum" keyword will exist in the "statistics"
group. This also applies to the PVL labels in Cube files.

New aggregates or keywords can be added (feature), but if any are changed
or removed, that's a breaking change.  PVL text does have data types, and
changing something from `MIN = 5` to `MIN = "5"` is changing the data type
of the keyword MIN from an integer to a string.
