#ifndef MarciCamera_h
#define MarciCamera_h
/**
 * @file
 *
 *   Unless noted otherwise, the portions of Isis written by the USGS are
 *   public domain. See individual third-party library and package descriptions
 *   for intellectual property information, user agreements, and related
 *   information.
 *
 *   Although Isis has been used by the USGS, no warranty, expressed or
 *   implied, is made by the USGS as to the accuracy and functioning of such
 *   software and related material nor shall the fact of distribution
 *   constitute any such warranty, and no responsibility is assumed by the
 *   USGS in connection therewith.
 *
 *   For additional information, launch
 *   $ISISROOT/doc//documents/Disclaimers/Disclaimers.html
 *   in a browser or see the Privacy &amp; Disclaimers page on the Isis website,
 *   http://isis.astrogeology.usgs.gov, and the USGS privacy and disclaimers on
 *   http://www.usgs.gov/privacy.html.
 */

#include "PushFrameCamera.h"

namespace Isis {
  /**
   * @brief Marci Camera Model
   *
   * This is the camera model for the MARCI Instrument
   *
   * @ingroup SpiceInstrumentsAndCameras
   * @ingroup MarsReconnaissanceOrbiter
   *
   * @author 2008-10-23 Steven Lambright
   *
   * @internal
   *   @history 2008-11-19 Steven Lambright - Added distortion model, made VIS bands other than
   *                           orange work
   *   @history 2008-11-25 Steven Lambright - The coloroffset now works properly; if an offset is
   *                           supplied in marci2isis the cube will still project properly.
   *   @history 2009-03-17 Steven Lambright - Fixed UV to work with the distortion
   *                           model correctly
   *   @history 2009-05-21 Steven Lambright - Fixed GeometricTilingHint for summed images
   *   @history 2009-08-28 Steven Lambright - Changed inheritance to no longer inherit directly from
   *                           Camera
   *   @history 2011-05-03 Jeannie Walldren - Updated unitTest to test for new methods. Updated
   *                           documentation. Removed Mro namespace wrap inside Isis namespace.
   *                           Added Isis Disclaimer to files. Added NAIF error
   *                           check to constructor.
   *   @history 2012-07-06 Debbie A. Cook, Updated Spice members to be more compliant with Isis 
   *                          coding standards. References #972.
   *   @history 2014-04-17 Jeannie Backer - Updated due to method name change in
   *                           PushFrameCameraDetectorMap. Moved method implementations to cpp file.
   *                           References #1659
   *   @history 2015-08-12 Ian Humphrey and Makayla Shepherd - Added new data members and methods
   *                           to get spacecraft and instrument names. Extended unit test to test
   *                           these methods.
   *   @history 2015-10-16 Ian Humphrey - Removed declarations of spacecraft and instrument 
   *                           members and methods and removed implementation of these methods
   *                           since Camera now handles this. References #2335.
   */
  class MarciCamera : public PushFrameCamera {
    public:
      // constructor
      MarciCamera(Cube &cube);
      ~MarciCamera();

      // Sets the band to the band number given
      void SetBand(const int band);
      bool IsBandIndependent();

      virtual int CkFrameId() const;
      virtual int CkReferenceId() const;
      virtual int SpkReferenceId() const;

    private:
      void StoreCoefficients(int naifIkCode);
      void RestoreCoefficients(int vband);

      double p_etStart;              //!< Ephemeris Start iTime
      double p_bandTimeOffset;       //!< Offset iTime for Band
      double p_exposureDur;          //!< Exposure Duration value from labels
      double p_interframeDelay;      //!< Interframe Delay value from labels
      int p_nframelets;                 //!< Number of framelets in whole image
      std::vector<int> p_detectorStartLines;
      std::vector<int> p_filterNumbers;
      std::vector<int> p_frameletOffsets;
  };
};
#endif

