<?php
/*  Feed2JS : RSS feed to JavaScript Style Maker
	style.php
	
	ABOUT
	This script can be used to select and create variations
	of style sheets used for Feed2JS
		
	Developed by Alan Levine 26.may.2004
	http://cogdogblog.com/
	
	MORE:
	Part of the Feed2JS package
	See http://jade.mcli.dist.maricopa.edu/feed/

*/


	
// POSTED VARIABLES ---------------------------------------------
// get PHP variables
	
	$feed = $_REQUEST['feed'];
	$flavor = $_REQUEST['flavor'];
	
	include 'style/style_pile.php';
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Stylize Your JavaScript RSS Feed</title>
	<link rel="stylesheet" href="style/main.css" media="all" />

</head>
<body>
<div id="content">

<h1>Feed2JS: Style a Feed</h1>
<p>Once you have <a href="build.php">built the code for your Feed2JS</a>, you can see how the output of RSS content generated by Feed2JS can be customized by applying different style sheets. Each part of the feed has an identifier, allowing you to add styles to the box containing the feeds, the title, the item display, and the date posting text. A few sample styles are provided here; for more see the <a href="http://jade.mcli.dist.maricopa.edu/feed/index.php?s=style">Feed2JS Style Center</a>.
</p>

<form method="post" action="style_preview.php" target="sty">
<h2>Try on a Style Sheet</h2>
<p><strong>URL</strong> Enter the web address for the RSS Feed to "stylize"; if you do not have one handy, you can use the one below from <a href="http://cogdogblog.com/">CogDogBlog</a>.<br />
<input type="text" name="feed" size="50" value="<?php if ($feed) {echo urldecode($feed);} else {echo 'http://cogdogblog.com/feed/';}?>"></p>

<p><strong>Style Selector</strong><br>
These are but a  few style varieties to sample- you are invited to modify or create your own. If you have a snazzy, prettier version, please send it our way. For a blank slate, select the "none/template" style.<br>
<select name="flavor">
<option value="">Select a style...</option>

<?php
	foreach ($mystyles as $cname => $ctitle) {
		if ($flavor == $cname) {
			$selected = 'selected';
		} else {
			$selected = '';
		}
	
		echo "<option value=\"$cname\" $selected>$ctitle</option>";
	}
?>
</select>
<input type="submit" value="style this feed!" />
</p>

</form>

<h2>Using a Style Sheet</h2>
<p>You will need to incorporate the CSS code or linkage in your own HTML files; there are two ways you can do this:</p>

<ol class="spread">
<li><strong>Insert the CSS directly into the HTML for the page that will display the feed.</strong> This methods is best for sites that only are displaying the feed on one or a few pages. Use the form below to find the style you desire, copy the CSS, and paste it somewhere into the <code>&lt;HEAD&gt;...&lt;/HEAD&gt;</code> of your HTML file that contains the Feed2JS code, surrounded by the <code>&lt;style&gt;...&lt;/style&gt;</code> tags shown below.
<pre>&lt;style type="text/css"  media="all"&gt;

&lt;!--  this is where you paste the CSS provided by the form below --&gt;

&lt;/style&gt;</pre></li>

<li><strong>Link to an external style sheet.</strong> This method is best if you will be using the feeds on multiple pages, as the CSS is stored externally, and thus allows you to change the output display of many pages by editing a single file. Just copy the CSS provided by the form below, and paste it into a new text file. Save it as something called "myfeed.css". Think smart about where you decided to store this file, as other HTML pages that call it need to define a correct path to the file. Many web sites just create a top level directory named <code>style</code> and store all style sheet files in this directory.<br><br>
Regardless, to connect the HTML file that contains the Feed2JS code to an external style sheet, insert this line into the <code>&lt;HEAD&gt;...&lt;/HEAD&gt;</code> of your HTML.
<pre>
&lt;link rel="stylesheet" href="style/myfeed.css" media="all"&gt;
</pre>
Remember again that the value of <code>href=</code> must be a correct relative path (or a full valid URL such as http://www.blah.com/style/myfeed.css) from the HTML file to the CSS file.</li>
</ol>

<h4>CSS classes</h4>
<img src="style/css_classes.gif" alt="" width="360" height="223" border="0" align="right">
<p>This sketch represents the CSS classes created by Feed2JS.</p>
<ul class="nospread">
<li><strong>rss-box</strong> defines the bounding div for the entire display- use to define borders, fill, etc.</li>
<li><strong>rss-title</strong> the title of the feed and link style if displayed. Use with variants of <code>rss-title a:link, rss-title a:hover</code>, etc for rollowver styles</li>
<li><strong>rss-items</strong> defines the unordered list <code>&lt;ul&gt;...&lt;/ul&gt;</code> for the feed items- use to define the padding/margins for items.</li>
<li><strong>rss-item</strong> display of each feed item description and title, <code>&lt;li&gt;...&lt;/li&gt;</code> as well as the channel description, if displayed.</li> 
<li><strong>rss-item a:</strong>  variant for the item title and link style</li>
<li><strong>rss-date</strong>  defines the display of item posting dates</li>
</ul>

<p>For any RSS 2.0 feeds with podcast enclosures, Feed2JS will provide a <strong>Play XXX</strong> link, where "XXX" is the extension of the media file, e.g. "mp3", "m4a", etc. The styles applied are modeled after <a href="http://www.wellstyled.com/css-inline-buttons.html">Well Styled's Inline Buttons</a> method. 
<pre>
&lt;div class="pod-play-box"&gt;
&lt;a class="pod-play" href="podcastURL"&gt;&lt;em&gt;Play&lt;/em&gt;&lt;span&gt; File&lt;/span&gt;&lt;/a&gt;
&lt;/div&gt;
</pre>

<img src="style/play-button.jpg" alt="" width="81" height="16" hspace="8" vspace="4" align="right" border="2">

<p>Custom colors may be achieved by editing appropriate foreground and background colors from the base styles (emphasized below):</p>
<pre>
.pod-play {
   _width:12em;
   margin: 0 0.2em; padding: 0.1em 0; _padding:0;
   
   white-space:nowrap;
   text-decoration: none;
   vertical-align:middle;
   <strong>background: #fb6;
   color: black;</strong>
   }
.pod-play em {
   _width:1em; _cursor:hand;
   font-style: normal;
   margin:0; padding: 0.1em 0.5em;
   <strong>background: white;
   color: #222;  </strong>
   }
.pod-play span {
   _width:1em; _cursor:hand;
   margin:0; padding: 0.1em 0.5em 0.1em 0.3em;
   }
.pod-play:hover {
   <strong>background: #666;
   color: white;  </strong>
   }
.pod-play:hover em {
   <strong>background: black;
   color: white  </strong>
   }
</pre>


<br clear="right">

<a name="2style"><h4>Advanced: Two Styles in One Page</h4></a>
<p>If you have more than one feed displayed per page, you can assign different styles to each display. <em>You will need a solid understanding of CSS and inheritance to get this to work!</em>.</p>

<p>By supplying a value for CSS Custom Class in the <a href="build.php">build form</a> you can now create different top level classes. The value passed will create a CSS class named <strong>rss-box-XXXX</strong> where <strong>XXXX</strong> is this value. This implies that you may have to define more specific classes for the other classes listed above, or use the top level <strong>rss-box-XXXX</strong> classes to say define a different background color.</p>

<p>See  two examples:</p>
<ul class="spread">
<li><strong><a href="http://jade.mcli.dist.maricopa.edu/feed/2css_a.html">Two Completely Different Styles</a></strong>. The second style has a value of <code>css=spirit</code>, so all CSS elements are defined to be a descendant of this class.</li>

<li><strong><a href="http://jade.mcli.dist.maricopa.edu/feed/2css_b.html">Two Similar Styles</a></strong>. In this case, the only difference is the background color, which can be specified in the <strong>rss_box_w</strong> and <strong>rss_box_g</strong> classes.</li>
</ul>


</div>

<?php include 'footer'?>

</body>
</html>
