# Contributing to ISIS3
# Under Construction
The following is a set of guidelines for contributing to ISIS3.
#### Table of Contents

[I have a problem or a question](#have-a-question-or-a-problem)

[Redmine Issues](#redmine-issues)

[How can I contribute?](#how-can-i-contribute)
  * [Report an issue](#redmine-issues)
  * [Suggesting enhancements](#redmine-issues)
  * [Working on an existing issue](#working-on-an-existing-issue)
  * [Working on an existing enhancement](#working-on-an-enhancement)
  * [Working on a new issue or enhancement](#working-on-a-new-issue)

[Code Base Contribution Guidelines](#code-base-contribution-guidelines)

[What can I expect from the ISIS3 development team](#What-can-I-expect-from-the-ISIS3-development-team)
  * [Response time](#Response-time)
  * [Feedback](#feedback)

[Development Process Checklists](https://github.com/USGS-Astrogeology/ISIS3/wiki/Developer-Checklists)

### References
  * [ISIS3 API Reference](https://isis.astrogeology.usgs.gov/Object/Developer/index.html)
  * [Tutorials](https://isis.astrogeology.usgs.gov/fixit/projects/isis/wiki/ISIS_Online_Workshops)
  * [Application Documentation](https://isis.astrogeology.usgs.gov/Application/index.html)
  * [Coding Standards and Style Guide](https://isis.astrogeology.usgs.gov/documents/CodingStandards/CodingStandards.html)
  * [Documentation](https://isis.astrogeology.usgs.gov/documents/CodingStandards/CodingStandards.html#documentation)
  * [Redmine Issue Lifecycle](https://isis.astrogeology.usgs.gov/fixit/projects/isis/wiki/Life_Cycle_of_an_ISIS_Issue)
  * ADD MORE THINGS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  
## Have a question or a problem?
If you have a question about or a problem with ISIS3, please see the [Redmine Issues](#redmine-issues) section.

If you have a question or a problem with contributing to our software please contact ## REGENT EMAIL HERE ##.

## Redmine Issues
If you have a question about, a problem with, or a suggestion for ISIS3, please read our [Guidelines for reporting Redmine issues](https://isis.astrogeology.usgs.gov/fixit/projects/isis/wiki/Guidelines_for_Reporting_Issues). Once you have read that please [submit](https://isis.astrogeology.usgs.gov/fixit/projects/isis/issues/new) a Redmine issue.

## How can I contribute?
There's lots of ways to contribute to ISIS3.

### Working on an existing issue
1. Assign the redmine issue to yourself. If you don't have the permission to do this, please make a note on the issue that you would like to work on it. Please contact ## REGENT EMAIL HERE ## for permission to work on an issue.
2. Propose a solution on the redmine issue. 
3. Work with an ISIS3 developer, the issue reporter, and any other interested parties to get feedback on your solution. This may be an iterative process.
4. Add an [impact statement](https://isis.astrogeology.usgs.gov/fixit/projects/isis/wiki/Impact_Statement) to the redmine issue. If you don't have the permission to do this, please make a note on the issue with the impact statement.
5. Make the changes on your fork of the ISIS3 main GitHub repo. Follow the [Code Base Contribution Guidelines](#code-base-contribution-guidelines).
6. Follow the Developer's Checklist to ensure your changes are ready for review.
7. Make a pull request. Include the redmine issue number in the title of the pull request. Use the "Fixes #0000" format.
8. Work with your code reviewer, tester, and reporter to improve your changes. Your pull request will not be merged in until all parties approve the changes.
9. Check in your test data. If you are an outside contributer, work with your code reviewer to ensure your tests and test data get checked in.
 
## Code Base Contribution Guidelines

