# Concepts
Concept docs are understanding-oriented docs. The focus is on explaining a topic. These expand the user's understanding of a topic without elaborating on particulars of code while providing context or descriptions. Information from concept docs might be among other docs, but getting started docs, how-to guides, or software manuals can reference concept docs that go in-depth on the topic. 

## For Readers 
[comment]: <> (This is a good place to mention any places for someone to start looking in. Highlight specific docs with high value or we identify readers commonly want to see)

Use the table of contents on the left to browse docs covering different concepts. 

Good place to start is with the [glossary](glossary.md)

## For Authors 

These docs are predominately abstracts on a particular topic. 

Good concept docs have: 

1. A clear and specific topic of discussion   
1. Little to no instruction 
1. Context or descriptions of: 
    * Historical background of the software and/or why it exists
    * Engineering of a software tool or component thereof 
    * Concepts commonly found across software 

??? Info "Examples"

    * Dictionaries or Glossary of terms
    * Explanation of what control networks are and why we use them
    * History and explanation of ALE's architecture 
    * Differences between CSM and ISIS camera models 

See the [git repo](https://code.usgs.gov/astrogeology/asc-public-docs) for more in-depth info on how to contribute new docs. 