# asc-public-docs


## Getting started

To make it easy for you to get started with GitLab, here's a list of recommended next steps.

Already a pro? Just edit this README.md and make it your own. Want to make it easy? [Use the template at the bottom](#editing-this-readme)!

## Add your files

- [ ] [Create](https://docs.gitlab.com/ee/user/project/repository/web_editor.html#create-a-file) or [upload](https://docs.gitlab.com/ee/user/project/repository/web_editor.html#upload-a-file) files
- [ ] [Add files using the command line](https://docs.gitlab.com/ee/gitlab-basics/add-file.html#add-a-file-using-the-command-line) or push an existing Git repository with the following command:

```
cd existing_repo
git remote add origin https://code.usgs.gov/astrogeology/asc-public-docs.git
git branch -M main
git push -uf origin main
```

***


## Description


## Contributing Docs

Contributors should consider writing new docs under one of our four categories:
 
1. Getting Started 
1. How-To Guides 
1. Concepts 
1. Software Manuals

### Getting Started Docs

These are longer "learn by doing" exercises that users can follow to learn some extended process using the libraries. These should have the user execute code or run commands from the library to complete a task.

Good getting started docs should: 

1. Have a clear and specific goal
1. Can be followed verbatim by the user
    * Include software versions used when creating the tutorial
   * Use Jupyter notebooks when possible 
    * Avoid dead data links; try using data generated by the tutorial or include data relative to the repo
1. Make sure users see results immediately 
    * Data should not be so large it takes a long time to download or process.
1. Include minimum explanation; the focus is on "learning by doing"
1. Focus on the steps required to complete the goal. 

Examples: 
* Getting Started: ISIS image ingestion to map projected image, ingesting, bundling, and projecting an image list 
* Getting Started: generating an ISD and CSM camera model
* Getting Started: Generate a control network with an image matcher 

### How-to Guides 

How-to guides are much like recipes in a recipe book. Write how-to docs to solve specific problems quickly, sometimes copy-pastable. Think of how-to guides as pre-emptive StackOverflow-like problems.

Similar to getting started guides in that they explain to users how to perform some valuable tasks with the software, but distinct in that they:

1. Solve practical problems for more experienced users
1. Offer more ambiguous starting points; they should be re-usable in many different contexts 
1. Provide little explanation, mostly showing steps on how to accomplish the task
1. Are generally much shorter than getting started docs

Examples: 
* How-to: generate an ISD via loads with specific kernels
* How-to: get GEOJSON from ISIS footprints

### Concepts 

Concept docs are understanding-oriented docs. The focus is on explaining a topic. These expand the user's understanding of a topic without elaborating on particulars of code while providing context or descriptions. Information from concept docs might be among other docs, but getting started docs, how-to guides, or software manuals can reference concept docs that go in-depth on the topic. 

Good concept docs have: 

1. A clear and specific topic of discussion   
1. Little to no instruction 
1. Context or descriptions of: 
    * Historical background of the software and/or why it exists
    * Engineering of a software tool or component thereof 
    * Concepts commonly found across software 

Examples:
* Dictionaries or Glossary of terms
* Explanation of what control networks are and why we use them
* History and explanation of ALE's architecture 
* Differences between CSM and ISIS camera models 

### Software Manuals 

Software manuals centered on the code of the library. These are generally links to the library's programmatically generated API docs. Think Sphinx docs and/or Doxygen-generated docs. 

Examples: 
* Programatically generated Python/C++ API docs from inline doc strings
* RESTful API docs from an OpenAPI spec file 
