# Guidelines

## Before you Report an Issue:

  - Make sure you are running the most recent version of ISIS3.
  - Search for existing issues similar issues to yours. If you find a
    pre-existing open issue, you may add a note with your new
    information or just indicate you are also experiencing this issue.
    If you find a pre-existing closed issue, please start a new issue
    and relate it to the old one.
  - Use this issue tracking system to communicate with the ISIS Support
    Team. If we receive direct emails we may ask you to post a new
    issue.

## Step-by-step Issue Reporting:

1.  Tell us if this is a Bug, a Feature Request, a Question, a
    Recommendation, a problem with Documentation, or a Crash that is
    stopping your work.
2.  Provide a clear but concise subject for your new issue. Consider
    including the program name (e.g., "destripe is missing reset icon in
    the toolbar").
3.  When describing your issue, provide a clear description of the
    issue. We need as much information as possible to help us identify
    and fix the problem. Too much information is better than not enough.
    Feel free to use the markdown tools to better illustrate the issue.
    This is especially useful when quoting error messages or
    documentation.
4.  Consider including these in your description:
      - All the steps necessary to reproduce the problem
      - Command line with the exact arguments you used
      - Spacecraft and instrument names of the input files
      - Is the issue consistently reproducible?
      - Your operating system or distribution name and version
      - The exact error message. If possible, copy-paste the error
        messages into the issue description.
5.  Select the priority you feel this issues needs.
6.  Select the appropriate Category. Usually you'll only want to use
    Applications and Installation. Developers may need to report an API
    or Infrastructure issue.
7.  Include the ISIS software version you are working with.
8.  Keep a close watch on your email for changes in the issue status and
    for notes being added. If the support team needs additional
    information they will add a note to the issue with the request.

## Miscellaneous guidelines

1.  If you have multiple problems, please create separate issues for
    each one.
2.  If a screenshot or text file is necessary to illustrate the issue,
    attach one to your post, but please keep the files as small as
    possible.
3.  No advertising is allowed anywhere on the site. Any advertisements
    will be deleted immediately.
