---
title: Spatial Standards
weight: 50
---

### Body Parameters
- The Report of the IAU Working Group on Cartographic Coordinates and Rotational Elements: 2015 (2018) body parameters will be used. This includes a sphere radius of 1560.8km and rotation parameters as defined in Table 2 (Archinal, et al., 2018).

### Horizontal and Vertical Datum
- No consistent mean sea level is currently definable for Europa. Therefore, no single vertical datum can be defined. All elevation data are, at this time, assessed for relative, internal, consistency an accuracy as absolute accuracy assessment is not possible without a vertical datum.
- The origin of horizontal datum to be used is defined by the IAU as 182˚ East longitude, 0˚ planetocentric latitude. For maximum usability, we encourage data creators to register data sets (either rigorously or using rubber sheeting techniques; with appropriate documentation) to the Schenk/USGS basemap.

### Map Projections
- Data are provided in a simple cylindrical (equirectangular) map projection.
- Data are orthorectified to a sphere using the IAU mean radius => 1560.8 km (sphere)
- Data are made available in a 0 – 360 Positive East coordinate system with a center longitude of 180 degrees and use planetocentric latitude. 
- For observational data, pixel scale or resolution should be maintained at native scale, (i.e., do not up sample or down sample data.)
- For derived data (e.g., DTMs), data should be made available at a reasonable resolution that avoids extrapolation of information.
- Data for large spatial scale (e.g., 1:24000), small spatial extent maps, (e.g. landing sites) can be provided in an orthographic projection centered on image.
- Data for polar areas (latitudes > 55˚ North or South) should use an orthographic projection centered on site or a polar stereographic projection centered at the pole

## Ephemeris Information
- All sun, spacecraft, sensor, and target body ephemeris information is to be provided either by [Navigation and Ancillary Information Facility (NAIF)](https://naif.jpl.nasa.gov/naif/) as SPICE kernels or in NAIF SPICE compliant format by another provider (e.g., a mission team). This includes sensor and target positions, velocities, and orientations as well as sensor parameters such as distortion models.