---
date: '2022-12-08'
title: '2022-12-08 Working Meeting'
---

{{<  meeting-notes >}}

[Teams Link](https://teams.microsoft.com/l/meetup-join/19%3ameeting_NjM0MzI5NGUtZDI1ZS00YWVjLWI1MTctYjUzZTU4OTVlNWIz%40thread.v2/0?context=%7b%22Tid%22%3a%220693b5ba-4b18-4d7b-9341-f32f400a5494%22%2c%22Oid%22%3a%22c27c6e98-e45a-45ff-aea5-7f10d6fe67c1%22%7d)
No dial in number yet, sorry!

## Attendees
- Jay Laura
- Brent Archinal
- Laz Kestay
- Marc Hunter
- Julie Stopar
- Ross Beyer
- Noah Petro

## Agenda
- LPSD Abstract
- LEAG Meeting (Executive Group)
- Lunar SDI Standards

## Notes

- LPSC Abstract
  - Jay working on it. Will be Europa / Lunar.
- LEAG Meeting (Executive Group)
  - Other folks that want to dial in. It's 2PM on the 12th.
  - I'll ask again about you all dialing in.
  - Take a look at the findings that they issues a few days ago. Specifically, special action team, something between MAPSIT and LEAG.
    - See the LEAG findings [here](https://www.lpi.usra.edu/leag/reports/LEAG2022AnnualMeetingFindings_FINAL.pdf), particularly finding 6.
- Lunar SDI Standards:
  - Data interoperability and (???) should make heavy use of hyperlinks.
    - Will add references.
    - Brent will get some additional links / references as well.
  - Data interoperability: Longitude domain. GISystems want -180 to 180. Compelling reasons to force 0-360?
    - Another GISer applauded. This avoid problems. What are the reasons not to do this?
    - Ross: It is hard to get away from being bi-lingual.
    - Historically, this has been 0-360. Brent, doesn't see these going away. If we want to recommend that one that is absolutely fine. Why doesn't the software accomodate 0-360?
    - Where are the data creators working?
      - Ross: Working in 0-360
      - Large Mare work: 0-360 is a pain
        - Why? It's hard to make a large mare mosaic when 330 - 90. Data also splits.
        - Raster is easier / vector is worse.
      - Recent versions of desktop GISs are not an issue.
    - LRO standard is 0-360.
      - Difference between storage standard and display standard.
      - Propagate the standard.
      - It is easy to omit the negative.
      - Fear of mistakes is not a great rationale - but it is definitely a data point.
    - Motion: Adopt 0 to 360 for data storage. Laz seconded.
      - Julie, no perfect solution.
  - Data interoperability -> Map Projections: 'centered on an image' - what does that mean? Poor language.
    - Julie - will feel foreign to have data in non-equirectangular or orthographic projections.
    - Brent - storage vs. display. Lunar Geodesy Cartography working group. Use Equirectangular, except where you use polar stereographic. For display, you need to do your thing.
    - Julie: What is the goal for data interoperability - 
      - User: Just visualize, ad discovery, and interoperability with well calibrated (photometric, radiometric, geometric)
      - Producer: Make data.
    - That rationale is not clear for the map projections. When we get to the local stuff, the perspective is going to be different than at smaller scales.
    - What context can be added to the standards to provide a framework for making these decisions?
    - Separate discussion for what projections for what processes / analyses?
      -  Can make general recommendations, but local stuff is wide open.
   -  Has Artemis discussed? Engineers want a local system?
   -  Remove the bullets about specific projections. Everything goverened inside the Lunar SDI will be equirectangular. Caveats are confusing. 
   -  In another section, we can provide local scale ideas and support.
  - Cartographic Standards - Styled Layer Descriptor for vector symbols in GeoPackage format
    - These are really hard, especially when beyond a color / line style. SLD is an OGC standard for cartographic representations. Works great with GIS data in a GeoPackage. This is not tied to an ArcGIS project. This decouples application specific data without losing the value of the symbology. This highlights a gap where there is not great support for translation of SLDs.
  - Metadata Standards: metadata standards - support of FGDC or ISO, recommending the transition to ISO (reduces friction with accuracy descriptions). Also, should we address unique resource identifiers for data, people, organizations, controlled vocabularies, etc.?
    - Use a standard. Gov is moving towards ISO. (SPD-41a talks about the need to index metadata.)
    - Stuff is available in Dublin Core, etc.
    - Suggest that folks conform to ISO, be happy with others.
  - Future discussion:
    - Recommendations on unique identifiers. How are they used, where will they be used, etc?
  - Brent: Generic improvements. (Jay will integrate.)
    - Not sure that the headings make sense. Some things seem like cartographic standards. How are the headings organized? Should these change? What is missing?
      - Headings are not absolute. Re-organization is great.
      - There should be a section that disucsses reference frames separate from the
      - Cartographic standards should have map projection information, scale, etc.
    - Data format standards:
      - Separate thing. How do you store data? Does this need additional information?
    - Lunar Geodesy Cartography Working Group (Cartographic or data format section)
      - Thought about tiling. How do you separate the data? Do we have / endorse a quad system?
      - Tiling?
      - When tiling schemes are in conflict that causes interoperability issues.
    - Need to continue having lunar quads?
      - Do we need to explain them or recommend their use?
- Motion:
  - Clean, add context, reorganize, executive summary, and solicit for feedback.
- Open floor


## Action Items
- From last meeting:
  - All: Review governance documents. Async discussion as appropriate. Goal is to be able to discuss in person anything where consensus is hard to find in January.
  - All: Think about an LPSC abstract (due 2 days before our January meeting). Likely a great opportunity to publicize our work. Discuss async if possible to keep space for standards discussion. I (Jay) can write a lunar/europa SDI one or a separate lunar and Europa one. Anyone on here can first author this too!