---
title: About
weight: 0
---

Europa is a remarkable ocean world, the smallest of the four Galilean satellites orbitting Jupiter, that continues to be the focus of intense scientific study. Europa may be the current best location to explore in search of life outside of Earth. In addition to the innumerable telescopic observations of Europa, many satellites have visited this intriguing world and captured a myriad of different types of data. It is from these data that we, research scientists, policy makers, and the interested public learn more about this distant world.

Each dataset collected with observations of Europa is a treasure in its own right. Collectively, these data sets provide a rich perspective from which we can learn about the past, present, and potential future for Europa. The desire for cross-data set interoperability and ease of data discovery were the impetus for the development of this Europa Spatial Data Infrastructure (SDI). 

The Europa SDI is focused on the organization of spatial data. These data are identified, standardized, and made available so that you, the user, can discover, access, and use them more efficiently. Scientists from multiple different institutions have come together to develop and agree upon spatial standards and data interchange formats that support cross data set analyses.

For data providers, this means that we want to work together to make your data available to as broad a user base as possible. This includes helping build great documentation that describes your data, helping get that data to be standards compliant, and then finding a data host to serve that data over the web.

For data hosts, we want to work together to help you adopt OGC standards and serve data to widest possible user base. This means linking your data services into registries with other compliant data provider's services so that tool developers can build rich data portals and analysis environments for users.

Finally, we want to work with the user community to ensure that we are meeting their needs. Are appropriate data available and discoverable? Is documentation accessible and written at a level that makes data approachable?