---
date: '2022-10-20'
title: '2022-10-20 Working Meeting'
---

{{<  meeting-notes >}}

## Attendees
- Jay Laura
- Paul Schenk
- Mike Bland
- Robin Fergason
- Ross Beyer
- Cynthia Phillips

## Agenda
- Website
  - Site is now live at https://psdi.astrogeology.usgs.gov and https://planetary-sdi.astrogeology.usgs.gov
  - All comments from last meeting should have been addressed. If you notice anything, let us know!
  - Data is now a tabular set of links to the data Mike has released.
    - Those data have now been released via the NASA/Amazon Open Data Registry (ODR). They are free to access for anyone with Amazon footing the bill! [LINK](https://registry.opendata.aws/nasa-usgs-europa-observations/)
    - I want to highlight the tutorials section on that page. We could use some help adding more data usage.
- Discuss additional Data
- Data services update:
  - Jay is working on a vector service to compliment the STAC (raster) service. Can we start to collect raster data sets.
    - Note: Vector data vs. map
- Question from external user:
  - "(By the way, the longitude for these photogrammetrically corrected images are in east-positive direction, whereas the .lbl files that can be downloaded with it are in west-positive direction. Is there a reason for that?)" - How do we want to handle this? Where can we provide information to help users with this issue as it is likely reoccurring?
- Data updates:
  - Paul's data
  - Trent - Europa geologic map status
  - Trent - Williams Linea Map
  - All: Consider how the current Europa SDI compliant data might be used. Consider creating some documentation / tutorials to help with evangalizing the content.
  - Paul: Data to Jay for inclusion and release.

## Notes:
- Using the data:
  - Cynthia has a graduate student that is doing some Juno / Galileo change detection. The use case is going to be search.
  - Mike, sounds like a great project. Shows use of new data with the existing data.
  - Project is working on an ISIS installation.
  - Mike, maybe talk to Laz about these data for photometry work and photometric modelling. What has his approach been? Could this work have been done using these externally available data?
- Paul's data:
  - Will send the stereo DEMs at some point.
  - JunoCam data:
    - Working with Juno to attempt to integrate it into the control network
    - JunoCam images cross a major gap in the Galileo data (30-50E)
    - Going to register the data; resolution is close to Galileo in that area
    - This control process has been tested with Ganymede data
    - Questions exist about the sensor model still
    - After the first iteration, Paul to connect with Mike to discuss usability
    - Hope is to understand how bad control is in the 30-50 range
    - The second goal is to use the data in the 200m base
    - Plan is to insert the juno data where it is better than galileo assuming the sensor distortion model works
    - This will help Cynthia's project as Juno will be co-registered with existing Galileo data
    - Updated kernels will be generated
    - Will not attempt geologic mapping - will attempt stereo for major topographic deviations
    - Waiting for the PDS release of the data; JPEGs aren't usable for this work. (2-4 weeks out.)
    - Official PDS release timeline is sometime out (months)
  - Horizontal datum - how does the above effect the timeline for releasing a defined horizontal datum and a product that defines the datum?
    - Paul won't reprocess the final version of the 200m base until Juno data are incorporated.
    - Timeline is the end of the calendar for the merged 200m base.
    - Mike: torn, agree that including Juno data will change things by some amount. It would be good to think about how to ensure that the USGS data and the 200mpp base will be interoperable. Are all of the images included in the control network? (Yes, all the images.)
    - USGS won't be including the Juno data in the USGS network. For the mosaic, including the Juno data is quite important and makes sense.
    - How do we ensure consistency with the USGS data?
    - Paul will take the USGS control network and use that as the input to the process. Paul will take the USGS network and the Juno data to that network. Then Mike can check the results to determine if the network is improved.
    - Timeline:
      - 2-3 months(ish), if no hiccups for Paul to work with the Juno data.
      - Will result in updated ephemeris information for Juno images. This might update the USGS image data.
      - If this updates the USGS data, we will need to re-release the ARD.
      - 4-6 months release ARD Juno data / maybe re-release USGS data / official horizontal datum definition. 
  - Use of the vector data:
    - intersection with other data sets
    - what manner of data serving supports this use case?
    - by serving the geologic map as ARD are we doing anything? Are we providing a product that is different from the AGOL pages?
    - What other types of vector data types might exist?
      - Geologic maps (vector + map)
      - Craters (vector); Bo
      - Linea (vector)
  - Positive east - documentation. 
    - Do we want to translate labels - probably not!
    - Do we want to have a FAQ page about the data?
      - Paul likes that idea.
    - Labels are not describing the GeoTiffs, labels are describing the original PDS data.
    - We 'could' write PDS4 labels for these, but that is unlikely to happen.
  - OPAG coming up in November.
    - Cynthia would be happen to mention if we are up and running to accept data.
    - Promote the website.

## Action Items
- Status update from Paul re: Juno data
- Mike reach out to Bo to see if he is interested in having us publish the vector data