---
title: "Roadmap"
weight: 2
---

## Performance Indicators
Several performance indicators will be measured over the time period from 2022 to 2025 to gauge the effectiveness of the implementation of the Europa SDI Strategic Plan, as well as the effectiveness of the Europa SDI itself. These efforts will be measured, assessed and tracked annually over the 2022-2025 timeframe with regular reports publicly available.
 
Performance indicators will include qualitative or quantitative metrics on: 
- Relevance of Europa SDI reference and thematic data to users 
- The use of the Europa SDI Geoportal, web services, and metadata 
- User satisfaction of reference and thematic data and services 
- Known applications based on the Europa SDI and their relevance 
- Europa SDI policies and standards influence on the development of other NASA SDIs and/or other relevant management policies

## Objectives and Anticipated Outcomes

This plan contains information regarding how the strategic objectives will be implemented within the Europa SDI including the anticipated outcomes, approach, and a table of actions including a general timeline. 
 
### Objective 1
Publish and steward the policy infrastructure necessary to maintain this SDI, including a charter, governance documentation, memorandums of understanding to support data release and sharing agreements, and a roadmap of future development.

#### Anticipated Outcomes
Publishing and maintaining a policy infrastructure is one of the primary tenants of a Spatial Data Infrastructure (e.g., Laura et al., 2018; Rajabifard et al., 2002), and facilitates communication within the community, coordination between stakeholders, communicates expectations both of the SDI and from participating groups, and establishes efforts for the long-term maintenance of this infrastructure.

#### Approach
The primary approach includes writing documentation that describes 1) the Europa SDI charter, 2) governance policy documentation; 3) strategic direction and a 4-year roadmap; and 4) a memorandum of understanding. These documents will be drafted by Europa SDI working group members and reviewed collectively. We will seek group consensus regarding all governance and strategy decisions. These documents will also be posted on a publicly available website so that members of the Europa community can also comment and provide feedback. 

#### Actions
|  | Action |	Status |
|--|--------|----------|
|1.1	|Write and publish the Europa SDI Charter	|Completed. This charter has been endorsed by MAPSIT.|
|1.2	|Write and publish the governance documentation	|Completed in 2022.|
|1.3	|Write and publish the strategic direction and 4-year roadmap (this document)	|Completed in 2022.|
|1.4	|Write and publish the memorandum of understanding	|This document is under development and in collaboration with NASA and the USGS.|


### Objective 2
Engage with the user community, funding agencies, and NASA Advisory Groups to ensure the efforts of this body maximally align with targeted user community needs.
 
#### Anticipated Outcomes
Engaging a broad range of Europa data users will help to ensure that our efforts strategically align with the needs of the community and will also inform this community of our efforts. In this way, potential users can learn of available data and future planned additions, while also providing opportunities to stay in step with the evolving needs of data users. The feedback we receive from users will help to inform current and future efforts and SDI direction.

#### Approach
We will initially engage high-level stakeholders, including NASA, MAPSIT, and OPAG, to ensure that this working group is addressing a widely recognized need in the community. We will also engage the Europa Clipper mission team to communicate the efforts of this group, seek collaborative engagement, and ensure that our efforts are supportive and not redundant to Europa Clipper team efforts. We will also engage the planetary science community at annual meetings to obtain feedback on our efforts and collaborate with other interested groups. This approach helps us to initially understand the needs of scientists, engineers, mission teams, and software and tool developers. We will then build on this understanding to inform future work to serve the larger community of users and stakeholders, which in addition to the above groups include (but are not limited to) media relation activities, public engagement and education groups, and members of the general public. By engaging the Europa data community through many different avenues, we aim to intersect and meet the data use needs of the broadest group possible.

#### Actions
|  | Action |	Status |
|--|--------|----------|
|2.1	|Engage NASA to ensure this effort is supportive of strategic direction and community needs and provide regular updates.	|Ongoing. This effort directly addresses needs expressed in the Planetary Data Ecosystem IRB Findings; we provide annual updates to NASA Program Managers.|
|2.2	|Engage the Mapping and Planetary Spatial Infrastructure Team (MAPSIT) to communicate the efforts of this group.	|Ongoing. Received an endorsement of our charter and an invitation to present our efforts at future MAPSIT meetings.|
|2.3	|Engage the Outer Planets Assessment Group (OPAG) to communicate the efforts of this group.	|Ongoing. Received with interest and an invitation to present our efforts at future OPAG meetings.|
|2.4	|Engage the Europa Clipper mission team to communicate the efforts of this group and work to establish a cooperative relationship that supports community needs.	|Ongoing. Presented efforts to the Europa Clipper Geology Thematic Working group on January 10, 2022, with interest for continued discussions.|
|2.5	|Present the efforts of this group at relevant community meetings, such as the Lunar and Planetary Science Conference (LPSC) and the American Astronomical Society Division of Planetary Science (DPS) meetings.	|Ongoing. Submitted an abstract describing these efforts to the 2022 LPSC meeting (Laura et al., 2022).|
|2.6	|Engage tool developers to communicate the efforts of this group.	|Future effort|

### Objective 3 
Publish an initial set of standards that will define this SDI including standardized vertical and horizontal datums (i.e, the coordinate system), accepted map projections, interoperable data formats, and metadata formats.

#### Anticipated Outcomes
A defined set of standards for the Europa SDI will foster consistency in projections, data formats, and descriptive documentation in metadata. This consistency will lead to greater interoperability between components in this SDI and will result in data products that are immediately analysis ready by removing the need for additional data processing or reprojection.

#### Approach
Standards will be defined by considering current standards in use for Europa and those most often used by the Europa community.  We will consider existing IAU standards and those favored by the Europa Clipper mission, and we seek to be consistent with standards defined by authoritative sources.  When multiple or conflicting standards are in common use, we will determine the standard we believe best meets the needs of our user community thru discussion within the Europa Spatial Data Infrastructure Working Group. We will publish these standards on a public website.

#### Actions
|  | Action |	Status |
|--|--------|----------|
|3.1	|Inventory existing projection, data format, metadata, and other standards currently in use by the Europa community and including the Europa Clipper mission team.	|Completed in 2022.|
|3.2	|Identify IAU-endorsed standards relevant to Europa.	|Completed in 2022.|
|3.3	|Define a set of standards to be used within this SDI to maximize consistency and interoperability.	|Completed in 2022.|
|3.4	|Publish standards on a public website.	|Completed in 2022.|


### Objective 4 
Maintain, in conjunction with the Europa community, a living inventory of foundational and framework data products including quantitative (e.g., positional accuracy, resolution, data producer) and qualitative (e.g., fitness-for-use) metadata. This includes setting a standard for metadata to be reported for all data products managed under the Europa SDI organization.
 
#### Anticipated Outcomes
Maintaining a living inventory of foundational and framework data products will benefit the Europa data community by simplifying the search and discovery process. Collecting these data into a single clearinghouse, with descriptive and standards compliant metadata, allows the community to know what data products exist, the accuracy of those products, and whether they meet the needs of that use case. In addition, such an inventory allows NASA, mission teams, and data producers to identify gaps in knowledge that could be filled through future efforts.

#### Approach
Our primary approach is to build on the efforts of Laura and Beyer (2021) and use this information as an initial assessment of the publicly available foundational and framework data products for Europa. We will also engage data producers to determine interest in contributing to this SDI and to determine the process to contribute additional data products.  As additional data products are published in the literature or through community data portals/catalogs (e.g., the Planetary Data System), we will include them in our inventory, link to the publicly available products, and assess including them in this SDI.

#### Actions
|  | Action |	Status |
|--|--------|----------|
|4.1	|Inventory the publicly available foundational and framework data products for Europa	|Completed in 2022. Laura and Beyer (2021) provide an initial assessment of such products.|
|4.2	|Engage Europa data producers directly to collaborate and support including products in this SDI	|Ongoing. Working with Dr. Paul Schenk to incorporate Digital Elevation Models into this SDI.|
|4.3	|Maintain knowledge of new data products published by the community for potential inclusion in our inventory.	|Ongoing|
|4.4	|Develop a process for contributing data to this SDI, including a Memorandum of Understanding that supports sharing agreements between stakeholders (related to action 1.4).	|This document is under development.|


### Objective 5
Provide a mechanism to link users, such as data creators (who make the data products), custodians (who manage the data products lifecycle), and data integrators (who provide the data to end users) to create an interconnected user group. 

#### Anticipated Outcomes
The Europa SDI benefits from maximizing the availability of interoperable Europa data in order to support the broadest possible user community. As a communication tool, the Europa SDI links data creators with data stewards who ensure that generated data are broadly available. We anticipate this objective resulting in the identification of institutions that wish to act as data stewards and to whom data creators can submit data for inclusion in the Europa SDI.

#### Approach
Our primary approach is to first lay the groundwork to incorporate data contributions from data creators in a transparent manner where the expectations of the data creators, custodians, and data integrators are clearly identified and documented. Planned initial steps include developing clear documentation of standards and formats that are expected for all data products in the Europa SDI, ensuring such documentation is publicly available, and engaging Europa data producers. Once this initial foundation is established, we will identify institutions that are willing and able to serve as data stewards and engage the broader data community in these efforts.

### Actions
|  | Action |	Status |
|--|--------|----------|
|5.1	|Engage Europa data producers and gain experience incorporating data from multiple institutions (related to action 4.2)	|Ongoing.|
|5.2	|Develop and publish Europa SDI standards (related to action 3.4).	|Completed in 2022.|
|5.3	|Identify institutions that can and will serve as data stewards.	|Future effort|
|5.4	|Engage other data creators and stewards to identify one or more additional participants.	|Future effort.|
|5.5	|Engage tool and service providers to build partnerships using the available data service(s) (related to Objective 8).	|Future effort.|


### Objective 6
Support (through policies and standards) the development of data discovery and access portals making use of Europa SDI managed data and associated Application Programming Interfaces (APIs).
 
#### Anticipated Outcomes
Supporting the development of data discovery and data access by the broadest possible Europa user community is a fundamental goal of the Europa SDI. Through policies and standards, we will provide a framework by which data can be organized, identified, searchable, and used while minimizing the need for post-processing or reprojection of data. We anticipate that this focus on standardization and data discovery will enable Europa data to be more easily discoverable in a format that is analysis ready, lead to a reduction in redundant data processing efforts across the Europa community and will potentially allow for current data processing resources to be used for science and engineering investigations.

#### Approach
Our approach to supporting data discovery and access is to develop policies and standards that are consistent with community leading practices. We will identify and implement practices that have demonstrated success in terrestrial and other communities and are relevant to the Europa community.  We will also engage Europa community user groups to educate potential users on the availability of this SDI and solicit feedback on the usability of this SDI. Finally, we will enable metrics on our websites and data portals to allow us to measure and evaluate how the community is interacting with our services and what data products and services are most impactful. These metrics will inform future efforts to modify our approaches and better support the Europa data community.

### Actions
|  | Action |	Status |
|--|--------|----------|
|6.1	|Research community leading practices for data policies, standards, and technologies that enable discovery.|	Ongoing|
|6.2	|Identify and implement practices that are applicable to the Europa community and practical to implement.| 	Ongoing|
|6.3	|Engage Europa community user groups to educate potential users on the availability of this SDI and seek community feedback.|	Ongoing|
|6.4	|Enable metrics to measure the use of the Geoportal, APIs, and the download of data.|	Future effort|


### Objective 7
Ensure the public release of all Europa SDI managed data products and APIs.

#### Anticipated Outcomes
Publicly releasing all data products and APIs managed under the Europa SDI ensures that these resources are available to the widest audience possible and seeks to democratize the availability of these data and infrastructure. We aim to publicly release all data and APIs in a manner that is discoverable, accessible, and usable (Laura et al., 2018), and that follows leading FAIR practices (Wilkinson et al., 2016). 

#### Approach
The Europa SDI working group will make data available under both FAIR data principles and the spatial standards defined by the Europa SDI working group, and to be compliant with NASA data release policies. Our approach to data product and API release follows the guidelines described in the NASA Scientific Information policy for the Science Mission Directorate (SPD-41). Specifically, data formats will be machine-readable to allow for automated processing and will include robust, standards-compliant metadata. All data, APIs, and software will be released under an open license, and will be indexed as part of the appropriate NASA catalog (i.e., either data or software). Our repository will also comply with standards for accessibility for all electronic and information technology to people with disabilities and with a principle of non-discriminatory data access so that all users will be treated equally.

### Actions
|  | Action |	Status |
|--|--------|----------|
|7.1	|Define the appropriate license for data and software release and document in the Europa SDI Governance Document.	|Completed in 2022.|
|7.2	|Establish standards compliant data and metadata formats for this SDI that fulfill SPD-41 requirements (related to objective 3) and document in the Europa SDI Governance Document.	|Completed in 2022.|
|7.3	|Determine industry standards for repository accessibility and develop actions to ensure these standards are met or exceeded.	|Ongoing|
|7.4	|Apply for  CoreTrustSeal Certification to become a trusted data repository.|	Future effort|


### Objective 8
Engage with tool developers to ensure support for data and standards included in the Europa SDI.

### Anticipated Outcomes
We seek to provide a catalog of data and derived data products in a well-documented and standardized format that will benefit many user communities. By engaging with tool and data portal developers, we will better understand the needs of this community and be positioned to collaborate with these groups. We seek to minimize the need to regenerate or reprocess existing data, thereby minimizing redundant efforts within the Europa community. This engagement will help us to provide data in a manner where tool and data portal developer could access the data within the SDI with minimal subsequent processing needed, rather than these providers regenerating or reprocessing data themselves.

### Approach
We will identify groups developing tools or data portals targeted for use by the Europa community and initiate communication with these groups. We will engage in informal collaborations with interested teams, seeking to develop mutually beneficial partnerships. Our collaboration focus will be educating others about the availability of data, supporting others in the use of Europa SDI-provided services, identifying points of friction for using the Europa SDI, and using this feedback to help develop future efforts.

### Actions
|  | Action |	Status |
|--|--------|----------|
| 8.1	|Identify groups developing tools or data portals targeted for use by the Europa community.	|Future effort|
| 8.2	|Initiate communication with the above defined groups.	|Future effort|
| 8.4	|Enable metrics to measure the use of the Geoportal, APIs, and the download of data. |	Future effort |
| 8.5	|Enable metrics to measure usage of the API. |	Future effort |

