---
title: Lunar Spatial Data Infrastructure Code of Conduct 
weight: 3
---

**DRAFT** 

Version 1.0; September 22, 2022 
 

Our goal is to create a safe and productive environment for everyone and to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community. This policy applies to the Lunar SDI community, our related interactions and meetings, interactions involving our community that occur outside of formal meetings, and when an individual is officially representing the Lunar SDI community in public spaces. Examples of representing our community include corresponding through e-mail, posting via a social media account, or acting as an appointed representative at an online or in-person event. Explicitly stating our expectations for our interactions improves inclusivity and accessibility for all, but especially for those with lower power due to not “fitting the norm” or those at a disadvantage due to less familiarity with the group and its typical dynamics. 
 
 
## 1.0 Our Standards 
 
The Lunar SDI Working Group strives to ensure that diverse voices are heard and considered. Thus, members are expected to listen to community members and to solicit relevant perspectives, concerns, and ideas from all people. Additionally, members are encouraged to contribute their own perspectives, concerns, and ideas into conversations. In such conversations, differences of opinion or contradictory needs might be expressed. In these cases, it is important to elevate the voices of those most impacted and those whose voices are often ignored. Listening to and thinking about feedback is also paramount. 
 
Examples of behavior that contributes to a positive environment for our community include: 
- Demonstrating empathy and kindness toward other people 
- Being respectful of differing opinions, viewpoints, and experiences 
- Giving and gracefully accepting constructive feedback 
- Accepting responsibility and apologizing to those affected by our mistakes, and learning from the experience 
- Focusing on what is best not just for us as individuals, but for the overall community 
 
Examples of unacceptable behavior include: 
- The use of sexualized language or imagery, and sexual attention or advances of any kind 
- Trolling, insulting or derogatory comments, and personal or political attacks 
- Public or private harassment 
- Jokes or dismissive comments about someone’s appearance or the appearance of their background during video conferences 
- Publishing others’ private information, such as a physical or email address, without their explicit permission 
- Any other conduct which could reasonably be considered inappropriate in a professional setting 
 
 
## 2.0 Reporting a Concern 
 
We encourage reporting of issues that cannot be handled by direct feedback as described in section 1 above because the scope is larger, those other measures have been tried and have not worked, it is an ongoing issue, or for any other reason. If you experience or witness any behavior that violates this Code of Conduct or if you (any member of the Lunar SDI community) are being made uncomfortable by another member of the Working Group, notice that someone else is being made uncomfortable, or have any other concerns, please contact the Chair, Co-Chair, or both in writing such as by email. 
  
If the person who violated the Code of Conduct is a Chair or Co-Chair, they will recuse themselves from handling your incident, and whichever Chair is not in violation will assign a Co-Chair pro tempore for dealing with the incident. The Co-Chair(s) will respond as promptly as they can. The Co-Chairs will take all good-faith reports of concern by community members seriously, and especially those of harassment. This includes harassment outside our spaces and harassment that took place at any point in time. All working group members will respect confidentiality requests for the purpose of protecting victims of abuse.  
 
 
## 3.0 Enforcement Guidelines 
 
The Lunar SDI Working Group is responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful. The Lunar SDI working group has the right and responsibility to remove, edit, or reject comments, and other contributions that are not aligned to this Code of Conduct, and will communicate reasons for moderation decisions when appropriate.  
 
The Lunar SDI Co-Chairs will follow these Enforcement Guidelines in determining the consequences for any action they deem in violation of this Code of Conduct (modeled from the Code of Conduct for Open Source Committees (https://www.contributor-covenant.org/): 
 
### 1. Correction 
Community Impact: Use of inappropriate language or other behavior deemed unprofessional or unwelcome in the community. 
Consequence: A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested. 
 
### 1. Warning 
Community Impact: A violation through a single incident or series of actions. 
Consequence: A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban. 
 
### 1. Temporary Ban 
Community Impact: A serious violation of community standards, including sustained inappropriate behavior. 
Consequence: A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban. 
 
### 1. Permanent Ban 
Community Impact: Demonstrating a pattern of violation of community standards, including sustained inappropriate behavior, harassment of an individual, or aggression toward or disparagement of classes of individuals. 
Consequence: A permanent ban from any sort of public interaction within the community. 
 
 
## 4.0 Acknowledgement 
 
Our Code of Conduct is adapted from several sources, including the [Professional Culture & Climate Subcommittee (PCCS) Division of Planetary Sciences of the American Astronomical Society](https://dps.aas.org/leadership/climate), the [Code of Conduct for Open Source Committees](https://www.contributor-covenant.org/), and Diniega et al., 2021. We gratefully acknowledge the thought and effort put into these documents that help us create a safe, inclusive, and productive environment for our community. 