---
title: Recurring Agenda Topics
weight: 5
---

**DRAFT**

Subject matter expertise within the Lunar SDI Working Group is organized primarily around the following topics, which are closely related to the Lunar SDI objectives (see Appendix 1 below and the Lunar SDI Strategy Document). However, additional topics may be added to the agenda at any time. Smaller focus groups may meet separately or asynchronously, as needed, and the results of such discussions are presented to the entire working group at regular meetings.

### Foundational And Framework Data
This topic focuses on the definition of standards within the Lunar SDI for interoperability and remote data access as well as the definition of metadata standards to support discoverability, the prioritization of higher-order data product creation, and the definition of a semantic vocabulary or ontology to support more complex data discovery activities. This working group coordinates and manages a listing of available data within the Lunar SDI and solicits for data to be added to the SDI, the publishing of an initial set of standards including standardized vertical and horizontal datums (i.e., the coordinate system), accepted map projections, standardized data and metadata formats to support interoperability, and standards to ensure interoperability of Lunar SDI search APIs. Three foundational data themes include geodetic coordinate systems, elevation, and orthoimagery. Framework data are defined as spatially enabled data products that serve a smaller user group and in conjunction with foundational data support additional science and engineering goals (Laura et al., 2017).


### Applications and Tools
A primary objective of this working group is to engage tool developers to ensure support for data and standards included in the Lunar SDI and to build partnerships with such groups. This working group provides a venue for the discussion and possible promotion of new capabilities that leverage the SDI and supports the identification and prioritization of technical capability that could be developed to support user interaction with the SDI.

### Portals
Coordination between data providers and data custodians to ensure availability of data products is critical to realizing the full potential of the Lunar SDI. This working group is concerned with SDI data storage in the cloud, data access, and ensuring FAIR principles are upheld. This working group coordinates the maintenance of, in conjunction with the Lunar community, a living inventory of foundational and framework data products including quantitative (e.g., positional accuracy, resolution, data producer) and qualitative (e.g., fitness-for-use) metadata. It also enables the development of data discovery and access portals making use of Lunar SDI managed data and associated APIs.

### Website and Communication
This working group strives to engage our users and to respond to the needs of the Lunar community. To that end, this working group will maintain the Lunar SDI public websites, data catalog, and mechanisms for communication with user groups, stakeholders, and the general public. This working group also coordinates engagement with the user community, funding agencies, and NASA Advisory Groups to ensure the efforts of this body maximally align with targeted user community needs. Community feedback is synthesized, and responsive action items are also developed.