---
title: "Strategy"
weight: 1
---

**DRAFT**

## Strategic Plan Overview and Executive Summary
This Lunar Spatial Data Infrastructure (SDI) Strategic Plan contains a high-level overview of the background, guiding principles, and philosophy of the Lunar SDI and describes the primary strategic objectives from 2022 to 2025. This document explains where and how resources could be best spent to develop and implement the Lunar SDI to support a coordinated and strategic effort to provide analysis ready data to Lunar scientists and engineers, mission teams, the planetary community, and the general public. This document also relates each of the strategic objectives listed below to actions that support accomplishing the objectives, and their anticipated outcomes, to ensure agreement on responsibilities, coherence, and timing for deliverables.

## Background
The Lunar Spatial Data Infrastructure working group is a voluntary cooperation between planetary community members to evaluate existing spatial data and data standards for the moon and assess spatial data storage, acquisition, discovery, and use needs of the Lunar community. The Lunar SDI is endorsed by the NASA-directed Mapping and Planetary Spatial Infrastructure Team (MAPSIT). A spatial data infrastructure (SDI) is the enabling collection of spatial data users, data interoperability agreements, policies and standards, data access mechanisms, and the spatial data themselves (Rajabifard et al., 2002). The overarching goal of the Lunar SDI is to allow individuals that are not spatial data experts to use spatial data to the greatest extent possible, with the lowest possible overhead (Laura et al., 2018). This working group will address complexities by defining policies and standards that will be applicable to this Lunar SDI regarding data interoperability, data contribution, and the long-term maintenance for the benefit of all user communities.
 
The policy decisions made for the Lunar SDI consider the diverse groups interested in accessing high-quality and processed data, and include the Lunar science and engineering communities, mission team needs for strategic planning and targeting observations, software application and tool developers, media relation activities, public engagement and education groups, and members of the general public. Understanding this diversity of long-term stakeholders, the Lunar SDI strategy will first focus on the needs of scientists, engineers, mission teams, and software and tool developers, and then build on this understanding to inform future work to serve the larger community of users and stakeholders. The Lunar SDI aims to improve the infrastructure for public access to and distribution of geospatial planetary data and help ensure that it is Findable, Accessible, Interoperable, and Reusable (FAIR; Wilkinson et al., 2016). It also aims to be a clearinghouse where data in a standardized format can be shared, duplication reduced, and community needs prioritized. In the context of the Lunar SDI, a data clearinghouse is a distributed system of data servers and services which have standardized metadata to facilitate data interoperability. The clearinghouse is a single access location that uses web standards to allow data discoverability. This working group will also help to ensure that valuable information is preserved for posterity in a way that is discoverable, has a high degree of usability, and can foster innovation and experimentation even while missions are actively collecting data (c.f. Planetary Data Ecosystem IRB Report, 2021).

An SDI is an aspect of a Planetary Data Ecosystem (PDE), is complementary to the Planetary Data System (PDS) and serves a distinct need in the planetary community. An SDI is not an archive and therefore does not in any way replace the critical need for the PDS to ensure that NASA-collected data are preserved in perpetuity. Instead, the Lunar SDI working group aims to provide additional functionality, access, and services for Lunar data that are built upon the important foundation the PDS provides (Laura et al., 2022), such as establishing policies, standards, and agreement between data providers that are focused on the needs of a specific community – in this case, those using spatial data collected of the moon. The Lunar SDI is a component of the PDE that is currently focusing on analysis ready data and metadata availability and services (Laura et al., 2022). 


## Europa PSDI Vision and Mission
**Vision:** The Lunar Spatial Data Infrastructure will facilitate access to spatial information in support of mission planning, scientific investigation, and public outreach efforts  
 
**Mission:** The Lunar Spatial Data Infrastructure mission is to promote cooperation and development of a Spatial Data Infrastructure that enables discovery, access, interoperability and sharing of Lunar spatial data, while pursuing best data management practices (modeled after the Arctic SDI). 

# Guiding Principals
The following guiding principles are used to assess proposed activities and priorities when formulating and communicating the strategy of the Lunar SDI:  
 
The Lunar Spatial Data Infrastructure: 
·	Is a voluntary cooperation between planetary community members 
·	Is focused principally on the relevant Europa data users, data providers, and stakeholders 
·	Reflects user and stakeholder needs to enable interoperability and reusability via standardization 
·	Remains focused on its strategic plan while developing infrastructure and services 
·	Leverages existing NASA SDI and Planetary Data Ecosystem (PDE) investments 