---
weight: 0
title: About Planetary SDIs
bibFile: content/bibliography.json
---
## What is a planetary SDI?
Collecting, managing, finding, and analyzing spatial data is hard. The knowledge required to discuss each of those tasks easily fills a book and the knowledge required to support others performing one or more of those tasks easily fills several more volumes. It is all to easy to not know how to find, use, or interpret publicly available spatial data.

Spatial data infrastructures were born from the terrestrial science (geography) community in the early 1980s with the birth of Geographic Information Systems (GIS). An explosion in digital data collection, mapping, and dissemination necessitated the development of infrastructures for organization much in the same way that, for example, the advent of the automobile heralded the development of the US interstate highway system. The infrastructures needed to store, organize, and make spatial data both discoverable and interoperable were called Spatial Data Infrastructures or SDIs.

Planetary SDIs are body (e.g., the Moon or Mars) specific infrastructures created by groups of planetary scientists, data scientists, geographers, and engineers that are interested in making spatial data easier for you to discover, download, and use. The members of the planetary SDI governing groups have expertise in the areas described above and have gotten together to codify the spatial concepts, like map projections, data formats, or body parameters, in order to ensure that data within a planetary SDI are discoverale, interoperable, well described, and ultimately usable. The groups also work to build out governance models, data sharing agreements, and the other policy related items necessary to support SDIs over the long term.

The ultimate goal of each governing group is to support the widest possible cross section of users by growing the scope of data, metadata, and usage documentation available within their given SDI. This support takes the form of outreach to data producers and providers, drafting of living standards documents to support interoperability, engagement with past, current, and future flight missions to ensure interoperability, and engagement with you, the user.The efforts of PSDIs distill down to seeking an environment where data are [FAIR](https://www.go-fair.org/fair-principles/)ly available for all users, whatever their expertise level.

For a significantly more scholarly discussion of planetary SDIs, see {{< cite "Laura:2017;Laura:2018ess">}}.

## Participants
Planetary SDIs are a community driven, cross institutional endeavour. By necessity, they are successful because they engage a wide cross-section of the community with different expertise and institutional affiliations. While this website is hosted by the USGS Astrogeology, none of this work would be possible without the active participation by community members from the following organizations.

<span style="margin:auto; display:table;">
<table>
<tr>
<td><img src="https://www.lpi.usra.edu/publications/newsletters/lpib/new/wp-content/uploads/2017/07/lpi_logo_fullname_002_black.png" width=200/></td>
<td><img src="https://www.nasa.gov/sites/default/files/thumbnails/image/edu_what_is_nasa_emblem.jpg" width=200/></td>
<td><img src="https://www.seti.org/sites/default/files/styles/original/public/2018-05/seti_logo_starfield_560px.jpg?itok=3Gci_Y5-" width=200/></td>
<td><img src="https://d9-wret.s3.us-west-2.amazonaws.com/assets/palladium/production/s3fs-public/styles/medium/public/thumbnails/image/usgs-placeholder_0.png?itok=AO6-JETt" width=200/></td>
</tr>
</table>
</span>