---
title: Governance Model
weight: 6
---

The Europa SDI working group is governed through two complementary strategies: 1) regular working group meetings; and 2) asynchronous collaborations using email and a shared work drive. 

## Meetings and Ratification of Minutes
The working group meets regularly (roughly monthly) using tools that enable participation by the community. We use a videoconferencing platform for our meetings.

Working group members are expected to regularly participate in working group activities. The chair sends a calendar invite to all working group members prior to the meeting. The chair also sets the meeting agenda and runs the meeting unless they have delegated that role to another member or subject matter expert. Meetings are generally not recorded.

Items are added to the meeting agenda that require discussion, decisions to be made, or are modifications of governance, contribution policy, membership, or release process. Updates on efforts toward meeting strategic plan goals are also discussed and reviewed in meetings. Any working group member can ask that something be added to the next meeting’s agenda by communicating to the chair. 

Prior to each meeting the chair will share the agenda with members of the working group. Working group members can also add any items they like to the agenda at the beginning of each meeting. The chair and the working group members cannot veto or remove items.

The working group may invite persons or representatives from related projects, stakeholders, or user communities to participate in any meeting in a non-voting capacity. 

The chair, or their delegate, is responsible for summarizing the discussion of each agenda item and sends the meeting notes to all working group members after the meeting.

## Decision Making Process
The working group follows a Consensus Seeking decision-making model.

When an agenda item under discussion has appeared to reach a consensus the chair, or any working group member, will state the decision that is perceived to have been reached and ask "Does anyone object?" as a final call for dissent from the consensus. 

If an agenda item cannot reach a consensus, a working group member can call for either a closing vote or a vote to table the issue to the next meeting. The call for a vote must be seconded by a majority of the working group or else the discussion will continue.  If a vote occurs, simple majority wins and the chair does not have tie breaking capacity (I.e., the chair’s vote does not hold more weight than any other member). In the event of a tie, discussion will continue until there is a majority vote or consensus. 
Note that changes to the working group membership require consensus. If there are any objections to adding or removing individual members, an effort must be made to resolve those objections. If consensus cannot be reached, then the discussed change to membership is not implemented.

## Asynchronous Communication and Collaboration
In addition to monthly meetings, the Europa SDI working group maintains a public repository of working documents, meeting notes, and presentations. This folder is a mechanism for asynchronous collaboration between members and allows for collaboration on tasks pertaining to the management of this SDI (e.g., editing documents, developing standards, supporting data ingestion). All group members have access to this internal use folder.  Email is also commonly used to communicate with the working group between meetings.