import os
import sys
sys.path.insert(0, os.path.abspath('..'))

import pytest

from plio.geofuncs import geofuncs

@pytest.fixture
def nevada():
    return [[-114.04392,40.68928],[-114.04558,40.4958],[-114.04619,40.30302],[-114.04644,40.09896],[-114.04658,39.99994],[-114.04727,39.75817],[-114.04757,39.61018],[-114.0473,39.45715],[-114.04779,39.36296],[-114.04841,39.23851],[-114.04885,39.08777],[-114.04833,38.90545],[-114.04916,38.75165],[-114.04992,38.55049],[-114.04997,38.20495],[-114.05013,37.95499],[-114.04939,37.77873],[-114.05198,37.70735],[-114.05264,37.47222],[-114.05187,37.13439],[-114.0506,37.0004],[-114.0506,36.99997],[-114.05014,36.817],[-114.04736,36.60322],[-114.04338,36.37619],[-114.04404,36.21464],[-114.1139,36.09833],[-114.22646,36.01461],[-114.32346,36.10119],[-114.51122,36.15058],[-114.6729,36.11546],[-114.73513,36.05493],[-114.74365,35.98542],[-114.70883,35.9167],[-114.67489,35.86436],[-114.70415,35.81412],[-114.69704,35.73579],[-114.68702,35.66942],[-114.65449,35.60517],[-114.66076,35.5417],[-114.6768,35.49125],[-114.61121,35.37012],[-114.58031,35.21811],[-114.57354,35.14231],[-114.63064,35.11791],[-114.60899,35.07971],[-114.63423,35.00332],[-114.63349,35.00186],[-114.63361,35.00195],[-114.82052,35.15341],[-115.11622,35.38796],[-115.36992,35.59033],[-115.65233,35.81231],[-115.89512,36.0018],[-116.08072,36.14577],[-116.37528,36.37205],[-116.87227,36.75057],[-117.31883,37.08441],[-117.79563,37.43715],[-118.04392,37.6185],[-118.22972,37.75309],[-118.51722,37.96065],[-119.00097,38.30368],[-119.43506,38.60904],[-119.76041,38.83427],[-119.9748,38.98156],[-120.00608,39.37557],[-120.0015,39.57782],[-120.00049,39.79567],[-119.99733,40.08934],[-119.99567,40.39719],[-119.99926,40.86934],[-120.00002,41.26742],[-119.99919,41.97905],[-119.99917,41.99454],[-119.99917,41.99484],[-119.90622,41.9972],[-119.80128,41.99746],[-119.70479,41.99621],[-119.61469,41.99594],[-119.48157,41.99572],[-119.36302,41.99428],[-119.25103,41.99384],[-119.0022,41.99375],[-118.7824,41.99259],[-118.54194,41.99478],[-118.42657,41.99586],[-118.3477,41.99629],[-118.19842,41.99699],[-118.09918,41.9975],[-118.06386,41.99767],[-117.99278,41.99804],[-117.90359,41.99817],[-117.79003,41.99842],[-117.71943,41.99819],[-117.62441,41.99836],[-117.51839,41.99915],[-117.46483,41.9994],[-117.33055,41.9996],[-117.18204,42.00038],[-117.02916,42.00018],[-117.02622,42.00025],[-117.02234,41.99989],[-116.861,41.99876],[-116.70972,41.99812],[-116.55307,41.99766],[-116.48554,41.99686],[-116.37594,41.99632],[-116.20623,41.99768],[-116.12593,41.99765],[-116.01199,41.99804],[-115.98839,41.99855],[-115.84911,41.99677],[-115.69522,41.99701],[-115.52677,41.99676],[-115.3968,41.99648],[-115.31388,41.9961],[-115.25015,41.99615],[-115.12254,41.99607],[-114.91817,41.99977],[-114.76097,41.99991],[-114.6492,41.9962],[-114.61271,41.99503],[-114.49854,41.9946],[-114.39727,41.99501],[-114.30408,41.99437],[-114.18492,41.99407],[-114.04537,41.99372],[-114.04172,41.99372],[-114.0398,41.89425],[-114.04055,41.59062],[-114.04061,41.36],[-114.04195,41.05548],[-114.04375,40.76026],[-114.04391,40.68985]]

def test_find_four_corners(nevada):
    corners = geofuncs.find_four_corners(nevada)
    assert corners[0] == [-119.99917, 41.99484]
    assert corners[3] == [-114.63349, 35.00186]
    assert len(corners) == 4

def test_find_corners(nevada):
    corners = geofuncs.find_corners(nevada)
    assert len(corners) == 8

    corners = geofuncs.find_corners(nevada, threshold=100)
    assert len(corners) == 5
