PDS_VERSION_ID                       = "PDS3"
/*** FILE FORMAT ***/
RECORD_TYPE                          = "UNDEFINED"
FILE_NAME                            = "SP_2C_02_02358_S138_E3586.spc"
PRODUCT_ID                           = "SP_2C_02_02358_S138_E3586"
DATA_FORMAT                          = "PDS"

/*** POINTERS TO START BYTE OFFSET OF OBJECTS IN FILE ***/
^ANCILLARY_AND_SUPPLEMENT_DATA       = 24737 <BYTES>
^SP_SPECTRUM_WAV                     = 31045 <BYTES>
^SP_SPECTRUM_RAW                     = 31637 <BYTES>
^SP_SPECTRUM_REF2                    = 54133 <BYTES>
^SP_SPECTRUM_RAD                     = 76629 <BYTES>
^SP_SPECTRUM_REF1                    = 99125 <BYTES>
^SP_SPECTRUM_QA                      = 121621 <BYTES>
^L2D_RESULT_ARRAY                    = 144117 <BYTES>

/*** GENERAL DATA DESCRIPTION PARAMETERS ***/
SOFTWARE_NAME                        = "RGC_SP"
SOFTWARE_VERSION                     = "2.10.3"
PROCESS_VERSION_ID                   = "L2C"
PRODUCT_CREATION_TIME                = 2012-03-28T18:21:14Z
PROGRAM_START_TIME                   = 2012-03-28T18:15:41Z
PRODUCER_ID                          = "LISM"
PRODUCT_SET_ID                       = "SP_Level2C"
PRODUCT_VERSION_ID                   = "02"
REGISTERED_PRODUCT                   = "Y"
LEVEL2B1_FILE_NAME                   = "SP_2B1_02_02358_1AN0E35873N.spc"
SOURCE_FILE_NAME                     = "SP_2B2_02_02358_S138_E3586.spc"
SPICE_METAKERNEL_FILE_NAME           = "RGC_INF_TCv401IK_MIv200IK_SPv105IK_RISE100i_05_LongCK_D_V02_de421_110706.mk"

/*** SCENE RELATED PARAMETERS ***/
MISSION_NAME                         = "SELENE"
SPACECRAFT_NAME                      = "SELENE-M"
DATA_SET_ID                          = "SELENE_Moon_SP_Level2C"
INSTRUMENT_NAME                      = "Spectral Profiler"
INSTRUMENT_ID                        = "SP"
MISSION_PHASE_NAME                   = "Nominal"
REVOLUTION_NUMBER                    = 2358
STRIP_SEQUENCE_NUMBER                = 2
SCENE_SEQUENCE_NUMBER                = 87
REV_STRIP_SCENE                      = "N/A"
TARGET_NAME                          = "MOON"
OBSERVATION_MODE_ID                  = "OBS-NORMAL"
SENSOR_DESCRIPTION                   = "SP is a nadir-looking spectrometer which has a reflective telescope, two plane gratings, and three 128-element detectors covering 296 bands in 500 - 2600 nm. The first detector is Si PIN photodiode, and the rest are InGaAs."
SENSOR_DESCRIPTION2                  = "SP SENSOR DESCRIPTION2"
EXPOSURE_MODE_ID                     = "SHORT"
SHORT_EXPOSURE_DURATION              = 26.000 <msec>
LONG_EXPOSURE_DURATION               = 77.000 <msec>
CALIBRATION_MODE_ID                  = "NONE"
SPACECRAFT_CLOCK_START_COUNT         = 892633171.9406 <sec>
SPACECRAFT_CLOCK_STOP_COUNT          = 892633185.4085 <sec>
START_TIME                           = 2008-04-19T09:39:37.436807Z
STOP_TIME                            = 2008-04-19T09:39:50.904738Z
UPPER_LEFT_LATITUDE                  = -13.488591 <deg>
UPPER_LEFT_LONGITUDE                 = 358.607848 <deg>
UPPER_RIGHT_LATITUDE                 = -13.488591 <deg>
UPPER_RIGHT_LONGITUDE                = 358.607848 <deg>
LOWER_LEFT_LATITUDE                  = -14.184324 <deg>
LOWER_LEFT_LONGITUDE                 = 358.601529 <deg>
LOWER_RIGHT_LATITUDE                 = -14.184324 <deg>
LOWER_RIGHT_LONGITUDE                = 358.601529 <deg>
LOCATION_FLAG                        = "D"
ROLL_CANT                            = "NO"
MOON_SUN_DISTANCE                    = 150664765 <km>
VIS_FOCAL_PLANE_TEMPERATURE          =  21.06 <degC>
N1_FOCAL_PLANE_TEMPERATURE           =  18.33 <degC>
N2_FOCAL_PLANE_TEMPERATURE           = 243.00 <K>
SATELLITE_MOVING_DIRECTION           = "+1"
A_AXIS_RADIUS                        = 1737.400 <km>
B_AXIS_RADIUS                        = 1737.400 <km>
C_AXIS_RADIUS                        = 1737.400 <km>
SPACECRAFT_ALTITUDE                  = 88.753 <km>
SPACECRAFT_GROUND_SPEED              = 1.565 <km/sec>

/*** CAMERA RELATED PARAMETERS ***/
VIS_BAND_NUMBER                      = 84
VIS_SPECTRAL_COVERAGE                = (482.6, 980.6) <nm>
VIS_BAND_WIDTH                       = 6.0 <nm>
N1_BAND_NUMBER                       = 100
N1_SPECTRAL_COVERAGE                 = (894.4, 1688.9) <nm>
N1_BAND_WIDTH                        = 8.0 <nm>
N2_BAND_NUMBER                       = 112
N2_SPECTRAL_COVERAGE                 = (1694.9, 2583.1) <nm>
N2_BAND_WIDTH                        = 8.0 <nm>
PROCESS_PARAMETER_FILE_NAME          = "SP_higher_level_proc_param.txt"
DAYTIME_EQUATOR_CROSSING_LON         = "N/A"
IMAGER                               = "MV2"
TM_DATA_SET_NAME                     = "MVA2A0_02NS02358_002_0087.sl2"
TM_CORRECTED_START_TIME              = 2008-04-19T09:39:34.499109Z
TM_CORRECTED_STOP_TIME               = 2008-04-19T09:39:48.526060Z
TM_CORRECTED_SAMPLING_INTERVAL       = 12.999954 <msec>
TM_LINES                             = 1080
TM_LINE_SAMPLES                      = 962
TM_FIRST_PIXEL_NUMBER                = 1
TM_LAST_PIXEL_NUMBER                 = 962
TM_UPPER_LEFT_LATITUDE               = -13.492355 <deg>
TM_UPPER_LEFT_LONGITUDE              = 358.318568 <deg>
TM_UPPER_RIGHT_LATITUDE              = -13.495974 <deg>
TM_UPPER_RIGHT_LONGITUDE             = 358.894891 <deg>
TM_LOWER_LEFT_LATITUDE               = -14.216854 <deg>
TM_LOWER_LEFT_LONGITUDE              = 358.311091 <deg>
TM_LOWER_RIGHT_LATITUDE              = -14.220493 <deg>
TM_LOWER_RIGHT_LONGITUDE             = 358.889224 <deg>
TM_SATURATED_PIXEL_PERCENTAGE        = 0
TM_DEAD_PIXEL_PERCENTAGE             = 0
TM_SHADOWED_AREA_PIXEL_PERCENTAGE    = 0
HIGH_SP_POINT_NUM                    = 0
NORMAL_SP_POINT_NUM                  = 38
UPPER_MARGIN_POINT_NUM               = "N/A"
LOWER_MARGIN_POINT_NUM               = "N/A"
CAL_LAMP_INFO                        = "N/A"
MATCHING_ACCURACY_INFO               = "1001"

/*** DESCRIPTION OF OBJECTS CONTAINED IN THE FILE ***/
OBJECT                               = ANCILLARY_AND_SUPPLEMENT_DATA
    INTERCHANGE_FORMAT               = "BINARY"
    ROWS                             = 38
    COLUMNS                          = 43
    ROW_BYTES                        = 166

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_CLOCK_COUNT"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "sec"
        START_BYTE                   = 1
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "VIS_FOCAL_PLANE_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 9
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "NIR1_FOCAL_PLANE_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 13
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "NIR2_FOCAL_PLANE_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "K"
        START_BYTE                   = 17
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_1"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 21
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_2"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 25
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_3"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 29
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_4"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 33
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_RADIANCE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 37
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_VOLTAGE1"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 41
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_VOLTAGE2"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 45
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_TEMPERATURE1"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 49
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_TEMPERATURE2"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 53
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_ALTITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "km"
        START_BYTE                   = 57
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_GROUND_SPEED"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "km/sec"
        START_BYTE                   = 61
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUB_SPACECRAFT_LATITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 65
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUB_SPACECRAFT_LONGITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 73
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CENTER_LATITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 81
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CENTER_LONGITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 89
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "EMISSION_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 97
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_AZIMUTH"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 101
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "INCIDENCE_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 105
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SOLAR_AZIMUTH_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 109
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "PHASE_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 113
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 117
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_PELTIER_HOT_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 121
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_N2_RADIATOR_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 125
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_CAL_VIS_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 129
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_CAL_NIR_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 133
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "DPU_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 137
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_POWER_P5V"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 141
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_POWER_M15V"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 145
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_POWER_P15V"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 149
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CALIBRATION"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 153
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_PELTIER"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 154
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "TC_MI_STATUS"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 155
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CLOCK_COUNT_ERR_FLAG"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 156
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPATIAL_RESOLUTION_FLAG"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 157
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "GEOMETRIC_INFO_RECAL_FLAG"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 158
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUPPORT_IMAGE_LINE_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 159
        BYTES                        = 2
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUPPORT_IMAGE_COLUMN_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 161
        BYTES                        = 2
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "THUMBNAIL_LINE_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 163
        BYTES                        = 2
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "THUMBNAIL_COLUMN_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 165
        BYTES                        = 2
    END_OBJECT                       = COLUMN

END_OBJECT                           = ANCILLARY_AND_SUPPLEMENT_DATA

OBJECT                               = SP_SPECTRUM_WAV
    LINES                            = 1
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "WAVELENGTH"
    UNIT                             = "nm"
    SCALING_FACTOR                   = 0.100000
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_WAV

OBJECT                               = SP_SPECTRUM_RAW
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "RAW_DN"
    UNIT                             = "ND"
    SCALING_FACTOR                   = "N/A"
    OFFSET                           = "N/A"
END_OBJECT                           = SP_SPECTRUM_RAW

OBJECT                               = SP_SPECTRUM_REF2
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "REFLECTANCE"
    UNIT                             = "ND"
    SCALING_FACTOR                   = 0.000100
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_REF2

OBJECT                               = SP_SPECTRUM_RAD
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "RADIANCE"
    UNIT                             = "W/m**2/micron/sr"
    SCALING_FACTOR                   = 0.010000
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_RAD

OBJECT                               = SP_SPECTRUM_REF1
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "REFLECTANCE"
    UNIT                             = "ND"
    SCALING_FACTOR                   = 0.000100
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_REF1

OBJECT                               = SP_SPECTRUM_QA
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "QUALITY"
    UNIT                             = "N/A"
    SCALING_FACTOR                   = 1.000000
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_QA

OBJECT                               = L2D_RESULT_ARRAY
    LINES                            = 0
    LINE_SAMPLES                     = 0
    SAMPLE_TYPE                      = "N/A"
    SAMPLE_BITS                      = 0
    IMAGE_VALUE_TYPE                 = "N/A"
    UNIT                             = "N/A"
    SCALING_FACTOR                   = "N/A"
    OFFSET                           = "N/A"
END_OBJECT                           = L2D_RESULT_ARRAY
END
Aʚ@)eAzACs  ARAQAA@I@I@IA%A%B?A+^W@viߑ*(@vi*r?CAjA?BB8lA>Ax?|@-}AxAsMAdS@&m:Am
  AC  
 Aʚ@*&AzACs  ARAQAA@I@I@IA%A%B?A+{@vi cK+Ǖط@vi(?;CAiAY0BB
AX3Ax?|@-}AxAsMAdS@&m:Am
  AC 7  Aʚ@*UAzACs  ARAQAA@I@I@IA%A%B?A+?@via08+
fS$@vi7?pBCAi:ArBAAqAx?|@-}AxAsMAdS@&m:Am
  AC S ( Aʚ@*,AzACs  ARAQAA@I@I@IA%A%B?A+%)hG@vi+@viʌ?U&CAp$ABAbAAx?|@-}AxAsMAdS@&m:Am
  AC p 5 Aʚ@*ÄAzACs  ARAQAA@I@I@IA%A%B?A+/T {t@vi+ \@vi?:CAwATBAA\Ax?|@-}AxAsMAdS@&m:Am
  AC  B Aʚ@*[AzACs  ARAQAA@I@I@IA%A%B?A+8"S@vi#zG +*GNn@vi@?CA~ ABAA&Ax?|@-}AxAsMAdS@&m:Am
  AC  P Aʚ@+AzACs  ARAQAA@I@I@IA%A%B?A+B!$X@vid3,+3d@vic ?CAABAdAAx?|@-}AxAsMAdS@&m:Am
  AC  ] Aʚ@+>AzACs  ARAQAA@I@I@IA%A%B?A+L,qO_@vix+=?x@vib{z?CAABAAtAAx?|@-}AxAsMAdS@&m:Am
  AC  j Aʚ@+m!{AzACs  ARAQAA@I@I@IA%A%B?A+U֔@vi嗠|+G)z͠@vi ?CAkA
mBASAAx?|@-}AxAsMAdS@&m:Am
  AC  x Aʚ@+AzACs  ARAQAA@I@I@IA%A%B?A+_gQۮ@vi&B5+PO˼@vi@\{?CAA'?B@<A&7Ax?|@-}AxAsMAdS@&m:Am
  AC  Aʚ@+PvAzA\)Cs  ARAQAA@I@I@IA%A%B?A+iu@vif+Zk$nt@vi\?!CAAAB@0A?Ax?|@-}AxAsMAdS@&m:Am
  AC4  Aʚ@+AzACs  ARAQAA@I@I@IA%A%B?A+r2As@viu+d9@viС,5?kACAAZB@.AYAx?|@-}AxAsMAdS@&m:Am
  ACP  Aʚ@,'qAzACs  ARAQAA@I@I@IA%A%B?A+|?+1$@vi$$+mv8@vij?K_CAMAtB@7AseAx?|@-}AxAsMAdS@&m:Am
  ACl  Aʚ@,VAzACs  ARAQAA@I@I@IA%A%B?A+.N@vi(+wM9@vibH6?+CA%AB@oIA+Ax?|@-}AxAsMAdS@&m:Am
  AC  Aʚ@,mAzACs  ARAQAA@I@I@IA%A%B?A+z0ZS@viiL5+j@viO?xCA
AB@L^AAx?|@-}AxAsMAdS@&m:Am
  AC  Aʚ@,EAzACs  ARAQAA@I@I@IA%A%B?A+|@viG}+t@viv^?CAAB@)}AAx?|@-}AxAsMAdS@&m:Am
  AC  Aʚ@,hAzA\)Cs  ARAQAA@I@I@IA%A%B?A+am@vi`$+2@viaX?VCAAuB@AAx?|@-}AxAsMAdS@&m:Am
  AC  Aʚ@-tAzACs  ARAQAA@I@I@IA%A%B?A+Rѩ@vi*+~^W@vi?CAAhB?AAx?|@-}AxAsMAdS@&m:Am
  AC  Aʚ@-?cAzACs  ARAQAA@I@I@IA%A%B?A+A.K@vikacA+v0$")@vi=q?tOCAA`B?A
Ax?|@-}AxAsMAdS@&m:Am
  AC  Aʚ@-mAzACs  ARAQAA@I@I@IA%A%B?A+w@vi
5+@vi`J;?RCAeA*[B?dA)Ax?|@-}AxAsMAdS@&m:Am
  AC0
 Aʚ@-;^AzACs  ARAQAA@I@I@IA%A%B?A++ X=6@viM+/@vi?3tCBADZB?{AC=Ax?|@-}AxAsMAdS@&m:Am
  ACL Aʚ@-AzACs  ARAQAA@I@I@IA%A%B?A+ȏC@vi,?+Y@vi	$%?CBA^]B?YA]_Ax?|@-}AxAsMAdS@&m:Am
  ACh$ Aʚ@-jZAzA\)Cs  ARAQAA@I@I@IA%A%B$?A+ejEi@vim%+
2@vi]I?CB#AxeB?6AwAx?|@-}AxAsMAdS@&m:Am
  AC2 Aʚ@.(AzA\)Cs  ARAQAA@I@I@IA%A%B*?A+n@vi@+ל3:
@vijW?]CB/AqB?AAx?|@-}AxAsMAdS@&m:Am
  AC? Aʚ@.VUAzA\)Cs  ARAQAA@I@I@IA%A%B1?A+P@vi+=OV"@vi?CB<#AB>yAAx?|@-}AxAsMAdS@&m:Am
  ACL Aʚ@.0AzACs  ARAQAA@I@I@IA%A%B8?A+>Mi+@vi.C}+E@viYa5?CBGAƔB>A'Ax?|@-}AxAsMAdS@&m:Am
  ACY Aʚ@.PAzACs  ARAQA=qA@I@I@IA%A%B>?A,ۼk@vin7&+~$Э@vi=Ui?CBSyAB>AtAx?|@-}AxAsMAdS@&m:Am
  ACg Aʚ@._AzACs  ARAQA=qA@I@I@IA%A%BF?A,y+@vi[+WZ@vi?g CB_*AB>;AAx?|@-}AxAsMAdS@&m:Am
  ACt Aʚ@/LAzA\)Cs  ARAQAA@I@I@IA%A%BM?A,@vi4f{,gg@viT¸?LCBjAB>gAAx?|@-}AxAsMAdS@&m:Am
  AC, Aʚ@/?AzA\)Cs  ARAQA=qA@I@I@IA%A%BT?A,	$@vi/zZ8,`@vi'?2CBvA/B>EA/pAx?|@-}AxAsMAdS@&m:Am
  ACH Aʚ@/n&GAzACs  ARAQA=qA@I@I@IA%A%B\?A,)Qx@vio+v,N@vi?fCB~AI6B>#^AIAx?|@-}AxAsMAdS@&m:Am
  ACd Aʚ@/AzA\)Cs  ARAQAA@I@I@IA%A%Bd?A,2z@vi~,$H[g@vi>D9?:CB"AceB>/AcAx?|@-}AxAsMAdS@&m:Am
  AC Aʚ@/UBAzA\)Cs  ARAQAA@I@I@IA%A%Bl?A,<V@vi-qs,.A{P%@vi?CB]A}B=	A~Ax?|@-}AxAsMAdS@&m:Am
  AC Aʚ@/AzA\)Cs  ARAQAA@I@I@IA%A%Bt?A,F)@vi0^,7UE@vi?CBAB=A:Ax?|@-}AxAsMAdS@&m:Am
  AC Aʚ@0(=AzA\)Cs  ARAQAA@I@I@IA%A%B}?A,O3fg@vip$,A.@vi?CBAB=AqAx?|@-}AxAsMAdS@&m:Am
  AC Aʚ@0WAzA\)Cs  ARAQAA@I@I@IA%A%B?A,Yd{@viA,K!_~Z@vi_c?CB^ALB=xA̫Ax?|@-}AxAsMAdS@&m:Am
  AC Aʚ@09AzA\)Cs  ARAQAA@I@I@IA%A%B?A~,ct@vi49,T!@vi.?FCBAB=VAAx?|@-}AxAsMAdS@&m:Am
  AC Aʚ@0JAzA\)Cs  ARAQA=qA@I@I@IA%A%B?A~,l~R@vi0,^_Ǫ@vi?|CB}A B=4A.Ax?|@-}AxAsMAdS@&m:Am
  AC( @4o#^O={.j [J;w,hWG 8 t  !(!b!!""S""##C###$2$n$$%"%^%%&&N&&''>'{""#"#s#$$b$%%R%%&E&&'4''(%(s())e)**T**+E++,6,,-%-v-..f.//W//0G0016112*2x233g344V445F5566667&7v788f899V99:F::;5;;<%<u<==e=>>U>>?I??@:@@A+AxB}BCChCDDYDDEHEEF8FFG,G|GHHiHI
IUIIJGJJK5KKL LxLMMeMN	NZNNOEOOP5PPQ"QwQRRdRSSQSST@TTU2UUVVrVWW`WWXOXXY?YYZ1Z|Z[[n[\
\^\\]M]]^:^^_+_{_``g`a	a^aabIbbc8ccd(dxdeFe!###'{*X)(/)t++++*))*+,+d+,.:/+/0=11222222]10W/..A-7,*('^%%$"#G"1 msVX5KwudUip$g;Wq[z?*V"% %W#&%)*&*'+*/++,T-.S.0/#527n497<{8D;q8<;<>> C{?D$CQF2EHGIYHJ#J:IeKRGKNGMEHKIaL(I0HTHHJJIJ>HG!J&C;DrAWA<>4:B:H44	-|+#e7(a*u!X+"-8!,-!+`&14%0x3)1*&{(3.*!.5$I%3
**)+T0&?4)*-{-I, 1+!-*&$-.
-^#&'!+q"A')&>"
-7$@&,)
 ,$!&*+.,")+&o(!$'(B!)}!)*9% !X$l#"C$-,#l*!-,,C=2"$$%$p(J+3*W(*J+,,,+**+v,,,G,u-//0)01922333333l21U0t//%.
,+V)( &%$#" 0q+r$nz~1)~$Jx~xaVZ#'=&!^%$6'K&u)'3*,H*,`,-.>//V1p0	638h5:8=w9F<R9=<@??D@E7DbGJFIHJuIKCKGJqL`HLNHNLILJhM0J&IEIIKJJbJIuGJCE AB
=>>::54E-, #f(j*~!f, "-8#!,-!+s&1>%03)1=&~(9.*#.5"$I%3*%)+[0&B4	)*--O, =+!6*&$-. -[#&'!+w"&E')&C"-9$C&,),'!&*+.1")(&t(*$'(I!)z!	)*>% !G$x#"J$,,#n*!-,71= #N"#1&)('(*k++=+*!)2);)*+f**+-~.n./t0F01221110/..!-,+*	(t&%$#"! #-fWq,\aQMVdS<_lSbqSw"% %)#&%(&`)+X)+i+, -'-.+0A.42u7459b7R<7:8K<\:>o=B?*CBEDH7GHHIIHJG0JFlLHYK;HKHGHHFII`HIH	FoIBC@@<==994R3-+#$(T*j!O+"-8!,-!+a&1/%0s3)1(&o(0.u*.5$<%3
*#)u+O0&;4(*-u-L, 8+!5*&$-.
-Y#&'!+q"!B')&<"-.$J&{,)
,!&*+.4")/&o($'(H!)r!	)*7% !U$z#"A$6,#r*!-,."0 #A"#&)('n(*P++(**)")')*+L**+-g.W./Z0)01111110/..
-,+p)(e&%$#"! 'hVo'[^QDXaV>twVpH"uTy"% %.#&%(&`)+O)+d+,-2-.+05.42p649S75<7:8<<E:>T=~B>CxBEmDHFHGIaIlHJG
JFGLH0KHKPH`GGH II%HIhGFQIjB[C@@<=994>3-+#3(N*g!Q+"-8!,-|!+]&1&%0i3
)1&t(,.r*
.5$B%3
*%)w+M0&34(*-r-L, 4+!5*&$-.-W#&'!+l"D')&;"-)$P&~,),&!&*+.8")%&s( $'(G!)w!)*@% !]$q#"C$.,#s*!-,[\i!5###n'))')*+u++]*v))*G+U+++?,V-./M/01n2F222g2w21K0/H..-	+*v('C%%$#F"3 p{`gAZr`jr$cIl~aP@U""%!%a#&&)7&*D+*B++,e-.k.0/R5@37497<8;9 =;o?9>ZC?DrCFEI=HIIJJIKHUKGMILtILIHIbIK]JJFJItGJCEAB9=_>::5G4{-,=#X(k*!|,"-81!--!+&1M%034*1K&(T.*..,55$^%3
*7)+k0&W4)+--], G,!E*&$-#.4-m#&&'!+}"+K')&G"-5$P&,),7!&*+.>").&z($$'(O!){!) 	*G% !Y$~#"E$2,#o*!-, #""&)M('9(|****)(()*+*a*+- ..//01b11111%0b/3.f--/,,+ )(&%,$T#i"!(?}7;7/ESJ,`\0vQSTb"%y %#s&%(&D)+Q)+X+~,
-4-.*0*.42t6419O7B<
7:81<6:>^=B>CyBE{DHFHGIYIfHJFJFBLzH"K HKaHGGsGHIIHI]GF$IDBHC@j@;=\9p943U,+u#(<*R!9+"-7!,-`!+>&1%0Qm2)1&[(.Y)-4$*%3
*)k+00&3|(*-]-1, &+!*&$|,y-
,J#x&'!+a".'p)&0!-!$6&r,(,!&{**.#!)&e($'(>!
)r!)*5$ !O$o#"A$1,#i*!-,USa!0###g'))')*+p++U*m))*9+H++	+8,K-./G/01f2C22{2f2i21J0/;..,+*`(':%$$#," XaEK.ArveYg	l a;^gXp3T	"% %K#&%) &*#+*>++,d-.O.0/35%27x497<8Z;p8<;T?>#Cy?D3CiFDEHGI`HJ<J:IyKfGKhGMOI
KIqLLI<HfHHJJ	IJ?HG J5C*D_AOA<>A:?:;43-~+#V?(]*q!b+"-8!,-!+f&1:%0x3)1/&(<.}*!.5$S%3
**)+[0&K4)*-}-V, D+!-*&$-."-[#&('!+s""G'~)&B"
-%$L&,),&!&*+.9"))&p(%$'(F!)y!)*?% !_$o#"@$1,#g*!-,dd2w!E##?#'1*
)7')6*+++*))*h+z++:+k,~./
/|001222222X10U/..P-B,1*)'&%5$L#u"] ]&j! pvv-"l'L}v_GR;#%!%#&&))V&*]+*j+,,-..0/g5a3'74:8<8;9
=%;?A>iC@DsCFEI HIHJJvIKH!KGgMI8L'ILIqHIIAJJEIJIG[JtCpDAA<>p::44*-,#yK(q*z!p+"-8&!,-!+~&1P%03!*1=&(L.*3.#5#$_%36*:)+e0&^4)+--], M,	!?*&$-".;-e#&.'!+"&G')&M"-<$S&,),+!&*+.;").&w(*$'(K!)~!)  *K% !X$z#"L$0,#j*!-,Bf!##|#'*c)(;)+3+,+*)*	*+,;++,.q/c/0x1L22363(33210//0.-,*)\'&\%~$#" DG;}$/.q%L,uQ#RX&4!m%$@'n&)'F*,O*,r,-0.U/(/g1{06385:8=9r<9=<@9?fDAEDGFJMI6JJ0KKJLIbLHNJMtKMJIJTJL8KK8KJUHKDEBB>?;;l55 .j,#(*!,"-8C"--!+&1c%03<*1^&(e.*J.?56$p%39*A)+y0&f4))&+--h, ],!G*&$-'.D-j#&1'!+"5R')&S"-=$T&,),0!&*+.@")6&(+$'(Q!)!) *J%
 !T$#"G$),#i*!,,ZYh!5####r'!))')*+|++l*))*O+^++++R,i-./l/012k22222@10F/u..?-8,+*)'t&%6$J#t"\ e 0q%
ryu0(iDtt|fSV#'&!D%$'(&T)&*+*,!,V,-./
1/53s85=:v8m=)8<9r=;?>DC@DD&GFOIHJIIKK
JJL:HL4GN"ILJHMJ+IBIIKJJK?IHKD
EHBBg=?::5i4.,B#h(s*!,"-8<!--!+&1X%030*1Y&(c.*D.75*$s%3*H)+s0&_4")'+
--f, Y,!G*&$-*.4-m#&-'!+|"2O')&L"->$N&,),.!&*+.:")9&r(+$'(N!)!
) *R% !T$#"F$),#h*!-,Osw;d,"%
$$(+*)*,-q--X,c+b+f,(-D-,-7.W0112"33444444v32X1|00)/-,W*('|&%$#! oc"ep dS<RUH@f67MzHVB w #&"&%( 'Y*(%+-C+-|-.@/0I021^7k5I97<s:r?>;>);?>BA3FBGFIILK[MLsMMMPOKOJQLOMcP.M4LJLLNNMN<LJNFHDD?A\=;=17X6q/-$  (*!,F#.
F8{"C-Q-"+'#1&+03m*I1&(.*s.p5a$&4H*n)+0&4J)J+---, x,,!k*'$-9.3O-)#&C(	!+"DY')&]"$-O$c&,)$
,@!&*+.G"$)=&(4$'(X!!)!) *Z% !_$#"Q$6-#p*!-	,n!$*#$	'*)()+,P,t,8+I*Z*]+,1,+, -9./0P0123l33333:2p1.0]//.,+e)(&%$#"! (uBmW3'/@76] GUY .#&!&.$'&*''+>,+_,--.//1064976I;9>Z:0=A:>=5@@-EAFeEHGKKJKK,LLKMJ^MIOKNfKNKJKQKM=LL<LK6ILEFC}C>@5<<6P5.,$/(*!,+"-*8Y"!---!+'1v&03R*61x&(v.*^.M5O$%4*`)+0&s4A)9+--, h,%!f*&$-;.'H-}#&;(!+"9c')&["-M$V&,) ,<!&*+.D")4&(/$'(Z!)!) *S% !d$#"N$4,#o*!-,+!$[#$6(**(*+,,,x+**+U,n,,,,_-/00122233333321r0//].I--+)(R&%% $!#!. 1	EPua8/ 8D<<T
1*#YT* >#&!&<$'&*;'+_,+x--%-./02064996v;9>}:?=^:>=[A@DEAF{EHGKgJ:KK@LLLMJmMIOKNLNKJKvKM_LLLLK`ILEFCC>@M<9<)6v5.-$9(*!,+"-+8d"-3-!+'1s&03R*11u&(y.*].J5R$%4*^)+0&|4;)1+"--, e,#!_*&$-4.0H-{#&8(!+"8c')&T"-M$W&,)",;!&*+.C")3&~(1$'(W!)!) *P% !a$#"G$4,#j*!-
,!!$H#$''**(*+,{,,i+q*}*+A,\,,,O-e/0	0|112333333l21`0//F.2-+)(?&%$$"! !<
Hs\6'6@<-_#!AU 5#&z!&:$'&*5'+N,+j,-"-.//20649*6T;9>h:.=S:>=FA
@>EAFuEHGKJJ(KK;LLKMJZMIOKNvKNKJKaKMKLL9LKLILEFCC>@7<'<6e5.-	$-(*!,&"-*8h"-7-!+'1v&03P*11y&(w.*^.P5T$%4}*^)+0&u49)4+#--~, l,"!]*'$-:.1O-#&5(!+";]')&Y"-P$U&,),C!&*+.J"):&}(0$'([!#)!) *V%
 !_$#"O$8,#j*!-	,;TQ7W"I$$L$(+t*)8*,V--4-,+++,-e,,./01%123e4L444s4y43D2 1&0h/.-,*Y('8&N%P$p#H!q kA;u@HuzQ=,COB6\
%$0o+VK a#&!&r$('+*k'+-+-B-v.	/>00T2n1)7496<:%>:=;(?<=A@F4BG
F7I4HKJLKMcMmLNKNJKPL0O$LO{LyKLL7MMXLM}KJ;MKF"GBD
D>?L@<<65/-U$c(*!,=# -58m"(-=-"+'1&%03_*?1&(.*d.U5e$&
4	F*d)+0&z4D)A+.--, y,&!`*'$-:.6F-%#&B(!+"Id')&Z"-X$Z&,) ,;!&*+.F"!)=&{(7$'(Z!)!) *X% !f$#"H$5,#e*!-,^W3\"%G$%%)$,#+B)+?----,++,-.-^-.0t1w123w4C5355u5T5\44#21130/.\,*)L'&%$#! G&w^K]_UJ~NR1x1uV  J$ *'"H&%E(b'*(o,-,9-../003175:Q7y<:?;d>;?>BOAG
CHGGJIXLKMoLNDNCMOaKOfK'QRMPMPJMJLkLMNNMNKLJNFGDD?AC=%<7@6Y/-$ (*!,I#.I8";-N-"+' 1&403n*M1&(.*x.]5u$&4s*t)+0&4M)J+@--, y,2!i+'$-J.<N-0#&B(!+"F_')&^"-Q$V&,),:!&*+!.@")G&}(4$'(Y! )!) *U% !h$~#"N$B,#l*!-,z ##%%8%),+*T+-.S.s.:-<,6,>-.-.-./G02
23-4456655543d2|11*0.-5+v)(1'6&8%I$".! 	J/I,|]k mb9~K^CGC-V  n$M a'N"'%('+6(,.,.B.p/0J1*132_8x6B;83=;@n<0?E<@?WC0BhGDFHHKJ^MLNqMONOUNPtLPrL5RjNQ$NQ{N`MMN1OOGNOtMLOGHEE@B==860'.$ Y(*!,a#..j8"T-j.	"0+'71&J03*c1&(.*.|5$&'4(:*)+*1&4^)X+H--, ,<!z+'$-S.J^-4#&Q(!+"Hl')&_")-L$_&,),?!&*+&.D"!)N&{(<$'(X! )!) *V% !d$#"G$9,#i*!,,+ U#t&%%*-,,9*,3....-,,-{./.Z./123345n6^66666 5B33 2:10/N-+*('&%$f"m!Z $=wEdHgwsm[5g"jp\dWD! $| '"'J%((4+p),.K,../T01z13286;O8=;@<?<A"?CBHZDI<HK|JNJMNN:OONPMVPLRNQOQNMN[NPOOO1ON7LkO|H,IDEFABd>;>83740X.?% n(*!,q##..o8"_-{."0+';1&U03*q1&(.*.5$&/40b*)+71&4b)_+M--, ,>!+'$-[.OS-=#&I(!+"Mp')&g"1-O$k&,), ,A!&*+".H"()J&(>$'([!)!") *O% !g$#"K$:,#h*!-,ub"%%%f)d,t+*+-Q..1.- +,,-.[--/012=234555555F4o3241}0/.,+8)''&%#" &c7#nN`f^O(^lUXA2T  v$D a'G"'%('+6(,k-,.?.f/0F11k32B8I67:8
=`;x@C<?<x@?/BB?GCHGJJ9ML~NAMOO NKPMLP,KR/MPNhQ:N:MIMMONNO,MKNGHEjE@A==760.$ U(*!,\#".h8"O-d.
"&+'31&B03*`1&(.*.5w$&4' *)+%0&4Y)P+I--, ,8!x+
'$-W.LU-8#&C(!+"Hm')&_"+-O$g&,)),A!&+ +".K"!)I&(<$'(Z!)!) *P%
 !i$#"H$A-#p*!-	,[w!1$r'6&&+K.-,
-/c0?0U0/	--./0m//12345(6678(878765>4I3{210d.,*)`(W'D&I%#! ~
>3KazC nT$S VM!Z $ '#1'&<)l(+)-Q.-/>/s01Z2;24397w<<9q><A=t@=B"@DCIwEJ`ILLONpP5O}Q	QPWR:NRMT!ORPeS:PCOHOOQQPQO}MPIeJfGG!B&Co?0?981.% (*!,#H.>8"}-.*"G,'U1&d1+3*1'(/*.5$&74=b*)+=1&4h)f+Z--- ,D!+',$-a.Nf-A#&R(!+"Qt')&b"9-T$r&,).,P!&*#++.R"")I&(D$'(^!%)!#)  *U% !n$#"W$>-#m*!-, %  O!%4(
'',R/.-.01|11]0F/$/&01E101,2p4U5s6678999999I8X6554f3-10.#,:*)(c'b&#"!w Hn
/V8Vrs>*) V"!%!($('8*p)-*.0K/00123426a5M;9s>S;A ?D?B@<DlC'GFfLHM*LOORQhSaRT;T6SUnQUGQ.WdSBV'SVSRS
SSUTlSTmRPTLMnIJDFAAe;::20B&{!s)#+E"B,#.9"-.",b'2"&1n3*2'Q)/V*.5%&4**A,|1\&40)+.--; ,z!+M'W%-.y-g#&|(G"+"r')&"U-u$&,)K5,m!&+ 5+@.e"E)b&(Y%((q!:)!8) 4*b%) !r$#"d$A,#t*!-,UE|<"%$$(++)+,---u,y++,A-j---S.x0'1+12L3)345$545	432100Z/@.,z*)'&%$#! y-uzoYCVZTEsP\ Sr>-#U  X$' ;'5"v'%e('+(,H-,q..K.001<3Z28+5:7=;;C@;><=@c>BBGCHcGJIMnLGNMTNNNPLOKQMPN-PMMM}MOvNNZNMkKNGoHvE5EZ@rA==m76/-$ H(*!,T#.N8"H-[-"+'$1&=03w*P1&(.*.`5u$&4*q)+0&4X)N+=--, ,-!r+'	$-L.;P-+#&F(!+"Di')&Q"(-J$b&,)+,F!&*+.H")J&}(5$'(P!$)!) *G% !e$|#"Q$/,#g*!-,{!$3#$'*)()+,S,q,8+M*\*`+,0,+,$-;./0J0123a3333352g130R//.,+^)(&%$#"! (o;dT-"-=52_+!$Z/R J#&!&G$''*B'+c,+--<-./02/0649R6};9>:I=Y:>=QA@LEAFEHGKhJ0KKCLLKMJxMIOKN}LNKJKjKMYLLKLKUILEFCC>@5<"<$6t5.-$1(*!,,"- 8U"-0-!+' 1u&03N*+1j&(v.*[.G5T$%3*V)+0&r47)2+*--{, i,!\*&$-4.)H-x#&1(!+"1\')&D"-H$W&,),>!&*+.E")>&}(/$'(O!)|!) *E% !d$}#"U$1,#h*!-,k!$)#$'*)()+,D,[,.+@*H*N+, ,+,-0./0B012r3S333t33$2V10C//
-,+V)(&%$#"! &n	>dQ* 2:6Vw%R #hp&Y!&$i'u&)'\+,u++,,-]./V/10N6L485;9=9<:>(<@b?DA>EEGG.JIgK JrKKK.MIMHNJMK$NJJJJLoKK`KJoHKDEBB>?;;y55.h,#(*!,"-8I"-"-!+&1f&03G*%1[&(g.*O.75A$%3*V)+0&a46)$+#--u, a,!U*&$-2.#G-z#&'(!+".`')&J"-F$O&,),6!&*+.@")5&x(/$'(M!)!) *D% !_$#"N$*-#f*!-,*( #<"#&)('n(*Q++!**).)2)*+^**+-.{./0V112/2.22$11//.V-,+*L('#%$$#/"" _jM[<
Rvahr&cDv	k\R[#&+&	!4%$
'.&Q)~'
*, *,,V,-./1/53j8
5':h8e=8<
9a=s;?>D/@RDDFF1IHfJ(IlJJJ#LHLGMILJLII	IIK]JJKJIpGJCE
AB=U>::574i-,<#g(q*!s+"-8*!,-!+&1K%03&*1@&(L.*8. 5.$a%3*A)+o0&K4)+--g, S,!C*&$-%.>-i#&#'!+y"+H')&B"-9$H&,),'!&*+
.9"	)4&o('$'(G!){!
) *A% !\$z#"J$(,#d*!- ,/&. #A"#%&)('u(*[++&**)))0)*+Z**+-.q./~0O112&21210/..J-,+*3('%$##!" PaCP/K}}g`nn dKl}iaESI#%!)%#'&3)X&*i+*r+,,-..0/5k3575:8<8;9 =(;?G>~C@DCFEIIH%IIJJIKHAKGwMIcLIILIHI(IYK	JiJJIGJCDAA=>::54?-,'#[(g*t!o+"-8!,-!+z&1B%03!*17&(F.*&.5!$Y%3*>)+i0&E4)*--Z, B+!>*&$-"..,b#&'!+k")E')&:"-1$H&,),%!&*+.4"	),&l($'(=!)z!) *A% !U$x#"F$*,#h*!,,LEY!%#w##\'
))')*+_+~+N*e)z)*5+@+++5,M-./T/01k2L222s22'1_01/\..,-#,*('d&%#$2#g"Q y_'l"lzz- mBu~fmOSaU#%!&%#'"&H)q&*|+*,,4,-..0/5{3M75	:D8:<8;93=:;?m>C@5DCFEIhH;IIGJJIKHmKGMILmILIHIIIK&JJ JIAGJCDAB=0>::54Y-,(#S(s*!r,
"-80!,-!+&1S%030*1M&(R.*6.%52$h%3*D)+v0&T4)+--e, R+!H*&$-&.>-i#&#'!+t",W')&E"-5$Q&,),/!&*+.:")8&h(($'(J!)~!
) *G% !Y$|#"K$-,#n*!-,.S!r##l#'w*H)q(,)z+"+++*))*+,6++,.e/`/0t1L22313(3
3210//<.-,+
)f'&f%$#" P(NE(	(9/v-R  1sS #EW&1!s%$A']&)'L*,J*,m,-%.Q//W1j0538i5:8=9R<p9=<W@?@D@E]DGFJ!HJJKtKJLI+LHfNJXM6JMJIJJ?KKcJKJHeK{D]EBB=?I;Q;654.6,#(y*!,"-86!--!+&1c%03;*1P&(^.*?.359$m%3*@)+0&W4')"+--f, Z,!O*&$--.C-v#&,'!+{"-Z')&J"-4$[&,),1!&*+.<")9&p(*$'(D!)!) *F% !_$x#"K$0,#r*!-
,s
 #
""&)E(m',(w****)(()*+*t*+->."./5/0111111j0/|..-,+t* (o&%$#"! +9(4|o<tqcVhl!Z8hp`~L5S%"%!%e#&&)+&*.+*<++,d-.S.0/85"27{497<8N;h8<;;>>,C?D.C[F2EuHGIbHJ+J&IaKMGKTGMOHKIYL;I4HNHHJJIJBHG&J7C3DnA_A<>Q:O:b44-+#l8(g*v!i+"-8!,-!+s&1>%03*
15&(D.*".$5%$L%3*.)+m0&E4)+-~-Y, L+!<*&$- .3-l#&'!+p"!W')&H"--$U&,),.!&*+
.5"	)4&h(+$'(H!	)!) *E%	 !V$o#"F$),#n*!-,qk:~!R##:#'=*)<')=*+++*))*l+z++=+k,.//}001222222Z10b/..U-O,9*)'&%%C$X#"i 'h0w,	v zz/)o$N	y~bPk#(9&!`%$'1&_)'*,*,6,h,.%./11/5385F:p8s=>9<9u=x<?>DO@DD,GFRIHJ;IKKJNL8HL*HN/ILJNM,JI=IIKJJzK(IGKDE@BBT=>::5`4.	,c#(z*!y,"-83!--!+&1O%03)*1B&(O.*2.%52$]%3V*8)+r0&K4 )+--c, R,!G*&$-+.3-r#&'!+q"+N')&G"-1$X&,),/!&* +.7")4&m(%$'(E!)|!) *>%	 !W${#"?$),#e*!,,Kj!###'*n)(H)+F,,+****+,J++,./t/01b2"33E3C3'3022
0//L.-,+)v'&t%$#" Y.VL%'=,}-NuPx#JI& !i%$9'J&w)'&*,+*,N,-.@./?1J/538H5g:8=h94<W9=<;?? Dy@E;DlGTFIHJIKTKbJL}HLsHCN~J"M%JMqJuIIJ$KK<JK~IH[K^DSEBgB=?D;6;:54.0,y#(*!,"-8C"--!+&1_& 036*(1S&(b.*K.55C$u%3*K)+}0&\40)%+--e, ^,!S*&$-2.9-|#&-'!+"1R')&S"-;$R&,)	,6!&*	+.:")<&q(4$'(C!)z!) *C% ![$~#"L$/,#j*!-,6IA:",$$-$(Y+N*j)*g,,-,+**+,-*,w,-/s0n012d3(44Z4O404;331002/.-v+*6('&3%7$]#9!^ [4+q8AluSC-DOC<cL6"M{BT w #&"&$('O*(+-A+-k-.;/l070}21O7V5+97<D:N?:>
;V?=AAFBGRFIHL<KLL#MMLNK_NJPL{O}MOLKLjLNOMMIMLRJMFxGDPD?@<<66'/Y-u$ 
(*!,7#.:8k"5-9-"+'1&03f*>1&(.*j.\5_$&	4*e)+0&}4E)@+/--, z,!c+ &$-=.1@-)#&<(
!+"=d')&T"#-K$b&,)&,?!&*+.E")?&(3$'(O!$)!) *I% !Z$#"O$0,#r*!-,.$3 #E"#*&)('(*n+,+F+*4)I)S*++*+,-.//01@22b2Z2E2V1140/7..-+*{('N%%$'#T"? p{T"i  ~ pu{+$e >}
}vOTBc# *%!;%$'&K)w&*+*,
,:,-..0/53Q75:M8L<8;9@=R;?o>C@@DCFFIzHHIIOJJIKHmKGMILILIHI\IK;JJ4JI]GJCDAB=;>::54_-,*#c(p*}!x+"-8'!--!+&1K%03.*1G&(P.*<.*50$g%3*A)+n0&W4)+--g, P,!J*&$-'.2-r#&('!+",P')&I"-7$T&,),,!&*+.B")<&l(.$'(P!)!) *G%	 !X$~#"N$.,#f*!-, #1"#&)u('c(*J+ +**
)'),)*+X**+-.r./0M11212+2210//.]-,+*J(',%$$#;"$ fpYcO_yeqp)b:vzgZ8P)"%!%i#&%)6&*$+*4++,`-.S.0/"5+27497<8C;y8<;K>>*Ck?D&CZF6E{HGIUHJ/J7IiKPGKLGMFHKI]L6I4H^HHJJIJMHG)JGCFDAjA<>l:j:t44$-+#t;(t*}!{+"-8/!--!+&1N%031*1E&(V.*>.#5-$g%3*:)+q0&S4()+--m, U,!D*&$-$.9-m#&#'!+{"0K')&E"-@$P&,),'!&*+.=")>&q(($'(P!)!) *I% !Y$#"R$/,#l*!-,_["o!4##(#u'*)) ')!*+++m*))*X+i++%+Z,j../h0012r22222B1~0K/w..G->,2*)'y&%=$N#v"e $r2p)v yy1'kXQ6#CP&!^%$+'J&z)'-*,,*,L,-.,./91G/538O5q:8=|97<[9=<M@
?&D@EVDG~FJ?IJJ
KKJLIFLHNJMrKMJIJ^JL_KKOKJqHKDF
BC
>8?;;55..,$(v*!,"-8="--!+&1[%03:*1W&(\.*@.25;$r%3*C)+y0&]4)) +--b, ],
!K*&$-&.7-x#&&'!+"1I')&F"-=$P&,)
,)!&*+.C")<&s( $'(M!)z!) *D% !Y$#"V$-,#n*!-,p #""&)H(v'3({****)())*+)**+-[.C./Q0 01111110/..+-,+*"('%$##" NW=K0My {i\hl_>nkK1P""% %d#&%)&*+*(++,V-w.@.k0x/527_4w97<O8;18<;>=C7?^CCEEHGMHHGIIHJGaJFLHKzHKHGHLH}J0II'IHQFIBD@A7<l>9:4~3-K+#A(f*i!k+"-8!,-!+w&19%0{3)14&(E.*".5($Q%32*,)+a0&L4)+--X, T+!F*&$-.	:-
p#&'!+}"*K')&B"-8$J&,) ,-!&*+.?")9&o($$'(I!)|!) *J% ![$|#"P$(,#k*!-, >c!###'*`)(C)+>+,++***+,O++,./001q2333[3V3:3M22!00/].-,+')'&%$#" h6`P,!+<2x*M4T$ #e|&R!&$a'{&)'c*,e+,,-O.m/</106694 85;9=9<:>&<@e?DA:EDGG JI_K)JnKKK1MIMHOJMK8N
KJ8JJLKK~LJHL
DF*CC=>U?;;65;.,$ (*!,"- 8O"-#-!+&1s&03A*61]&(r.*S.L5J$~%3Y*W)+	0&p49)4+*--x, t,!b*&$-2.%N-#&3(!+">Z')&P" -F$Y&,)
,7!&*+.N")C&y(4$'(S!)!) 
*I% !c$#"O$+- #m*!-,Yy ""i"&I((.&(7)***s)(()h*q**/*b+m,-.V./0r1K111m1z1#0b/7.o--A,G+A)(<&%a$#"! #e\z0aeYP[dU0eiUqB&Tw"% %?#&%(&u*+s*+{+,.-R..W0`.427(4^97{<18;08<:>=C%?`CBEEHyGTHHUIIIJGK FLHKIKHGHwHJTIIOIHFIBD4AAd<>:$:43-X+#U+(_*m!b+"-8!,-!+u&19%0s3* 10&~(B.*!.5#$N%3
*))+_0&F4)
+-s-[, J+!H*&$-.4-a#&'!+u",J')&F"	-5$J&,),(!&*+.5")7&u("$'(H!){!)  *D% ![$s#"H$(,#e*!-,!)5L]^lq *58CATQW^eiltu.EXz$70U]acw|

27FLFUUcdt~r "0$=1FDLjq]XXry4-(	/$2@7-36E!Axl^oB 	}Pvk]Pxi-AvBE65XI~M\eTR             2:F^pp
%*/8BNQ\Znjpx$.?Zm<	"-/<MDjry|0,BW]lqhyy	#+6?@OA[NdagztsBE-%3+4#@X)=:1>:J:B}*kuR.!H&usS^5PVFOY4
?|8M-          }  &=NO^c~&(31DAGOUZ]deupwv8Mlf	0*NTVYkq|$)6=7FGUWbnd,338WaKFEk^gm|w}" 
+:-0'+(-yh	Zi5)=w#lA@uIrj'6L56^,+S
{5)<|B           *@QR`f*,75HEKSZ^aijyt|{-?Pp
(5,OU^[pu{$)5=5ECTR`la 

'1.3SYGBBhZahxs{x
,$*#(08y~pds1)}2o
$i+Q?ztOCQy,"D9]kT      b  v  *@QRae
 ,.98KHNU\adln|x~"0FWx ,A8\chl}#;?LVL\^jn{~ $01=3NAWU\}qjl$M#PI,$G/YET=V@eTMZPMi[[b:d5<F+>N)rN:DcWa|nku$5. -,Zd&h0AUY7~N\             &=MN]a|#%1/A>DKRWY`aplrq|z| .A]rw
' ENWVemu
#)6=7EFVVbk` 

(1.6R[EAAfZ_expwu
 RqI7#A[eOt#c^|}V>GkX$
8T>!~a=r17V              (?PP`d*,85IEKS[^aijyu{{*>Po 50U]abv{ 6<IOIW[hiuu "&4'B4JIOmwa\\v|/9)*9&#;B0'7)<D4H6T+x'`#oI?39m).v<\kP@E",           &  )@QR`e!,/;9LIOX^cfno~{'4J\z$"3D=clqt)?FR[S`cqq").9.H<ONUs|gbc|
?	M>%5O7E/["XO3[<R]QeUh2+>!L{A9hOI7u5wxv/s/aF6lD-nDDEcq'P(gN         Q  '/:Rcdty	%.9EGSQebhpw{! ;CTo}2 87AIWUz"51E\aoxm!*1:DNQ_Sn_xt{*B#;5#k-*rUD>`>ie^ZuG~mZul`k=WTa;]U_goKb5)BLN'q<g)t|hE8 tW 0        }   +BSTdh%13?=QNT]dhltu'3AUh#
%//?RGoyz{
$"4LQ_g`oq~!'2;?M@[Ncbh}vw +
# Y,`J;5T/[a_Kf>{[HigYct+DGX&OPbvedLsYc+(R/} I,yOE]2VV<G#v!.  *        )=FRj|}&
(0:>DMYegsq 15BF`lzs]<K@^`cv|41CPHQUUgcz,#-JVajr|
!P5BXbSziHtw'v?S3z7,/t{9}rkmhh~CFgD          *3>Vhix~
"&,6@LOZXljpx,.DObtBI(-+BGM^nb (6,278KI\u{
'3>FNWalm}p}"(1!G_>[aGOPxn[dyozd^k]v@_1 X_pf4b=BWV~oR}wl\        }  /8D[mn~)-3<GSVb_sqx	
!.3LXf}	AA41+JOUfoj 1;25>:PMby
,6BJSZeoqr%
-7$NgB#_\DUPxpj|ls{hxn[w":tBXUQrBOBORWo9}C)lu  *      R  /8D\no).4=HUWcaurx	 $01LVk H	G&8,IFK\mg+8.4<:NJ_x}*4?HQZcmq|p$	*4 Ka?[aLUIoouq}xm{ld{| WgLAYjS4`6~QWq:&}         X  $7@Ldvw!)37=FQ]`lj~{%+88S_n\Y1F?Q[_kzs+'<I=EKJ][p
<HRZbmw	7)?I7`wP4r|^akvz|u 'Q1TB`vng17\Ce$N.         }  *7LUaz
;"4=EPTZdo|~"!$#49HM]^v
?>2mNQMtot	)EBWbY`bcyu$  709Waku}	!O6AU_KwkG{y}3$/):a2uG5H
d`p|	L>f:	hY Z       }  
-;NWd}=$6?HQV\fp}$!'%5;IP`bzBA
/zU]Vxy)@YYo|ou~z  A.=<WMVs	 3->21EsXexpj+N%#B=8[&aes< m`t|	YYI l	&rMW             5CW`l
$#I/AJS]bhr}'0,1-?GWZhiPR-Ilsk$+:Nlf|
L:JJbZe 	 -#*<8I@;O}bp{y8a:#-HCAg=q*
L QG"?K	zs0WARc	60M/_          1>R[gB);DMW[akv#+).,<BSWdgLMAy_k`
)@XUkypszz<(87OHQn|	+$7-*=kQ_r~mi+V1
#03.P2h6m= %DqY	4wJ!IO;[- !l           +4O^r{)36BAhNajr}CK)315CIFW\ms
9q{
:Pa|!)8CKWo 	 !!.=1r]nn} =G2()SEMSg_rhdw	  	!OyU5+H^QG'Mn7j5c=BHDja	Aq	,	!J	KiN7tG         ,  =Hcq;4HRUbap	.)1/=;@BJCt<}L\fchx~|,Py?&?pp/6B@W_i{9@NYNacrs+4?IL]Nm]ww{'A^5U	KRKtkY{gzqiqrvzdj\u1bXfp	Y	8	a	;=	J	.	f	J		0	g		#	L	.						?
		y	JmO5          '4GQ]u 4-6>HMS]htw.2DIVXu;85oVa`rv
$6SNfohpts5$52JBLhv& 1&$5eJXhua_7c9mD1w)F2'	
N_muwPu3	J^[          &  2;F^op */4>HUWcbury
 $35OWj
PH194MPXdxv	#2@4<B@VSg}
.:FLU^irtw&,6'RhD$at=NU|eZmwzpypboPwn}5^5grAg
Wf	S_l^{8S/w *      '  &/:Rccsx	%/9EGSQdahpx| :GVo}19'&8?ATfa/!&/,A<Rio{{$.6=GPY]i^yj	0I)=J4rA>~mTKrZa{h~^nnn~zySTULXUa|rU<aMR3'Hk$Bc}xY_i"  0 *      ~  "-DVVfk)58CBUSYahmpy{ -;F[q#*/5<QJpx)$9OWbjart")3<?M@\Lc`gzuv(
"%U
d;0"JWAU2Z7kE@\Hdc_sW7r0#T+-3Sgj\FaApu4o,} >r-_n[><*M8U\  0           !,CTUei	
&24@>PNU]dhltv 
*1C\j"
(-38HChpz{ 
 /HLZb\gjxx *46D7SD[X^}qll
<[9+>Q4F0N%i09X;S[EWO"f%!K$=]N7;KV[UzspTCCn&,fo`R1g\/w         X  *@QRbf
".1=;NKRZafiqs~	
%.AWi#	#,/=MMpu~}#"5JO^e]no{~&-9:G=UJ`\burp%a$eW/+N*aCVBe9tQNk\Yo]p_>}F;c"?@OjhZTpSw|?-*,*tz!zgB #*Ra[\/ 0        '  !*5M__ot
!*5ACOM`]emty|
! =FRl|#
@)";FHQ[_	! %$83Hadsyq"*2<DOQ^Sl`uuz	*B<@n,1nmK4[BwTnP|Oc_~`uvtHQM}=FT^kme\1T8*():z&)I-
S|            #:KK[`z&(42ECIQY\`hjyu}|&8O^	'0C>`dom&>BNVN^_nn{}
'+8-G:QMUq|hab| @
BA&	4F+>,J*WG5a8FXPR^*R-%T%/;SOM6k6fof.eo\056+85B&$
:0           
%1HXZin +79ECVSZbjnqz{0:G\s; .4=FUTy
++?UZhogux
&.9CFSG`Ukho|~5.;!^.fS60R0dBWOa<ubFnL`k`ka?n>,]-/9Ufd[Rqg{%g"	D^]3>O0O.5IM"<              "*6N__ot(2>ALK^[bjquy8GTe83#&6A?M]X} !"21D]alul}
'.5AKN\Oi\upy*B8B<s=5kOFuNv]|ox[Yez{zXXLpLQZd~jyo CyEdK./TKje4NU/
{jx@9         }  (<DQiz| $'.8=BLWdfrp	
"09FIeo%r
4_@IIciiz 74JVKNZWjg},$-KVaipz
G/>P[JodEnzi{{ $>d%ZfuX/1|4co7mKQ-r         }  (>PQ`e
#/2><OMS[cgktu 
-7CZh(+37CNNrx&$8MU`g_qs~)3=>M?ZLc_gzut(	!&MoO="X9]C[U]Aa`NnUXml|j<}?FWMHQNlmZ\r[e&hB9E#: ~)Rm/yl#{6X]s          ,  %<LM\a|),87JGMU]bemo{%0@Rh!	#%,8EBdirq(;ENXO_ann~
!+-;.H<QOWt}ied~M#dN.-X6f=_TaJg`RhSdwf^8~@D\8A=Ge}eKuez8Eqf1c0Oz-_bc&_           )5L]^ns(3>AMK^[bjrvz
:GSh6##8B@PbZ"31D[coxo(.5?KUXfXug~|$8V2R\j98}jG>eNs^mgtY{x`pldxwMKMkMUH[|cx]squ:o1:>X)kBW]]m.j"dl]V0        S  
!7HIX]|x%(32EBHQX]`hjyv}|&6J_})%'2C<biqn"8?KTKX[hhux "0!<0DDJip\WV}pw~	 -P*6A3G6E,PO.Q;C]WTP0[4#A6{44@eOcRy\~!Y@p)y>~1O>OC|Ara}z?^   Z       ,  "+7N_`pu",7BEQOc`fnw{~$%BLZo"E+(*?GKWja
+$(0+@@Sip||'28CJV^aoc}p !.DY9PVTxOEwjXazulwgvnhzs&`	tV;mHh!/	#&WX2.;%s: 2       ~   6FHW[zv"%0.A>EMTX\dfuryx"/FYy!.?9Z]md|5;GLGWWdgvv"%1&@4HDMmsa[]v~	5O7
EJ-D,F+FO'U6>ZQSM)W,*=(&7?UNXi}NlZ.d0~#hTfvlt8 z`y|           

&
\6:k~p$szjT#	yp`L+lB



u
^||laB .vf ;]+jpACD




n
a
7
#
.
 

					j	T	C	A	*		^KZU8%sK=1rjWF.jw$ss^G9w}muMlWAaIjUfL4\6F 8
<~~:m`M?(     Q   %       "  =|
}'[~9\I4'6GI>2#M;3r]LzB



.tK3,1b
=6FYuwxTD6



x
i
u
h
b
O
								l	_	K	6	(	
~gWC%4-m_S<!!(lZCy#.zuhW8%#|puUsX=''
aXm\hV5cCN">
>D|<h==     `            


S&OsaRBRii\SH8$slJ-#nF-



i
@
+xXSVC8PssRxg?Z0.+






V
C



						c	L	5	*	'		mH4A< k\4(~~zm_UC2}YbchUH(u}dkMpV;`WjLfP/\=N5/
z6ZYm2"    ~          J  

_:.aweSg{|ri(/]L6&~^@5(V<



x
T
Bnnn]Q/W&Dkuth41-





^
H
 


						g	J	5	&	'	{jC/;7fX/"zzvfYQ?.|XgaeUE"
r{^pHlU=bWiEfF4V9A#4)oHKjX:(              e  

b=,cyjYh}wo27bQ@1jKB4bL'



e
SobF	&k {9}URO' 



}
h
?
)
3
-


					r	[	L	N	6	'		nUg`F5"[OB,lYE"5wjG1	*~biK7&0|koZp]<jI	K8D9!/kVebvO. 	   h             


P"DfWG6CX[PG
	6*vc]=[0



s
O
)
]f>9;)v{kmiq#e-ibQ5A





|
M
;
	

						h	E	5	#	#		 ~g@.=:	dW-" yxudVP;)uR`lpQNC+_llL^0Z@&wsrVuBNr8X:J*$%{uV2y<MS("    ;              


W0"V}l\N]rsj` %SF1#
}[@6%U;



v
P
;dbeTH'
P8F
\e>>>





q
\
.

/


					i	U	E	E	/	 	_O_V7*vL@2	sjXF0
mr	qxdL3!~m}QqYA'"lZmJrQ7^?6(=
#oFKoSJ    ,           /  

[5(_vaTbx}si,2`R>,mNE9'iT.



q
\ujP)*uDKJQJ}F_bd;,




y
Q
8
B
8
2
					|	g	U	T	@	0	"	q]icE7"
|TG<"	
{r`M7u~#*}n`>3"p`}eM/"%
prx]xZ?oCNL
B!u^\`mLC     C          6  3
?)vR!X[dUJ tK:1u>



D

kb.X%
+NX
+3Bq^y;
ydI.




j
~
y
e
N
								o	`	R	;	.		tdO4B= rdO44;s^8#! 45IoWB7qqRA15#{k{eGmU\+TD %!o\xW{B4     ;          =  

hD&9oscv~@CvfQB,bYK<lE#




vlG3)B
8 &CJ_zP;&




g
N
X
R
B
9						|	i	k	S	D	5	$	px[M6)$
h\O7$r`J($%<oN95vhuX;-
5|kbwbDhQM'JE"!mkkWJ1   	 4         Q  r
	hSBYOPs^K5uUK<&^GzN8

u

V
W
[
F
;
s}v
:
~

8v_FD3^2






z
U
U
0
									o	\	>	4	ufPF;,e<&		|d\cWA:<o{U#i4m6%u^T/V&>~y_qfjCa,\%$'3<,z{mo_R  % o         l  D
N:n;u 	{yl8( q`S&b?


b
#
1

 
 L;s@17%6OY
VWgqaA%	ybX(








B

									f	X	>	)		uYfaF7 mTRZ9wT<491TN`0iQ"M*
tjKA$F6

tq[oY&dF^Y$-6%wmkydI  	 h         =  )b
q\B^ D:%%;>4."\JAsB{Y4


x
9
G



`HM8D<O[r

ml@lA<-eS1








N

)									q	Z	D	1		y\ldK;'rWY]>{W?6?4PLY4lO$M+
iLD#?"2	qwRtX&a@UY05!whasa4    C '        6  (`
o`Bc"J;)*CD9/%aMF&	tF~^;

{
:
F



aJU=?:Ig
pz	goC:~^N/








F

#								|	i	[	A	,		x[ibF8#nUTY;xT;5;/TQ`4nQ)F5iKE'H0qs^w[bD\]#(@% zsmoxlL &   C '          N
?y$#\rcPawxne"(YH3!
xsQ1'm=${U-

V
b
8
5
3

qagRSNbp

=b
(zNO9#wR






c
:
A
									u	^	F	*		q|_O91'ijrO%gMEM@*##h^o< v`0S5 mRC.M!9}p{_yl(jF] h-5,wc~\7  	  F          
hX-jkteW
qH4'}[!







f
>
 



D


6
f
!saa4.'X;





o
m
H
+

 
							s	S	H	-		 r\QG6i>*

|bZbU=64|sM&
m;iC (z[S4\+@) zwmuh!sCb%_!,30zqev\I U   Q F          
)&}k=y-
 v{k\%
vL;-a%







h
>
)




A
 

	
-

7WY[1#l8"/&	



t
U
A
/
0

							q	\	0		+	$	wl\8&`N..+ytZTS:'f>3LzS49ib>e6N+0nj1vNd2X$4+:,0s|y}d4 +  ; V            
Ec]MIq^K;LabXN	8(aLD! l^,T->







_
G
6

0

D
q
$J
?
(
2
Y


|
-cH1^?UA9#




o
Y
D
F
0

							o	E	,	<	6		{kD6oY:<5$}e^\A2vN).
US=D	pgHh>Q+#4!qp6yYn=\0/+==3f~G@ /  4 f         Q  
'C;*Y E8%"9=.%vA.%cQEv:+







{
U
=
2
$


/
h
=

5
:
,
e

R
\_a7|e7",



s
R
:
%
(
							w	i	U	)		!	zncU-![D'("zqynTOP4$
m9(FvL67fa;`;J"0mj2yKd5\*()9=#;hi7 P % o          D  
l^A{/\[H8t^6	w[, pA)P`.&! 




K
2
p
<
$
/
1
;
F
`
x
|

u





~
:
1

xT>a%







i
T
D
.

					z	b	o	j	J	4	 	 		ue3'cb^M<4	fU='cM=6`iJO1xpMoGV-)>
)wu;VhGc:03@R,9
q~ad B  Y            R__"g~krxeIqLA/c0tN"CP9/







1c#j
%a-S






m
h
c
A
 
	wZ*#
X7	






k
I
8
&								w			a	N	9	,	 	
jOLS/kR'mx,	ojKA1mO(@/"}|_^nI>X+4
'hl\_Tg{ELl.) P	  }         )  I3	B@xG8+~iG
[3u






v
n
L
"
	


(
l


<
f
4{{KIFkU+
	




c
?
,


							o	^	H				rg^N&~R? !
rkrgKFE+z[1pBjH'*w]Z4X1I&|]f.rPQ1U$+<D
-Vt|rdR    ,          /  ,k
veH`$G:)(<>6-XF@ zp@wU2


w
8
C



eMM@D>E]s
glo{R>( 
sU7







L
%
*
								s	_	E	3		|]kfK:%qVU\;zW>4;1_DT,	gP J)
tbKCF.  |n{rKPe;@S%(9
3sRkytE^    4 ?        X  
'
1eDELVH;g@-$h1



7
zgZ*L%CN}
"0I2F(u[G1



~


u
j
&	
							n	a	J	9	 	|m[@LG+ykS::@!w`;$$?=J#}\DB	m}b?<=
.y~yjqpAvL#V8HP	$.$uPro5I   % %         =  

iD$;nuftAGuhUE2ibSA"wO,





sF7.#,\
v	.<}OwxyTC)




f
L
d
L
D
2						y	i	g	V	B	3		kzuXD3% cWH2lZB!	 ##5{pf</ )y\iR))
-ruiZmc;eIT=> qJehm:=   	           "  

i:0d{jZh~xm17cTC7rQLA.
u^7




f|Z5$Iv .My7ccbF1





V
9
N
=
7
 					{	l	W	[	B	4	$	r_jgK:'	XL>(uaR<  {#vh];((oWxdP(%,eebPdY>UGC/34  RJcYh(1     4 ?           


J&MtfUEUlod_ #SC0%dF?3kR-



r
buV3Ag*C8{F~vnP6





a
E
T
E
@
'						s	a	^	G	:	*		veriN?-^ND-yfU>{%=qfE5.	|fmU3/	1xuk\mfD_JS+A9$
gVcbr?@     `          /  


C |&`t{.{f>/#tT/zZ$



.v_P!F8Hr
'g7H	}[I+




n

n
c
L
								j	]	K	8	'	n\I->4xi]E.,5~lV16-F{tMB
8kmQ;:8"	{zr^vlEgKS2H$8 '
|TcohZ@     ~   ,          
}
}
 Vg?6)'=?8/'lZX9k@+



p
O
>omn`X6,s[y|SKB)




~
j
B
#
5
#

					j	X	E	G	.		aJ[W:(rJ>1tjXG0my%v{bW8%rxZ|`D)(-njhUfPH[=I#E."kRp\SJ1     ` '          

!| W7HtMPo\M8
i_TB$pK*




{
rI2*	-Ve=&VFmtaE3



m
V
c
U
P
9							r	p	X	J	8	&	rz^M9-%iZP9%r`J'2.:	pfL2.|bgK,,
0ejlUh]E\I
O*D4
$iDa^o=      '            
	

E!{"Zop'urZ."weDlK




!hSKB	!Mu
g&[>l^? 



y
a
o
d
V
G
						y	}	d	Q	C	.		}eTD'6.rdXC'*/|kR07AI|_?5$nsZ:48	)rpwTwiLlPT<T A ,.xNmfvOC     C /           ^
K03i~jYlyq,3`T<,]<2#vL2gB-

h
w
K
L
Q
:
1

{pvv
;
`
0
-vjH@?e,






s
C
S
)
									g	U	5	-	~k\D;0"su|[1 qXNWM3-.xemI
	\*Y;nRK4L#:wi}Xy^(hJU*W$5:)$ZzdRL     ~ V           


;qBfVH<Mdh\V OA- 
aF@2lZ4



z
e|c>&
J#*JTpj{xt[>)




c
H
V
I
:
.						s	c	a	M	;	)		
{grnNA/! ^RD.yiW@ |!!-phO/"zbkR7))ziwUrfCoJZ8F<
 xVx`vTI     % /           

~
&Xk&J<- ,FJ@;1#xjgH-$}T=




d
QyqM+
3u(.'0r@ZSL, 




i
;
)
3


					j	W	F	@	1		aN[W5)sJ=2ukYG2p|
'-ljN1	%xbiM6+*"}ps`mcHgO	Z>AH
sZb:U     Q         Q  


8jShk"q|lZ,uaDmJ




#jSH:&Jq
!|Qiy2yYD



{
[
r
\
W
=
						x	x	e	S	E	1	!	kXH,<4
{pcL33<xa>(&I)ArY<0gmT:10
#nwWpaDoPX7BD	'P|bx8a     `   B       6  
l
f
	=K)*-&cRM/e=( 



m
L
:lioaR5M% wxJKK'




v
b
5

-


					c	I	:	:	&		|W@LH,se:.#re[K8" ektve[<!t{\v\B'zqqPce:jH	O3==!x\kfr2O     J            


>!x"]q{1j</$sV0{Z%



1
 xeY'M
%9L
'Y"@,
scB0



}

v
n
[
$								{	i	^	F	6	 	{lZ<NE+ylU:<B"|fC,$,
DQK)dO A1{}cH;%B0 e~tNw_eJP&P +/5ZvwxLL    Y  3         
j
`
 7@yQB:{Q)



~
^
<
(u^\_NE)T8K|ml@6+





f
M
(




					r	T	C	3	3		
yS<LH(vf?2'xjaQ>)grp{aY6!pyXsZ@*"ukrPeZBaJS.B9	Pmf]:7        ,       =  '/;Rdesx
)3>@LJ]Z`hosu} )=Tg! 
 $*2F>clqr,AFV[Ueets&02A4NAWR^{mhhA85	;&$.; K""B*9>@O* K(uf&zK*Y seXq6IKN?!>`PVcjZV            %8@Ldww$.28AKWZecwsz	2<Ni|Z -!0;=J\Qx
+',(?;Qgm|x$-4<GPQ`Rl_voy(%.	PP:0>7@-Jc4"HE=IETC&L#"4r$[8)'P.}{[g>X`OXc=H
>R/          }  !,CTUdi
#.1<9MIPX^cfmo~z",F\{r	#>8\cehz38ELFVWfes}t!.!</D@Ihq[WU|nw~0+*'5E7((;1517 pas?3%E+tIH}Qzs0?T=?f44[<#1CH           	$/FXXgl 
&24@>QNT\cgjrt~ *<N^% $7D9]dmj38DKDTSdap{q+7+B;DdiVRRxkpx,"#%"'7#05-19Bxl~:3%:w+q3YG|XLZ4+L
AdrY      b  y  
$0FWXhl)56BATQW^fjmuw	'0?Tf+
	%)/:PFjqx{
!2JN\e\ln{} *4@BNC_Qibm{|	5+&['.[V71R:eQ`G`Kp_We[YtfekDn@HQ6GW1{XBLk`iv!t&}->7	64bn/
r8J]a?S^             !,CTTch
 ,.97JGMT[`bjkzu|z&<Ol~ 5-S\get|		18ELGTUfdrzo	+8*B;FbkTQRwjov 	]}U?*KcmW}+k
f_
FOrb,@\F('hCv6<X              ".EVWfk 
&25@>RNT]dhjrt~(8M_~ !).C>ckpq

/EKX^Xfkyx *27E7RD[V`}qml< D55E2/&D"M;1B3HO>Q>"^$60h+#ySI;Au16DdsYI"M+'$3          '  #.FXXgl *58CBURYagloxy+4CXk,)20ASJqz	($8NUbjbpr(3:>J>YMa[fwrs$LXK1$@&ZCQ9d-c[<fG^h[o](r=6I+TIArYQ?}=8{8iO?v M &5wLMN"lz/X0lS         S  
-5@Xjjz	$'-7AMO\Znkqz
 .-HQc~ 5@#-(FEOWfb",$*1.D@Ulp~}  )1;BKU_apcp&9S3
LH0x;5}bPKkJuqjdQxdwmuHb`lEe]grwSj
>2KUW0zEo1~qMA( zX 0          &1HZ[jo$-9<HFZV]fmqu}5AOdw02==N`U} " 30D[`nvo
!(18CKO^Pl^tpz(;33f: kVGB_:fljUpIfQtqem}5ORc0WYjomS{ak4!
1[8	R5XMf;_`CO,(&% /  *        #/CLXq
	.'19BGMWbnp|z ',>BOSnz)#!%kJYNlnq*DBT`Xadewr$$$=4>[gs{	+!2aERhsczY5H%\<@57}B {tvqrL&NlK          08D\no */5?IUXcavsz$*9;R]q`
W6;8OU\m}p+$8E<AGHZXl7DOW_hr}~2&8A1VpO&ltT][zhozni!wg
(I"h:	`h
yo;kFK`^wZ&q_          "5>Jbtt'16;EP\_jh}z  *.;@Zfu_
 OB?9X]dt~x0,AKBDNJ_]q<GS[dkv	5*=G5^xS3poRc[|xw~sze+C}K`^Z{KXKXZ`w@K2%q{  *      S  "5>Jbuu!(27=FQ^`lj{,1=?ZdzfU4F:WTYk|u)(<H>CKI]Yo:FPYakt~ 4%:D0[rO/ktYcT{}}wxo) `pUIbs
\<	 #i?Z`yB.         X  *=GRj|}'!)1;@FOZfius	"18EFan}#zg>TM^inz ;8LYMT[Zlj0'/MYcks~
G-9NYGp`Ekov) )0Z:]Khw
p8@eLn-
V5         ~  
0=R[gC+<FNX]cnx'. -0/AEU[klPR
<|\_Z}%9USgrjprs5"11IAJhr} +" 1`FQep\|X@,82Bj:O>Pmhy	TGoC	pa Z       ~  3@T]j  F->HPZ_eoy(0-31BHV^npTV!:cld
 &/9PjjR?NMh^g$0#*2D?PDBVhvz
	6\2$.KFAd.jn|E(vi|	abR)v	0z
RY            ";I]fs ,+Q8JS\fkq{
3<
&$)8=9KTdhuv(ag ;T{y,5;K^|w)]K[[tkv)2>-4=MJ[QL`s

DoG,&8PLJpFz3U)ZP&+HT	|8`J[l	@8	R0a          6DXan%$J1CMU`dju /7	" $5:8INaert'^b!-Lmzn
%,9Pif|

M9IH`Yb + +;6I>;M|ao~z7d>/9;7Y;q!?vF	.Myb	>
S)RXBd5)&t           0:Udy&2;>KJqWjs{% OW'5?>AOVSdhzKH^l,2:IT[h#%41@NBo  )%/PYC:;eV^exqzv	"'
)'
,Za=3SfZP0Vw@s>lFKQMsi	Jz	6*%R			UqW=%{K         ,  CNjx!D=Q[^kjy&'94<:IFLMVOHXispu	&>a`4L~?FTQhq{ ,JR`j`su*2>GR\_q`p$-9'SpG!g	ZaWxgs}v|~pwi<laoy	b	A		k	EF	T	7	p	T		:	q

	-	V	8		%					I
			SuU8          
,:MWc{<$6>GQV\fq}'
&*):>QWdfLL@}dom&4Fc_vyF5FC\R]y%%62C85EvZhxro"E'$$lBvM91O :/	V	hv~"Y~;	Rd`         (  $8@Lduv!(27=FQ]`lj~{-1@B]exmU>FA[]fr3/BPDKQOebw	!#>KV]foy6*<F7bxT4qJ[`pgxzzm{Zv=e>p{Hp$`o	\h
t	 f=Y0y *      )  
,4@Xijz~	#'-7AMO[Ymjqy	+-HUd~NF,43FMOcun->05=;PKax~(4>FNW`jmzn{#+?Y8M\ANIz`X}elriyxx]^`Va]iy]DiVZ</Q&t-Jkbhq+!
  0 *         
'3J\\lq
(1=@LJ^[bjqvy!!:ITj10'#8=CJ`W~	"#!73H]fqyp"(29CLO^Pl]tmx#827b oH;/T)bL`;cAuPIfRpni}_A|:._56;[ptdMiHx}=w5Fz6h&vcGD2UA]d  0            '2IZ[kp$.:<HFYW^fmqu}7?Pky1/5:AFVPv~,,>W[ipkvy"&0:DFTGcTkeo||/,/IfE7H!\?R:W/t:BcE_fO`W,o0,V,"DfW>BR"^c]"zx\KLv.5nwhY8ma0y         X  $/FWXhl!*69ECWT[cjor{|2<Ofx,0 /:=K[[} 10DY^mtl}}$,6=IJWLeZpis	4-* n.od:7X4lNaKnC\WvfeygyhGPFm-GHVsrb\x[H	5253}*$nK)*2Zi`a2 0        (  '0;Sefuz

")3=IKWUifnv}	 .,KT`{?M+6/HSV_jl&0(.43FBWps '2:BLT_aoc}p$9R-LR,{9<yzVAeM_yYZnhj}R[XGO\fuumd9]$@211B .2Q6Z  	          )@QQaf	".0<:NKQZaeiqs~
)3F]m%	',4>QKmr~{#"4LP\e]mn~|$/7;H<WJbZevqr%LMN2>"Q6I6S4aQ>kBRcZ[g3[70^-7C\XU>s>nvn6&
$mwd7=>3?=I.+?2           #+7N_`pt)3?AML_[ckswz =GUj,H&$-;BKScb
'$*+99Ndiw}v(/6>ISVcWpe|u	,E">M.k+8p_A=\:oNbXjFmOyVlvjtiHwI7g77A\oncZy#n-n* %##Mfd;E&V9X5>PT)A              	(0<Seeuz	!'1;GIUSgdksz~)*FTbsTA13+CNL[ke ."+00A?Rkp|{$/7>FQ\^l_yl} 9R-GTIJ@xZSYhyebobcWzVYbltv	JMkT6!7]Trn<&W]7sH>         ~  	!-AJWo,%/6@EKU_ln{y+.=FSVs}5+>lNWWqww/FDZfZ]igyv'$$<4>[grz	$+W>N_kZtT{t1"G'm-c!n~ a6:=l
x 	?
uTY4x          ~  "-DVWgk!+7:FDXU\dkpt}~:DQhv 5#'"8@DQ\["!"42F\coun (/9BMM]Nj\slx!817Y+y[H.bChOf_fKljWx^cwurEJQaWPYVuwaczcl.oJAM+B!	1[t8u+?`d$y           ,  *ARSbg
&14@?SOV^ejnvx2=M`v./2:ESNqw%"6IS]g^no~|%0:=J=XLa\gxts+$&Z0!oZ99b@pHj]jTqk[r]opfAJOfBIEOnlS}l@'Myo9k8X5hj k.g          &/:Qdduy	!'0;GIUTgdks{*+GUav7B(00EOM^pg
!*#*1.A?Sjr~~*8>EO[ehvhw!(3"GfA$bn)vECvRKoY~jxp}cizvoWUXuW]Ocmd{
x|Bv:BG`2t"J`ffv6s*kqb\2        T   '=NN^c~!-0;:MJQYaeiqs
*3CXm6(24?QIow}


!0FMZbYfiwv&/1?0K@TQZxjfe

:Z6)@!L=R?N6[Y7[ENg`]X:d>-K@<<HnXjYd)`Hw1'G:WFVKIzi
F"d   Z       ,  	(1=Tefv{!%*4?KMYWkiow
"02OZg}=R857LTYdxn-:36>:NObx-7BISZfnqs(0>+SiH#`ha[Oudkupyrz.i|^'Bu!Qq(7	,.%_ `96A*y@
 4       ~  %;LM]a|
*-86JFMU\aemn~{
	&/<Tg"$(.<MFgk|r 	-CIUZVeesu%24A5PDXQ]}pjl  A
 YC!OT8O5O5QZ0_?Id[\U2`65G0->H^U_pVta#6k9+q\
m}u{A(g~   
                                                                                  A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                        ( ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                        ( ( ( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                        ((((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                        (((((((                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                        ((((( (                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                         ((((((                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       o                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                        ( (((((                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                         ((((((                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                         (((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                        ( ((( (                                                                          A A A A A A A A A A A A A A A A A A A       q                                                                                ! ! !  8! !                                                                                                        ( ((( (                                                                          A A A A A A A A A A A A A A A A A A A       r                                                                                ! ! !  8! !                                                                                                          ((( (                                                                          A A A A A A A A A A A A A A A A A A A       p                                                                                ! ! !  8! !                                                                                                        ( ((( (