PDS_VERSION_ID                       = "PDS3"
/*** FILE FORMAT ***/
RECORD_TYPE                          = "UNDEFINED"
FILE_NAME                            = "SP_2C_02_03860_S136_E3557.spc"
PRODUCT_ID                           = "SP_2C_02_03860_S136_E3557"
DATA_FORMAT                          = "PDS"

/*** POINTERS TO START BYTE OFFSET OF OBJECTS IN FILE ***/
^ANCILLARY_AND_SUPPLEMENT_DATA       = 24738 <BYTES>
^SP_SPECTRUM_WAV                     = 31046 <BYTES>
^SP_SPECTRUM_RAW                     = 31638 <BYTES>
^SP_SPECTRUM_REF2                    = 54134 <BYTES>
^SP_SPECTRUM_RAD                     = 76630 <BYTES>
^SP_SPECTRUM_REF1                    = 99126 <BYTES>
^SP_SPECTRUM_QA                      = 121622 <BYTES>
^L2D_RESULT_ARRAY                    = 144118 <BYTES>

/*** GENERAL DATA DESCRIPTION PARAMETERS ***/
SOFTWARE_NAME                        = "RGC_SP"
SOFTWARE_VERSION                     = "2.10.3"
PROCESS_VERSION_ID                   = "L2C"
PRODUCT_CREATION_TIME                = 2012-03-29T02:43:09Z
PROGRAM_START_TIME                   = 2012-03-29T02:42:02Z
PRODUCER_ID                          = "LISM"
PRODUCT_SET_ID                       = "SP_Level2C"
PRODUCT_VERSION_ID                   = "02"
REGISTERED_PRODUCT                   = "Y"
LEVEL2B1_FILE_NAME                   = "SP_2B1_02_03860_1AN0E35558N.spc"
SOURCE_FILE_NAME                     = "SP_2B2_02_03860_S135_E3558.spc"
SPICE_METAKERNEL_FILE_NAME           = "RGC_INF_TCv401IK_MIv200IK_SPv105IK_RISE100i_05_LongCK_D_V02_de421_110706.mk"

/*** SCENE RELATED PARAMETERS ***/
MISSION_NAME                         = "SELENE"
SPACECRAFT_NAME                      = "SELENE-M"
DATA_SET_ID                          = "SELENE_Moon_SP_Level2C"
INSTRUMENT_NAME                      = "Spectral Profiler"
INSTRUMENT_ID                        = "SP"
MISSION_PHASE_NAME                   = "Nominal"
REVOLUTION_NUMBER                    = 3860
STRIP_SEQUENCE_NUMBER                = 5
SCENE_SEQUENCE_NUMBER                = 31
REV_STRIP_SCENE                      = "N/A"
TARGET_NAME                          = "MOON"
OBSERVATION_MODE_ID                  = "OBS-NORMAL"
SENSOR_DESCRIPTION                   = "SP is a nadir-looking spectrometer which has a reflective telescope, two plane gratings, and three 128-element detectors covering 296 bands in 500 - 2600 nm. The first detector is Si PIN photodiode, and the rest are InGaAs."
SENSOR_DESCRIPTION2                  = "SP SENSOR DESCRIPTION2"
EXPOSURE_MODE_ID                     = "SHORT"
SHORT_EXPOSURE_DURATION              = 26.000 <msec>
LONG_EXPOSURE_DURATION               = 77.000 <msec>
CALIBRATION_MODE_ID                  = "NONE"
SPACECRAFT_CLOCK_START_COUNT         = 903277455.5538 <sec>
SPACECRAFT_CLOCK_STOP_COUNT          = 903277469.0217 <sec>
START_TIME                           = 2008-08-20T14:24:24.449314Z
STOP_TIME                            = 2008-08-20T14:24:37.917235Z
UPPER_LEFT_LATITUDE                  = -13.912881 <deg>
UPPER_LEFT_LONGITUDE                 = 355.749042 <deg>
UPPER_RIGHT_LATITUDE                 = -13.912881 <deg>
UPPER_RIGHT_LONGITUDE                = 355.749042 <deg>
LOWER_LEFT_LATITUDE                  = -13.230666 <deg>
LOWER_LEFT_LONGITUDE                 = 355.739949 <deg>
LOWER_RIGHT_LATITUDE                 = -13.230666 <deg>
LOWER_RIGHT_LONGITUDE                = 355.739949 <deg>
LOCATION_FLAG                        = "A"
ROLL_CANT                            = "NO"
MOON_SUN_DISTANCE                    = 151610105 <km>
VIS_FOCAL_PLANE_TEMPERATURE          =  20.00 <degC>
N1_FOCAL_PLANE_TEMPERATURE           =  17.22 <degC>
N2_FOCAL_PLANE_TEMPERATURE           = 243.00 <K>
SATELLITE_MOVING_DIRECTION           = "+1"
A_AXIS_RADIUS                        = 1737.400 <km>
B_AXIS_RADIUS                        = 1737.400 <km>
C_AXIS_RADIUS                        = 1737.400 <km>
SPACECRAFT_ALTITUDE                  = 106.752 <km>
SPACECRAFT_GROUND_SPEED              = 1.535 <km/sec>

/*** CAMERA RELATED PARAMETERS ***/
VIS_BAND_NUMBER                      = 84
VIS_SPECTRAL_COVERAGE                = (482.6, 980.6) <nm>
VIS_BAND_WIDTH                       = 6.0 <nm>
N1_BAND_NUMBER                       = 100
N1_SPECTRAL_COVERAGE                 = (894.4, 1688.9) <nm>
N1_BAND_WIDTH                        = 8.0 <nm>
N2_BAND_NUMBER                       = 112
N2_SPECTRAL_COVERAGE                 = (1694.9, 2583.1) <nm>
N2_BAND_WIDTH                        = 8.0 <nm>
PROCESS_PARAMETER_FILE_NAME          = "SP_higher_level_proc_param.txt"
DAYTIME_EQUATOR_CROSSING_LON         = "N/A"
IMAGER                               = "MV2"
TM_DATA_SET_NAME                     = "MVA2A0_02NM03860_005_0031.sl2"
TM_CORRECTED_START_TIME              = 2008-08-20T14:24:20.906634Z
TM_CORRECTED_STOP_TIME               = 2008-08-20T14:24:34.933612Z
TM_CORRECTED_SAMPLING_INTERVAL       = 12.999980 <msec>
TM_LINES                             = 1080
TM_LINE_SAMPLES                      = 962
TM_FIRST_PIXEL_NUMBER                = 1
TM_LAST_PIXEL_NUMBER                 = 962
TM_UPPER_LEFT_LATITUDE               = -13.924428 <deg>
TM_UPPER_LEFT_LONGITUDE              = 356.102308 <deg>
TM_UPPER_RIGHT_LATITUDE              = -13.931546 <deg>
TM_UPPER_RIGHT_LONGITUDE             = 355.408179 <deg>
TM_LOWER_LEFT_LATITUDE               = -13.213784 <deg>
TM_LOWER_LEFT_LONGITUDE              = 356.091595 <deg>
TM_LOWER_RIGHT_LATITUDE              = -13.220876 <deg>
TM_LOWER_RIGHT_LONGITUDE             = 355.399616 <deg>
TM_SATURATED_PIXEL_PERCENTAGE        = 0
TM_DEAD_PIXEL_PERCENTAGE             = 0
TM_SHADOWED_AREA_PIXEL_PERCENTAGE    = 0
HIGH_SP_POINT_NUM                    = 0
NORMAL_SP_POINT_NUM                  = 38
UPPER_MARGIN_POINT_NUM               = "N/A"
LOWER_MARGIN_POINT_NUM               = "N/A"
CAL_LAMP_INFO                        = "N/A"
MATCHING_ACCURACY_INFO               = "1001"

/*** DESCRIPTION OF OBJECTS CONTAINED IN THE FILE ***/
OBJECT                               = ANCILLARY_AND_SUPPLEMENT_DATA
    INTERCHANGE_FORMAT               = "BINARY"
    ROWS                             = 38
    COLUMNS                          = 43
    ROW_BYTES                        = 166

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_CLOCK_COUNT"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "sec"
        START_BYTE                   = 1
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "VIS_FOCAL_PLANE_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 9
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "NIR1_FOCAL_PLANE_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 13
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "NIR2_FOCAL_PLANE_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "K"
        START_BYTE                   = 17
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_1"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 21
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_2"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 25
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_3"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 29
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPECTROMETER_TEMPERATURE_4"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 33
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_RADIANCE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 37
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_VOLTAGE1"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 41
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_VOLTAGE2"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 45
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_TEMPERATURE1"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 49
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "HALOGEN_BULB_TEMPERATURE2"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 53
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_ALTITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "km"
        START_BYTE                   = 57
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_GROUND_SPEED"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "km/sec"
        START_BYTE                   = 61
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUB_SPACECRAFT_LATITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 65
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUB_SPACECRAFT_LONGITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 73
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CENTER_LATITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 81
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CENTER_LONGITUDE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 89
        BYTES                        = 8
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "EMISSION_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 97
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPACECRAFT_AZIMUTH"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 101
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "INCIDENCE_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 105
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SOLAR_AZIMUTH_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 109
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "PHASE_ANGLE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "deg"
        START_BYTE                   = 113
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 117
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_PELTIER_HOT_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 121
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_N2_RADIATOR_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 125
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_CAL_VIS_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 129
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_CAL_NIR_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 133
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "DPU_TEMPERATURE"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "degC"
        START_BYTE                   = 137
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_POWER_P5V"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 141
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_POWER_M15V"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 145
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_POWER_P15V"
        DATA_TYPE                    = "IEEE_REAL"
        UNIT                         = "V"
        START_BYTE                   = 149
        BYTES                        = 4
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CALIBRATION"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 153
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SP_PELTIER"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 154
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "TC_MI_STATUS"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 155
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "CLOCK_COUNT_ERR_FLAG"
        DATA_TYPE                    = "MSB_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 156
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SPATIAL_RESOLUTION_FLAG"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 157
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "GEOMETRIC_INFO_RECAL_FLAG"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 158
        BYTES                        = 1
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUPPORT_IMAGE_LINE_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 159
        BYTES                        = 2
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "SUPPORT_IMAGE_COLUMN_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 161
        BYTES                        = 2
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "THUMBNAIL_LINE_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 163
        BYTES                        = 2
    END_OBJECT                       = COLUMN

    OBJECT                           = COLUMN
        NAME                         = "THUMBNAIL_COLUMN_POSITION"
        DATA_TYPE                    = "MSB_UNSIGNED_INTEGER"
        UNIT                         = "N/A"
        START_BYTE                   = 165
        BYTES                        = 2
    END_OBJECT                       = COLUMN

END_OBJECT                           = ANCILLARY_AND_SUPPLEMENT_DATA

OBJECT                               = SP_SPECTRUM_WAV
    LINES                            = 1
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "WAVELENGTH"
    UNIT                             = "nm"
    SCALING_FACTOR                   = 0.100000
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_WAV

OBJECT                               = SP_SPECTRUM_RAW
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "RAW_DN"
    UNIT                             = "ND"
    SCALING_FACTOR                   = "N/A"
    OFFSET                           = "N/A"
END_OBJECT                           = SP_SPECTRUM_RAW

OBJECT                               = SP_SPECTRUM_REF2
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "REFLECTANCE"
    UNIT                             = "ND"
    SCALING_FACTOR                   = 0.000100
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_REF2

OBJECT                               = SP_SPECTRUM_RAD
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "RADIANCE"
    UNIT                             = "W/m**2/micron/sr"
    SCALING_FACTOR                   = 0.010000
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_RAD

OBJECT                               = SP_SPECTRUM_REF1
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "REFLECTANCE"
    UNIT                             = "ND"
    SCALING_FACTOR                   = 0.000100
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_REF1

OBJECT                               = SP_SPECTRUM_QA
    LINES                            = 38
    LINE_SAMPLES                     = 296
    SAMPLE_TYPE                      = "MSB_UNSIGNED_INTEGER"
    SAMPLE_BITS                      = 16
    IMAGE_VALUE_TYPE                 = "QUALITY"
    UNIT                             = "N/A"
    SCALING_FACTOR                   = 1.000000
    OFFSET                           = 0.000000
END_OBJECT                           = SP_SPECTRUM_QA

OBJECT                               = L2D_RESULT_ARRAY
    LINES                            = 0
    LINE_SAMPLES                     = 0
    SAMPLE_TYPE                      = "N/A"
    SAMPLE_BITS                      = 0
    IMAGE_VALUE_TYPE                 = "N/A"
    UNIT                             = "N/A"
    SCALING_FACTOR                   = "N/A"
    OFFSET                           = "N/A"
END_OBJECT                           = L2D_RESULT_ARRAY
END
AuA  ACs  AAA
A@I@I@IAffAffBՁG?v+4Y:%@v<ݽ+e2*@v;
?@:YB=CoJB;×A3)5!AAAY@&ng8Am
  AC  Auy9A  ACs  AAA
A@I@I@IAffAffBՁ#?v+@v<+<@v;8M?@:PB= Cm,B;A3)5!AAAY@&ng8Am
  AC 7 Au$A  ACs  AAA\A@I@I@IAffAffBՀ?v+W7z@v<]+F@v;Vv?҅@:@B<=CkB;A3)5!AAAY@&ng8Am
  AC S AuR0A  ACs  AAA\A@I@I@IAffAffBՀ?v!+{g9@v<몚+PMp@v;H?@@:&B<ChB;XA3)5!AAAY@&ng8Am
  AC p Auȁ?A  ACs  AAA\A@I@I@IAffAffBՀ?v&+ryhS@v<+Y@v;	?@;B<{CfB;A3)5!AAAY@&ng8Am
  AC  Auȯ'A  ACs  AAA\A@I@I@IAffAffBՀ?v*+i ^@v<t+5c@v;(E?¹@;WB<CdB;A3)5!AAAY@&ng8Am
  AC  AunA  ACs  AAA\A@I@I@IAffAffBՀj?v1+_n@v<\+n@v;A?@;&TB<CbB;*A3)5!AAAY@&ng8Am
  AC  Au
AACs  AAA\A@I@I@IAffAffBՀE?v4+V-|@v<
ݎ+Uy2@v; q?L@;8IB<cC`yB;tA3)5!AAAY@&ng8Am
  AC  Au;A  ACs  AAA
A@I@I@IAffAffBՀ?v8+Le@v<+8`@v;\m?@;J8B<	C^[B;A3)5!AAAY@&ng8Am
  AC  Auj5A  ACs  AAA\A@I@I@IAffAffB?v=+CPU.p@v<(Ɗ+~u)%@v;+5?@;\!B<ݯC\<B;A3)5!AAAY@&ng8Am
  AC| Auɘ̏A  ACs  AAA\A@I@I@IAffAffB?vD+9-/@v<
Z\+ue@v;2?@;nB<WCZB;\A3)5!AAAY@&ng8Am
  AC4o AudA  ACs  AAA\A@I@I@IAffAffB?vF+0rK@v<	ܕ+k@v;پK?@;rB<CWB;A3)5!AAAY@&ng8Am
  ACPb AuA  ACs  AAA\A@I@I@IAffAffB?vK+':}h@v<׀[+b$@v;
.?.@;ubB<ЬCUB;A3)5!AAAY@&ng8Am
  AClT Au$A  ACs  AAA\A@I@I@IAffAffBe?vQ+@ߦ@v<"0g+X9@v;I^??@;wB<YCSB;BA3)5!AAAY@&m:Am
  ACG AuS*}A  ACs  AAA
A@I@I@IAffAffB@?vT+&K@v<ug+OC]@v;R?Q@;z}B<CQB;A3)5!AAAY@&m:Am
  AC: AuʁA  ACs  AAA\A@I@I@IAffAffB?vY+
f@v<6U+EȒLq@v;?b@;}B<öCOB;A3)5!AAAY@&m:Am
  AC, AuʰYtA  ACs  AAA\A@I@I@IAffAffB~?v]+Ihz@v<3{+<b@v;I?y@;B<fCMcB;8A3)5!AAAY@&m:Am
  AC AuA  ACs  AAA\A@I@I@IAffAffB~?vd*ڳp@v<Ҟ+2Ir@v;.0?p0@;B<CKCB;A3)5!AAAY@&m:Am
  AC Au
jAACs  AAA\A@I@I@IAffAffB~?vg*kA7@v<I+)v@v;[I?gI@;jB<CI$B;A3)5!AAAY@&m:Am
  AC Au<A  ACs  AAA\A@I@I@IAffAffB~?vk*H]@v<ώL+ $@v;-?^a@;UB<}CGB;}VA3)5!AAAY@&m:Am
  AC0  AujaA  ACs  AAA\A@I@I@IAffAffB~^?vr*ێ@v< 2U+;Sk@v; _?Uy@;CB<3CDB;yA3)5!AAAY@&m:Am
  ACL  Au˙NA  ACs  AAA\A@I@I@IAffAffB~9?vu*?@v;̞-+
-@v;
?L@;4B<CBB;vA3)5!AAAY@&m:Am
  ACh  AuXA  ACs  AAA\A@I@I@IAffAffB~?vy*ȱ&Mi@v;2L+O@v;?B@;B<C@B;r}A3)5!AAAY@&m:Am
  AC  Au}A  ACs  AAA\A@I@I@IAffAffB}?v~*Bpnl@v;΁*Kм@v;S?8@<	B<[C>B;nA3)5!AAAY@&m:Am
  AC  Au%OA  ACs  AAA\A@I@I@IAffAffB}?v*ӹ@v;r_*N`@v;?.@<B<C<cB;kAA3)5!AAAY@&m:Am
  AC  AuSA  ACs  AAA\A@I@I@IAffAffB}?v*e@v;"*i@v;?%	@<B<C:BB;gA3)5!AAAY@&m:Am
  AC  AûDEA  ACs  A
AA\A@I@I@IAffAffB}{?v*Kż@v;ӎ*wH@v;{?@<(B<C8!B;d
A3)5!AAAY@&m:Am
  AC  AṵA  ACs  AAA\A@I@I@IAffAffB}U?v*RP@v;ď*ԇtX@v;ڦD?H@<2B<PC6B;`rA3)5!AAAY@&m:Am
  AC  Aus<A  ACs  A
AA\A@I@I@IAffAffB}/?v*@v;T}
*@v;١?@<=B<C3B;\A3)5!AAAY@&m:Am
  AC,  Au
AACs  AAA\A@I@I@IAffAffB}	?v*$L@v; *9U&@v;آ?@<I@B<C1B;YJA3)5!AAAY@&m:Am
  ACH r Au<3AACs  AAA\A@I@I@IAffAffB|?v*};l@v;|*2$@v;תF?Z@<TB<C/B;UA3)5!AAAY@&m:Am
  ACd e Auk9A  ACs  AAA\A@I@I@IAffAffB|?v*s̴t@v;N*Iq@v;ֹ?@<`B<YC-|B;R'A3)5!AAAY@&m:Am
  AC X Au͙*A  ACs  AAA\A@I@I@IAffAffB|?v*j]@v;t*O_$Ӽ@v;??һ@<krB<{C+ZB;NA3)5!AAAY@&m:Am
  AC K AuhA  ACs  A
AA\A@I@I@IAffAffB|q?v*`C[@v;*;:@v;ՌBq?z@<pB<vC)8B;KA3)5!AAAY@&m:Am
  AC = Au  A  ACs  AAA\A@I@I@IAffAffB|J?v*W|@v;T*m&j@v;bB?u@<u&B<rC'B;GqA3)5!AAAY@&m:Am
  AC 0 Au%A  ACs  AAA\A@I@I@IAffAffB|$?v*N,K@v;񻓪*0@v;>ސ?n@<yB<nzC$B;CA3)5!AAAY@&m:Am
  AC # AuT/A  ACs  AAA\A@I@I@IAffAffB{?v*DX
@v;r*]B@v;"+&?i@<~FB<jEC"B;@PA3)5!AAAY@&m:Am
  AC  Au΂ƓAACs  AAA\A@I@I@IAffAffB{?v*;4]6@v;﹤!c*vݙ@v;?d@<B<fC B;<A3)5!AAAY@&m:Am
  AC(  @4o#^O={.j [J;w,hWG 8 t  !(!b!!""S""##C###$2$n$$%"%^%%&&N&&''>'{""#"#s#$$b$%%R%%&E&&'4''(%(s())e)**T**+E++,6,,-%-v-..f.//W//0G0016112*2x233g344V445F5566667&7v788f899V99:F::;5;;<%<u<==e=>>U>>?I??@:@@A+AxB}BCChCDDYDDEHEEF8FFG,G|GHHiHI
IUIIJGJJK5KKL LxLMMeMN	NZNNOEOOP5PPQ"QwQRRdRSSQSST@TTU2UUVVrVWW`WWXOXXY?YYZ1Z|Z[[n[\
\^\\]M]]^:^^_+_{_``g`a	a^aabIbbc8ccd(dxde
sFM_9{y"
[W~ h!!V!" "##B#N#%#;#"!!c   cB<xm
AIkX|)l/?d L-SR.K>;
X  !Z 4!	!:!D"""u$"9'$)%*(,t(0+(,*s-,A0,0/l103233(4R4w3t5Y251^73252522'2`233y33214.0.L/%+@-X*2*&&!!&&()+'[6*Q+c(#/".Q1,'/#%,9'+3T!#1	1(
')~/
$22')++**)E%Q"c,2
-&,"%!$&~ R*P z&#(% ,#%l+'+L %e*3M*g- (p%R'V#'/' ( =(*59$* ]##!#,"*n!V-0V,>G_nM*}%qIsF^ ,       K;~_kx @Cs=c(_.53PH<G5Z
rSk {  "O b%"&#(y%*:%)U&*_(+).5*&-,..0/00%1U1z0e2_/2.R40+2/2///R/00t/0/.1,.!+,(+(($%  9&K'b)M|*5i***(#.".#0&.#y%y,'+K3)!"1	''c)Y.#2&(++**u))%3"E,
,
,
!$&_ @*5 g&	($ w,o#%X+'+< %[*+6*Z- (e%K'E#'#' ( ((*6$$& T##!#,"*h!\-+U,	u#c<l@g: 'gO<K0@2n19aYb
ZL%q,z9u(G
Ib\w!/A$!%"u'1$($(	%<)&)(p,(,+>-y,/I.(/J.//.0-15,2.1+.f13.;--.'/u/	./.y-u0*,*+'*'0($$hu E&*'B)+^* 5X)*(#p."r-w0&.#e%]+'y+23!z"1	''F):.#2&(++**^)%!"8+
,+	!$&X 1*, [&($ c,j"%F+'+- %O*+4*M- (\%B';#'' ( $(**)$ T##!u#,"*o!]-)^, y* lR"]V'O
zCexXfBUQV"w,\hiS+u.{7pIN	k=tSS|rwa!$$P!%"U'$s($'%(&)(M,(,G+->,P/#-/.u//.0-j1,2o.1
.;1
.---/?../o.Q-<0}*,*+')'( #$Mg 6&3'F)/W*5O)*(#h."q.f0&.#^%Y+'m+73!y"1''D)=.#2~&(++**`)%%"?, 
,,
!$&^ ,*4 Y&($ g,d"%N+'+4 %V*+'*T- (`%C'A#' ' ( (*/-$ P#"!y#,"*o!Z-,Y,Jx=w 3s0RzZ7b8+b.IB9r
EaMPMp>Y|{hwP#zqEq"$x  #> i$z!,%#M'#O&#'%<(A&+3'*)+*-,X-h,-.*-/+/c+0,/f,/s,[+,,_-->,-,+.)W+|)I*.&(%&"#XcS&
'!)<*5))*(q#F."J-<0&.#>%8+'U+2!V"1e''+).#2ky&(++**K)%"!+
,+!$&O *# M%($ a,Y"%D+'+' %H*!*Q-s (V%@'9#''( (*&'$ S##!}#,"*k!a--Y,*d8>zD6#iTX|$d/C"7GfHG`9iXD_6jlpyu9S(noF*FL$mxU4l2M+bJ"e# I$"R&"N%"&$2')%*%)(T*v),=+,+y,,+-*f.)/+.	+3.****,4++r,|+l*u-(*E(")%'$& ""%' (*5x)*q(F#).u"(-'0&.k#%$+'>*2!="1\'')q.#2XZ&(+u+v**7(%"+
,+!$&B *
 F%($ R,X"%=+'+ %=* *B-l (Q%5'0#''}( (*%$$ S#"!y#,"*l!
^-,U,
-'GFRkbJZba/0IW?Q+m:@zhc-Tq}TAVXZga6#QB: :0qAo<pi!n",#!)%Q!%$~!%l"%$s($s(&('*)m*^)*+), (,P( -),,)`,8))(()
*@))*)(+&R(&}'$&Q#$ !kjU%'a(*j5P)*R("#.O"-0&[.=# $+'*2!"r1d'~&(S.t#2=M&(+Y+f*i*($" +
,+!$&: * 2%($ @,L"%,+'+  v%0**?-\ (M%0'#'
's( (*$ F#"!t}#,"*e!\--R, W'! dnxr
j|C'*Me+y	d2W"{'hEt UMx=[1bgkk"4QWr@,BX|2r"M#N$!&?"%S"&G#&%w)%)@'*)"+*++,=,+Q-a*-)g/'+5-*-**9*g*+++6,*+*!-[')'(%K'$%!"p%'x(*5k)*x(I#.q"'-%0&.d#%+'5*2!:"1'')l.#2Qa&(+p+|*|*-(%"+
,+!$&: * @%($ O,Y"%:+'+& ~%:**C-k (U%.'-#''y( (*!$ G#"!o}#,"*j!
[-'U,GP[cw\P^#c0=~Mg7
1T^	L'Z~D;k.Q)_aeu]"&83U@`
]7]J!8i]!# $H!%!%"H%#&z%,)l%G(')(+*i+i*+,C+-)-)..*-x*-*w**5*r++U*,*)-1')'(%'a$%!"I%'} (*5s)*p(B#.h"-"0&s.`#	%+'&*2!+"1v'')c.#2H\&(+n+q*s*(($"+
,+!$&: *
 ;%($ K,P"%3+'+) x%9**H-g (L%-',#'
'v( (*!$ K#"!s#,"*i!
Z-&^,-f<I(eT3KIw+<GS2F^iL_:d^Vh=l[Ib:hiqz|4I$[j3F;"On<2o,#"7n#f $"&O""%x"&b$&%)%)W(**)D+*++F,[,+p-{*3-)/E+\-*-**b**+++B,D+.*?-u'*'(%c'$%!"%'v(*5p)*k(J#,.o"'-,0&.n#%$+'4*2!B"1~'')q.#2Sb&(+y+{*|*0(%"+
,+!$&E * <%($ O,X"%;+'+( u%B**C-h (M%5'2#''|( (*!$ H## !w~#,"*g!
`-"],3uL^= |8^yrN`gx)ZgsY,2$u1i
p
Ks	dKd=mku<N'on?!F^<XsA#I
$2("Mt#g $""&i"$%~"&v$'%)%)f(0*E)[,*++O,,+-*G-)/^+~-+"-****,.++d,o+c*M-(*E()
%~'$%""%'(*5r)*s(R#'.|",-20&.k#%'+'5+ 2!B"1'')u.#2Uc&(+x+**2(%"+
,+!$&K * <%($ V,["%E+'+# {%C**B-k (Q%0'3#''m( (*"'$ L## !t#,"*o!
c-"[,
<_zXGc&N' )nIYqxdg@5o*.|4b+sIqvwPfCS,HCmK~pXXAv:^O2"# %;"&"%#<'$'&)*&W*(**,+,,
-:-o,G.a+.*h0-,0.+.++D+f+,,,9-4,+.U(*()&(C%&{""6 &'!()*5)*(W#9."8-A0&.~#&%.+'K+2!J"1''%)|.#2`n&(+~+**7)%"+
,+!$&P * C%($ V,]"%A+'+$ %C*"*H-m (N%0'=#''v( (*$$ N#"!r#,"*r!g-!Z,
5rPdB}7\wkSko.izx3JUBM*"`#u'W$mFsqx~LS.|t`<IRgIqgSK<u.U83"# x%'"&"%#(&$x'g&*U& )(*),+Z,n+,-,,.*.b*/+.N+.]+l*++D,,:+,+*.(i*(i)b%(%G&@"K"
%'(*5v)*~(W#..}"5-?0&.w#%(+'6+2!I"1	R''%)s.#2ag&(+~+**/(%"+
,+!$&K * A%($ P,`"%B+'+ %C*!*A-r (D%3'4#''v( (*%&$ Q## !o~#,"*s!
a-&U,5xJb?p+Tjb
?PUc>Urx^kHu%j#YnBjYH_:imott=;`Lq7G'27^%,a
"E#C$!&(!%N"&8#&%^)%r)+'))+*+*,,I+*-2)-~)1.+-w*-*w)*)*^++F*+*)-')'(%
'X$%~!",%'r	(*5m)*`(>#!.]""-*0&v.P#%+'#*2!6"}1k	L''
(\.#2JV&(+e+p*u*!($"+
,+!$&; *
 4%($ N,T"%8+'+ y%7**6-g (G%+')#''m( (*#$ U#"!i#,"*t!d-(T,.o%t_)-gxx4{#{   _V^	4%FJvI?F sGlCiBPaftM!$E!%{";' $j($'%(&s){($,(j,3*-%,(/	-..P/q/.}0-F0,2Y.j0.0--n--/..Z/Q.3-0G*,*k+Z')&'#$BHI&.'B)/S*5D)*(#k."c-o0&.#P%T+'Z+32!m"1	.''?)*.#2u&(++**F)%"/+
,+!$&Z $*" J%($ `,e"%=+'+) %Q*"*B-k (V%7'6#''v( "(*!'$ V#"!x#,"*e!X-(U,Vg+I[?nEcRlK44
P W  !    gJ#`kyFFo;g$`/(-8}+Gie
 @c=,1W Q  "$ D%{"&#(T%*%)>&n*G'+).@*"-,.. 0/00N1a102/U2.4_0x2063////1200m1[0'/21,{.b,,)7+G(_)$%K N V&I'^)Jx*5j**+(#.".0&.#r%v+'+L3!"1	 ''^)N.#2&(++**`)%)":,
,,!$&` .*. X&($ n,o"%K+'+: %]*4*P-s (_%>'?#''|(  (*(-$ O#"!~#,"*r!g-(U,9~"!Aw   !&!"""""""q"!V  ` /Q{oltEEy"3XIs[#)^
8<*H2tW-   G  !G!!#*!V&#($)'+q'9*'+)d,}+8/+/.b0/21213:3i2X4d140b6(2=41411C1u13 2273103.0	-.w*,)*t&-&e!C!&v( )}+,L6*D+_(#.".O1&'
.#%,-'+}3A!#1	(')t/$2'(++**)>%S"\,!
-,/!$& I*= q&(% ,#
%g+'+J %d*3A*b- (i%P'W#'+' ( &(*81$' `##!#,"*u!	s-&U,
YbbI0 U !! z 4 !F  !m"x##z#$P$%_%%%m%%K$$#"""!Q e^Tn59s	&>2<mD

&4\eAis|J! !X( F!"	"!"""#$.$+%$)w&+,',*z.*.+;/&-0^/'3/325&4O7B6!7e688F7<9959l5K;
7>96966`668277m827582422.0-]-)o)o##I"&(]) +6*+)U$5/n#,.51'/S$&
,(+3"#n2V	Z(c')=/T$v3'c)D,,"+ U*$)x%",a-<R,V_"!$& y*q &A(%& ,#2%},( +h %*J_*t- (|%a'i#'=' %( C)*FL$, o##!#,"*t!
k-%[,\blRJ q!	!.!  I !a  !"#E##$}$%%%%%%u%$2##"""+!t yuNF(?3CoH
!&5]^}2[adIp= !!"!["J""#n##%#)0&*',*
.l*7-*.,/.3A/F3B2$4365x667e7685884:O6w86U965557g667l6348231J2.)0	,-j()#|#X&(R) 
+6p
*+y)L$&/b#'./1w'y/R$&,(+3"#j2P	}(^')0/Q$m3'e)9,,+M*)x%",b-6I,Nc"$& o*t &K(%" ,#-%,( +c %*L^*t- (%c'p#'@' )( E(*LG$2 u##!#,"*t!
k-*_,!M_   6!i"
"3"!  !A!"g!!"#$`$%%&&&'&&&&;%^$$D##9"}! eWT>|{q-r lb*';;<z	
 J,6$  ""#"#m##$%0%;&%=*(,f)/.(+03+/R,x0}.l105@1L5N49658788R998:7q:6<8;*8;B8M778P99=898k7:#4533/1.l.*S*8$$.^&(* 6+6@*+)~$K/#\.^1'/$,&1,(@+3"G#2s	(~()R/$32)')_,2,;+2n*E)%",z-Jc,gv"5%& *~ $&S(%1 ,#@%,(
+r %*Yh*- (%s'v#'K' +( N)*TU$5 |###!#,"*w!	r-&[,	TJpM/UMp^eC,AB @  !R!"8"^"s"Q"e"2!!   4e9miewIJ'8]Ptd+@e7\@jeOIbZ+0m'>  ! K!4!q!u"P""$D"v'% )Q&+ (,(+)2-(*.,1l-x1U0;2143`44
5@5x4e6s362o804L64633o335@44s5V4.260-2/}0Q,w.e+F+''"u"t&(')+Iz66*t+4)#/,".t1N'5/#%,Y'+3f!#22	?(*')/)$D2'8)++*0*)S%j"u,>
-
.,6>"$& b*V |&0(% ,#%l+'+N %y*8H*d- (t%W'X#'1' $( 5(*@B$) h##!#,"*w!n-%[,E
u
:y5yIl46kjS&T6:q@	@
E4FC6(k]
  	!$"&0"'%)j%!(%)')*B(-_)K-+.--/.//J0y0/1.?1-3[/k1/91....0,//}0_/F.41m+-+h,H(*'($$ kz&:'V)Jb*5g**&(#x.".0&.#h%t,'+D3!"1''a)V.$2&(++**g)%>"H,
,,
!$&i 8*; X&($ o,s#%Z+'+@ %]*+5*V-~ (\%K'O#'%' 	( )(*+8$ ^##!|#,"*t!g-+Y,lkK~D5q<$t#H'rRwM][J"p'|9m
Fc1~_;4xQQ\=s 
$.!d%""&$X($r'$(&^)i(,v(a,*-,#.-..9/b/.{0-30,2E.P0-0--P--/	..S/G.$-*0T*,*t+j')&'#$<K;&+'G)6X*5K)*(#e."q.|0&.#]%_+'n+43!y"1''T)B.#2&(++**X)%3"7,
,+!$&Z 5*2 M&($ f,v#%U+'+= %S* 4*N-{ (X%E'E#''  ( (*,1$ S##!~#,"*p!
e-)W,{> 
q={7wC n45rr#R.V
/8m>	:C5G"[~tH!in$!%"'n$)7$(N%~)G&*
(-(,+-,/.z/.0!0O/51;-1-@2/1.1...<.s//s//.-0+?-C++(;*`'n(N$1$ >[&:'Y)7e*5_)*(#s."w.0&.#c%l+'m+A3!"1''W)E.#2&(++**Z)!%."5,

,,!$&d ,*4 R&($ n,s"%T+'+2 %[* .*O-~ (O%G'@#'$' ( %(*.1$ V##!w#,"*m!c-(Y,H
~!	I%G-`U_"ML19sFr* EPuKAJ!:F61iH!ez$!%"'n$)"$(9%b)E&)(,(,+i-,/s.:/X./0.0-11,2.1/.i1J.:--./k/
./.-r0*-*+'*';($$g{ U&?'K)8Y*5^)*(#|."q.0&.#b%k+'u+A3!"1	''e)A.#2&(++**d)!%/"7,
,
,!$&i 2*9 Y&($ k,y"%Q+'+< %S*))*V-| (\%J'D#'' 	( '(*-)$ Y##!r#,"*t!c-"\,_drRv {"avyD9  ; G - > $V\,Cf^v(u2h5_'Z1&-ZHBK?	7P QA 
 \ S!%6"l&#J(%|)%(&()'*)m-)-,o.-0/c0{/11H0:2<.2~.<302/2//-/M/000.1/.2,N.W,,)++P(R)+$%F M =&U'f)Vz+15y* *+(#.".+0&.#%~,'+X3*!"1		''m)P.$2&(++**q)(%>"@,
,,
!$&q :*? [&($ q,{#%[+'+= %_*#/*^-| (e%N'H#'#' ( %(*18$ \##!|#,"*w!
h-'U,
{V	J`@p^[zj	xHef-vy  )  (< F 5`Snm/c+ZU)!",dH,\U#Ld7c` ' r f! 
%A"&#Z(%)%)&6*'*)-)-,u.-0/{0/1'1V0A2?.2~.E4
02/2//"/S/000*1/.2 ,N.V,,)&+3(R)$$%E H F&O'_)Tz*&5s**.(#.".+0&.#{%,'+T3!"1	''g)U.$2&(++**u)(%6":,!
,,
!$&p 5*A X&($ r,}#%V+'+: %^*"5*Y-| (`%K'G#'' ( ,(*.=$ \##!y#,"*x!c-(X,vTQdG}fhwXuwE;  7 K ) @ (X`.Mqe~+}
9n8f(].))5a1Hp\)n*${\~s 4  " #%Z"&#r(7%*%)&S*+'*).)-,.-0/001:1}0_2Z/	2.]4092/2//F/s/000O1(0.2-,h.q,,);+[(n)A%%a G S&L'g)^z+.5v***2(#.".21
&.#~%,'+^3.!"1	''m)Z.$2&(++**q)&%?"C,!
,,!$&v <*? d&($ {,~#%P+'+B %_*.4*[- (]%W'D#'' 
( +(*12$ _##!{#,"*v!
f-&S,HWz7x?#T1LC^@9=g " { !#!5!!/   ,gBl'CD9yGs^GqGCSra[G/i[QT L
 
  !1!"" &#Y'z$<)&u*&)' *(+*|.*.-/.10112M2w1\3]0
3/Z51%30300*0[0111+20/2-3/',-),))%% !%&f')e+;5*0*B(#.".C1'.#%,%'+n3<!"1	('y)h.$(2'(++**)=%M"R,-
,, '!$&~ D*I p&($ ~,#%\+'+H %i*+E*c- (e%Q'N#'#' ( 4(*7A$ d##!x#,"*t!d-'W, 'i'q`6Bqo F q  d w LWOI>Oi~;EzBp5c85;S6.GE{-[fKS{ p  "G a%"&#(%*L&
)`&*t(+;).X*F.,/.&0/00T1102/N2.4^0m202//d//1"00[1K0/21,v.{,"-)G+](e)8%%] ] N&['l)]+	65**<(#.".01&.#%,'+`30!"1''l)i.$2&(++**{)4%A"K,#
,,%!$&y :*D i&($ r,#%c+'+< %_*+>*^- (d%Q'C#'$' 
( *(*54$ U##!}#,"*p!
f-&Z,:A\bK"-vSS4s B       q`:H(.)j	>e
Z~BlB @ksxGM-zw K " R V!!|!#!(&q#'$)y&+I'*O'+j)&,K*/+p/M.0U/v2J12M1231404(/514O1r4Y1701 1;221210[3y-/-0.*T,W)M*%& !Y&f'{)m+H5*?*K(#.".E1'.#%,%'+o3>!"1''})q.$2'
(++*
*)A%H"Y,!
,,(!$&x ?*I k&"($ z,#%c+'+; %d*6?*]- (f%Z'H#'&' ( 0(*57$ V##!#,"*n!a-"Z,)/@D_@nCO1        3%!cy	Y-\Nv>j>:Hc~KDEw;1vswv    "n %#'<#(&2*&K)&*(a+*).*.e-$/v.1U0+1U01202/30.403F03Y0J//0511/010/s2,.,v-b)+()%\%  b&\'u)e+55*.*@(#.".;1'.#%,'+c3;!"1''z)j.$2'(++*
*)<%B"O,(
,,)!$&y E*D d&($ v,#%\+'+A %b*4<*[- (_%U'M#'+' ( 4(*54$ U##!#,"*m!a-%_,
Zj3Q!rZ o\yyf q !Y!!!x!!`! [|9*alzvc<i+y.XQJ&uzFj7}} B $ T N!!q!u#!0&d#'$)V&+3&*Q'+j),3*/i+_/3.0I/c2<12;1221304/514)1_4=12001"2v2121l0M3w-/-N.*W,e)_*+%&'!!R&m(	)u+-M6*H+X(#/".M1"'.#%,1'+z3V!#1	(')/	$*2')++**)I%R"],+
,,#5!$& H*O r&(%  |,#%k+'+I %e*8D*a- (r%Z'R#''' ( <(*85$! ^##!#,"*r!g-&],hzA$n5F$.H* 4 !
!!!!!!!?  q_0xQ}C=kT""P.(EzM/   t P  !W!!#J![&#($)'+'7*'+)X,r+;/+/.J0/21`2133E2#4'04\0514t141y01-1b22P2 2103-/-r.Q*{,)*F&&K!#!l&v()~+&S6*K+^(#/".R1 '#.#%,8'+3P!#1(')/$,2')++**)A%Y"a,0
-,':!$& O*P v&,($ ,#%g+'+J %n*2D*g- (f%]'V#'.' ( =(*3=$( W##!#,"*p!d- _,
qY%k {!n`k  Q !!w""*"E"":"!   J%WWXk@Ax3YLvb*	?b B-ZV6FY"*. hm !*  !!"3"0#!'<$(%k*C',4'+:(v,Q*-3+0r,j0H/#1f03W2G3c244 3515>1625S25[2b122T3382321[4.0.5/+*-1*'*&&!!>&()+6T6*Z+l(#/".a11''.#%,G'+3\!#2	(')/$32' )++**)H%`"^,=
-*,&2" $& M*W s&'($ ,#%m+'+K %k*7B*f- (p%Y'U#'.' ( 4(*82$# V##!#,"*}!_-%_, oU3 ~IV6@0R$7 = !!!!!!!!E  *q\.xTy;8a	V+W0
@,G}X;  &  e  !c!!#^!m&$(3$)'7+'P*'+),+P/+/.o0/2122 3(3]2B4F04z0?52414111O122o22103-/-|.]*,)*c&&\!6!|&r()+D6*M+Z(#/".R1'.#%,+'+3D!#1	( ')u/$*2'(++**)5%R"S,1
,,!&!$&w I*M _&($ ,#%a+'+B %c*2E*c- (f%U'L#' ' 
( ,(*9-$$ T##!#,"*w!X-%^,rP0KS7>5Y-F  G !&!!!!!!!S  8o &*<YD7hY$\*1&H[=    Z  !S!!#K!b&#(!$)'+l')*'+)P,g+/+/a.#0l/2X1'2N123 1304 /5141c4!1%001
2]112u1J0&3_-/-$.*,,F)7*%& !I&p')s+B6
*B*U(#.".Q1'.#%,4'+{3E!#1	('){/
$+2'(++*
*)<%U"V,7
- ,#,!$& K*Q p&!(% ,#%o+'+G %k*;B*g- (n%Y'S#'0' ( 3(*8.$ Y##!#,"*s!a-+\,nQ2|FU4=+U*> A !!!!!!!!N  0}e!"8!W}G8c[# 
U.:+GeV !$ 7  k  !y!!#n!&$(E$)'M+'f*'+),+Y/+/.0/21223A3x2d4\140d6 2341411<1b1222#3103.0-.m*,)*r&6&^!B!&v()+,a6*S+h(#/
".a1+' .#%,>'+3O!#1	(	')/$-2')++**)N%P"^,9
-
,(9!$& K*X o&,(% ,#%m+'+F %v*7H*c- (i%['U#'0' ( <(*<;$# ^##!#,"*v!
\-2_,!*5LZ\lp",097HEJPUZ\banhnmwuvy}xs.>ci	**MRX^kx})-7C5FESNbme&&(KM>4:YPS[dangbsE[7y& '
3N;\3*}f2mP\b	 	.	W	
'K	?
q|	P	Q	A

H

	u
   
4 e	&*C?KOhcrx{" %&*'K#R2;DAHRVValz~M (2]Y|$&5K[`hvmtuw'#(?JPX_epvz{#/f5[[4;8(/GV,n	Udh!Z#z9`2J9d3 RcO]m/n{{OAIFt%O4%U	(o3		=	b 	`@				
~ g~ H62>DGQRm[hpv~&08?LKbj|5^V`]`qi~~%!%&*89F\ekrlz| '04A6NBTUYuynhhE#2KhpSj0Qd-%QPc4~@!)2dmNT6b	&cG	j	5		g	
 " vE72@FHSTo]jqy
	'-=AIJ^gs/TTXS\ibuw
	 '$2/@TVdkdop~+*3.E9JMSlrd]by{v6"	
(<0Kp;fBXr)-tHAtI6r7w}]&UZ
nw	?	c
	
]  	e (cgz6%29?FILSZcelkyvz (-HQ`V2%230HIbebku
"'-64CIDumvv&6./7?@LGETwclxsk,=k%LB\ yJOMRk{ 8UP	6or|tpU*	Hc	6	1hw	PEUZks	"$+148?FNOVUb`cinqtxx$4?d5%698ALRP_ihp
92<;LIQgtv}
3#.:>-IR(vXh-qdl\PrdGPf~xn`gzWhYP5x[R(5DdQ_A<aoA.XH8Kl8VB6d@]	?.

a	 	~!	?DU[hnw#),31><?DHJMRS\Y^]fdhjnlht}.Ro &(09I\W^l_hgkwv%'14;CLNXTd]jnpz}G)$
!5.B./]5k  l]~AZlAk
	e)+Bf!^v@)m	`oRi
>	 g	P& QUhnz
%,/2:?HJQO]Z^cgjmqr{x~} )7T*l	#&+,7<AOQX_n{ ("*+=8?R_dnsz$+,:Fx/wgIX@\FskNiGcx`hPBzdbNP&_{Ffg#M9e[U7Kz$(}E o}A"kMb	9C?
H	N	 8~dEHM_eqy $+19;A@LJNSVY[aajfkjtsvw|yw&Aesz	
+298ALWlgp~v}~/)/CQR_elt
!28
h=gHP8Q<5ah>^4OlrLEGr?mM[UgW_YoJP+
PA; !M.6/2KVsv;(]-y
m		  4! Z_sy

/*17>@DKRZ]caolptx{~.9Xl?
*.7.=JLS^^km -#//C=AYejsx'",0CN~*ldQJOSWNAcikefgebW5swnD'#e+Bn@oQ
yJoF3i4E8K`7_t	I	
>um{	> X[ou )$+28:>EKSU\Zgdhmqtuz{ /Gd1 -/5<ANNZ``fv.(14C@I^imt}  0!'69)MR'WqdwOhUf`{`nht_m}k_o?kvH,":WGG|@o3<W+2|7	z[3n*54oR	F
j	b"]bv| 	2".5;BEIPV^ahespsx}'3>QnB	&.?JMHT`ditv 
&$MGPSdbh~#!+&#1SEPW_PnuE
pA~q|k{} R)f["M}='QjK3-ys$2Tz*S#7	2	

!	F<d !]au|1!-4:ADFOU^`gfrqtz~'2>YM$#6'BGLJM]bipt	"H=HHY\bv#B5=HP?Za9{\,z{|Vt_k_zyzptv<
-ifF=?W*IUG_6~U4[Q0B^57n
&c^h	r>
=m		v3~ $\av|
/)05=?BIPWZb_mjnsvz|	(5Of7!)(51ADLSYak}!%%649MX\gho{
	+-}u{XK=B;>?3mZRNM#8`]=9}y=qt2h96"Mc@t DR18~ByR+!3T@/`	G`#.W	l YO	!'*C?LQT\^zgt{ 
'04<CK`as	$lJTR^efr}-);MR_`]lmzx	  /%>2DELel[VZ}pt{qH

 QD' Si8%=hY|5hoi2jq^Jt 6t_[	k$n		$m	
 
Z  }
- Em  "16OJVZto}!!#$)'M"R1=BADPVU\hv}L!560@\6KJVfZdejuw$(@MQ\ckq~&1>]3MOG2)9:WW<Q[-/h1Kw4ft#>:sCk Q)W'n/#YM@I kOtF2#seG	1	
q	z} '?KM^b~y$"2/4:?CDKKWRWXaacekeao|$Jnll
#1+=GKW]fo	
(-'`Q^]rnw!0&(0=:H=;Kr^fznj'@&i}hZ?0qK4`I7m970}x	$		tJhO@	kf	Ay	|		n
{
"
q
bC3}	 6>Q[h	:"1;CNPU`huw~ /1A?`h{-,G
5`b]]sz.JGYg_dhl~x2$0/GCKiu~#&12B:3Dt]c{mo4A}Tsk	t8kCyO_GBGHb	m	z	O	
		
'	'	(		
B		L
		"
O		n
u)	
`
"	b
8@S]j

>&6AISVZeoz} 
#-;DEap}>BU*vAWL^gn~
5:ERJOVUefx*&.NWcisy 	I5BT[DoAb1`yZXkxvO<uMG])9Z8	b	|	t	N	
r	
'		+	fj
e
		=
	
	`	
	'T|	D
S
"	j
,'5<\ey".6:GHmTdox	
=	C)415CKHVbtu@
 ';o!59BPV`x("<B:n|{
&$,OSA7<iZ_hwtwt\~#6Kr+_+D /GLRn+	}	;		
%				@	%


u	U
		<	H		

&	p	L	
6
Z	:	p

|2a	( 	%1HUWim	!,.65HEIOU[]eesnts~4Ja{k*+93Zdgmu 	6:IOGZ^khz~%.1A4NCXW`umn
 -,BgKs?Y~ 7JPSwko#m*	,XC	m		0&	JL\		
m			=	



3at J"&?:GNQ[\wfrz%-/1<ART_bt*H~^phr $'0>489CMN`ov%+4;EPR^Rlassz|3:;'#1*L6+097t'"'O)m #,v,^IDJJ3!K]u-t9>L|pqQ/	|mO	frrT	M
'	
	1		.
!	D
 B	,(5:=GIcQ_gltw{"*4=DJZh{
2mMGOXb^gu	%$6LLWaUfhst	* 9-@@E^iYPVtmryp8";67KmP]	d*"J*]} xw}21)08T/RWNEj(f"` 		
$
P		
	M
o	J"&>:GMQZ[wdrz#)..9AMSZYqy	OzO`fomv*3$/27EBTfnsw$,5=@LA[PachzuuZ2A#/&_"EMH	TuCk=2-JJQank3->L;E0S	3+	0QyT	|			0	2)
o XL%*B?LSU_a|jx ' /!$%/84CKV]bi!	23]fyow
")=+13:FGShlw~u,16?6KBTTXr{kbe~~S?	3+I	BS[eY7`K=1j>i*fwY7R0HkpQP!}M-m	No 		2
]!~	 S
").FAOTW`b~lx)2%"*68;EPZ[kn	<@uxt"67@QGMPTccs-8?HNW`ko{q~!/;A`SWa<GLdVUs:IqCt;COI=Ln[yIY2%hvttC{#5KWd6	KQM	?	0o	q1	+	5	
#	
	}}	 Q

'#-1JFSY\fhq
39$,+1=CBNWdftu(H3H{
)?@HXMSY\jhz3<@LSZdmp{r	!/;m-N	S:H2;=Z]0u/>qm@Y/|IuE/9:gfq}}0j/ -YJB2N.>GWp	y.T]	o	+	o	;
=*	<
 P$ +0HCQW[efo}
3<%/-3?DBPZejzx2!NA`}"-GBN^Z[^`nr8@IPW_gtuv (3C	d1b RYY<@`ReZu:]`YD`u\S9K$[8XX.-*hv/]QzLi	04^|{0		S	\		m
=
i	11
  b%*D?JOidry| "!+*-153Y.b>ISSVbjjs{2V//B=bp$+3=EIays6+43IDLfnu}
@18IV?bl9k0voylczets ukBr\9d@IX7dy,yX	N
	 m	d
x	jPc	
W{	!i 	B| bX0,7;TP_egrt}	"BL+4A?AOTTalw~"C#NVn	!$6DUUaodmpr*$*CLT\eju} &:BNo^jj@jIlyJGm|ZsI`bV]G bf~17.2-8gOi1XNLP	J mn	z0	s{	J1q
x	
"	
eh	1;	i e'+D@KQjftz~$ &%0047>9_6iEP[Y_joo}
5l1EHnj$'2=DORdr QDPQe`g 
%%0&$2XAR`dQuK!}B`y{yqdzuP2BJ.S6E<dYdD	"		C	'!	M
	Jap
>{
	
E
q

v; Y2-8=UR`fisv 

 $"F O/:ECFU[Whoy*I%=`r %&,7Ieao{o}y~%#&939U^cluz.$2;(NV'r0}g]_gxdZ~bXshp{n='u14M@-@={!/+i-^{			/cq	g
.	J1P6
g7

(
Vve
'*D@KPjetz}$'&0146;8_4gEPYX\gol{#.a:1d\|$,6:EPXbs  M@JKb\c|
$ .&"3]FQcjWxTTx#E!h[<`RfzmM0wEJn	(	.	jw6	5#c
tk	xA	J
V{

 	
	,
!0	h	i /3NJUZto~#$2-43>>BCKFmBsQ^ggkw0WJ2Dbt!*,7ELTYgl%-(\M\Yokp$,+;0*>dS\js^\)i|t=f
6J$q1x|Y`x-z)		y	wE	O	"
[}	*	*
w{
	

8	
[ab 0<?NSniuz-,17=BDLM[V][ffjlspn}.G`	$;?LKWdnv )--@8LUMv48+ 'L@CKXXb\Vg|DZK;$=yFc*@skNZ[z	&	`	'	c!7	
-u	xf
fz
Q	
	`J
6 vy%14DHc^jo
 '-25;<IELLVUY]b][jx~/Lca`h")2.<KPXdlr  *3/eW``uqw%(20?51ChVbswgd7kO@lu [H\1P4Km			~	G	
w		\	


   s(+:>YU`f{#(+13@;BBKKPRXT|P_lvux
Bfl\vv %28=KI^cis#(%ZJTThci	% ,SBH[^Mn{H O{ S#H14deN^DwlVo"	 	_	M	
"v	T		xU
U
Q		s
v}d q'*9=WS_c}y$'-0<9>=HHLPTPyN_krsu&?S^Qqj%)05BQPaeh},7/hZbbwrz	(!"*75B:8FoYgw|kg 1tpDu	9x,|vfCr4	[mR			'#	}[,7	
r|		I%i	D	 g
	 R~1`		F	l	x											{	H	~				}	o	R	K	F	'	!		qSA(Z4>#"
'^
3K zxg_RE/
	wkiWPA3%"xbYTB@3>'~ndJ!h,
akkpMS;>21+	~rxsggfVo@yHGvtkJuK2370V6)d0&  H = 93r h   G  !<h9Ziv{xLy}tYUP6/%u]L/ |xqgPCD$%C)"%00Dc~	=Dxey>5"vopod_A/-vnhW_[NG>64*tiUJFLD920# ${uquYk0;G?*
}ly~mvqja_ebVFmRUpFT-`/1fe^)a8", B	=
	2  
/ +!B 7 Z   C  
:c~qb^VI:( rf.
U-K
nue\XH2'yna`WH?HE71)% tvvkgdYPD5($("w{tlm[Oa@L# *,	p^irx^poib[pZNZTFCi>;i9<T$fT^&N2 8 $5   
3 
     f  }<ayhc]Q?/%tf0 >,j	re\SN?)#
 wmd\XMB6<?.& 
{popfb]TJA0$ &
{zyomeWS_DE&.q_lyyo{^vZmn`IcRW=fD@a6G$O2&[^^X/  =& %  A  3      S  w@e 
#!-*-(.-%! ~xePD5&{u_RY87MC0/CKGadk6eQ{[CUF*:72-zzm^QTRKB@8/*vvnseSK?AA73-&zZ``RNEC1@&*	xvYJy]]oLqU_OX^P:PDK+]:8R69 DQIOT 5      "  	  < (  S  !qC%Ss~}tk^NH@+qZbLSWLO?2)$
$
&45c\n=L\N?vswlkhK;@0& vp^ZVKHBH8) 
vl|`c?>=;1$*%k|pmvhayJ>mMN`GY?X>KIB,4<@'H/$P0/B9M=   %          $ (    C  (%Og-JVasxsjv~}~}nMp~xulYVS=94'teZO"
8-}ynbWA</(2& ytndkj^[RNLG:4' xdIA~Y4EykT|ifT`QTb;m-X:?J>E5=14>:+$+:#
@	 $	2&8 9                 )  m    7  d3@f~qmf\M>6/eMUDGGCB5'!
")IKWfE"xqaWYYXR3%&
	}yjdTPK>?7>/
pg}Nj2:23&)	gqvnjdfrECcLD\E[IO9>P:0;53D! R,,=5;?
 
   " 
           $     C  !>v=]x{~kd]TCB;1!	xn>$/"",V)@$"rWSH;F;65ytrp`ZJHC7606*mavTc2-5&-|`qreab]jF}5[HBW9OIB6=F:&4/)"8%F#543; F                  3       f  X$Hr		zjc]I2&
mvcee_`RH:?"9#%%6=^pkISOlD/zqWjaW[9.0# {ngWROBD;A3#rhLu2<=0*$&k|wlmkfrQ;hRK]BR[LCHLE.A08+L- P-
00AJ?             ) F }  "  b  zK<d wgWMF2 vVbMSSNK9)& 
!	 -DcWMEdzuT7}jbfg^XA54$ 
	rlZXREH>F6)	 uk`o6>=@,.+nwtsjnvN<nVL\JWXREIOL(B08!S"*U;5$9BD=
  *       (   .     4  [  d0X%#"
"!vlfS>4!yossoj_QDE.&D1$$"-=>EStqlWjddz_H"2xx_NU?7-(.  tol`^T]N>6*+," 
zkHMHM:60-7sw}oy~YCyYZ\W[`PGXTQ;D8G*S;*W$5A BBCF  )      3 	8 !  K  W  a+U{	zrlYB8&uyvsrgTLH30D6#''5>=Fa6:Zr?'''}{xZKM=7*+(!|jebVUKSC6, !"	{ub?BGB/3#$4 m{pos|TCtRWbHXXLNLVL9G6D&G."[7<$EBA
<	   %       #   )    (  C  b+P| vg_UC-#hsY_bZTI8,0.	!-7Pf`\=YV
	|tdT`WQP9$ |wxqd]MGD7:07(h_|Gl#43('"|[vm[m[\lBw3jBAV;NV;<:J;"4'9>K) 5 603 ,    "                  9  ?  	@8@q


ywl`O=1,|o6M5jsfaQG6!
{vkaWSJ9077,"
	wlnkc^ZQF:+!
{vumg\WIX8H$&c]|_jp\llYVPb\@O@J1[97b*0M#BWG=
  0  1  
   %  ! m    C HJf>fotogJC9)yeS/$~wsbOFD ?(!(53Ecy	YM%8aq6;	}w[V^VPN,
yxmeXb_PKB<62!raRMUL@=7+!+~|zmvTc33A; qgpt|w}mlgdrcK]P[B^KIp:C'S6.ThG&R#1 .    * %+ L    K  C  )P)R		8	G	W	j	q	h	W	f	q	n	k	j	L		M	a	_	V	O	<			paW={4 DY	glpZVRB/'uw`OH=C6+(zxp^V@:3$! |rmk\Q:a![YidHE14)" "~hnmVf`OhElTDosk9m0<(41P1"96  &C 1A L@7     C 4	"	M			

M
\
m


y
l
x


~
y
_
&
_
t
o
e
_
K
,
'
										o	a	U	7		ocpmg`Zbft|&	W
bpbaWA@?2bIJ5%
thaNZTE<1*'uvujd\RE8 Uq/,,"yRsnbNqFK;*$1(.psoe`]EMN9n5WAo./Q8*FXC| Q0U   b  [  3	,	V			
.
X
j
x



z





j
5
m


y
n
]
=
7
/

								}	p	c	F	'	~lyqxeedtxA	ywd]OID*-0}vkJ05	sgln\OH5C;/#}n^]^PMF:-}rIp )! yNojSKjCF6&!%&/{oyhc^SNPY/s.^?s =\/7SfUW!d*7   b  j a	i			
#
b


-/##.*)%








u
[
V
I
<
!
						}	i	A	-		 n~XcbYO9
$Z	 k~Vrp^B+xgabTG?1&xia^T<3zk\F6-8*}QTPK,2$#pqfbaP??KM&J}rn`^ic77bU6FkJ=bm RxL0     [  EpNw		8	d	p	~										y	I	z					p	T	N	H	*	!		~cT:'~VfIQPGA2	 4A

=vpDytlQ5-
xlg\M@;1	 }xgd[cO:-	tIC4%zgdNL!J>*@ 
zw|iao[s_JrCpH<9>3ZV&U(E%$ 7M.b $ 7   s  [0 *%)Y xn]LC='S5B(12-$!D{`;>}~vcME3%-+#z|pbT]]PIA3;:-%ypf\J>9?9.&$zwgr^S?28D

o|}yvtlylVkPjTj[KuFW+Y>6dh^'[)&,% E&> "F E	7  K  S# iEhslg\LI@7'vla&.H }zk_TL@/tpg[TOH8,45'!	tjijb]YOG<* #
	{vgbfUbHC(-0tcyq|lwrdn`t\SaD]AbP?yAP'O72UZM&O$(# :*   * %//7   ?  K *#)Z{qaPG>)R1?%+,'"	2^JI7rxfYB4&"}moeSLRSB;3&0,	~~wqldZM<0-2+ ~tscagLN0$2= vmtorwmnkgogIcIX?jJIu9OS6#ReMQ)& &
 D 7  #  ( ' M   4  S 	3/
4d		 ve]V=%gEQ;BA8;' .Kr!) dP,|vw_K>/+xkj_RGKM>3/ *&	tuulhb[PE4(#)!|srd^\MV345vduqd}oikulPiR]AjSE}:K)W<1^Z[[&,*$&; !   $ (   4  ^ NAEv		wg^TA(fJWACE?703W{i1,UG xb^D>E?75xktuf`VJSOC<3.*$zo\QLSKA;:+  ~vjnC8MI(4szs~vvquXpTjMq[M?X(a62]kRg&/"1B
+7 )  /  7   P  C 
HF+S%' $,,+)/,#yniQ<.}^iPUUNI>+$"%D`T ;iQ!tmNGPJA>}rwykcYKXRD@70-&yl\QLSJ=;9+ &|zy\o?4MB'+~n|tvysn|tSrPbXyOOAQ0XF.TjP'`&/,:*!D  #  # 2 B ?  4  O DA"Ky	"%%'%)'ypgS<.
|^kUWWSMC0%"	
!	$Tj~/&`;iVGwnaLZMHF.w}~of_R\VKC:40+|r_TOUMC?=-$
*w|loC?SK2+||}jxzZp^mQsW[GI=TG9]kc&c29>;(B 	) $, 2 3 F  E  ;#   @j9[mT}f`]B;4&xgH;$smmJEdLDEAIRh{	Qu^kA=7:2"##
aJP<.x|ogaXWN;3 wjendYWSE9"@}RO`];<"-#!}c{lyT}\_ZYHgFBdz^?o36"5#B+"S" 4# /? [ B F  9  K  
ec (Ku%4INF<JVVQS>?VVNG=&"}dYD5|v|vwq^NDD)+C,+-$1;F^h	 /+`em>3${ile`Z9*+
}tl[f`TME=;2!raUPWOC><1$)fyHEQS04%s~{}XudhUyVORc3eL1ck^4g36!5D(@ 0	 C "/. F  E  W  ##@k=ds[qmdKHA1 
rTJ5%ww[Zx^SSX[]ux	zt}X\LLD>:51	 xcgQF?15*! ~vokbPJ2*#xrwre_]OD+Hx[Iba8H"2#w|^{fpfy^YVc4iN/pso6f50$CG+K0 < .$ 3 0  (  W  he/Pz -<LRKAO\[WVDG][WPB+($lbJ:|zi[QK6/G1).33;L_s		/@w|O23.%

|ptqiG=6&yhuoaZRJG@-$	k_[cYMIG;..pyOKZ^3@+s}|}du^yTybTVY8hC8ipl1cC%;!P8S0	A @B 7  (  j  #$Fj?dq\nlfMGA2"!
sSK4"|wrYWwYOPLSbt}	6T{LiOOLFDA!'yccQC937&#}slh_MB.&"yuzrgb`QF0J`\hkEN1:
,(#gn}bd\WmCpPCotr=lF)6C)I+"b
6 "? I+&$	! 5 K  b  ;@b
<bokbSB=6-tiSA7zyrq}vt	Vzv\[hNPQ:3!szeTIGD60%uskVN;0+yxkgdVL4Q!eZlqCV*B1)#os{r\d`hEp[Dui=uF5$G0U"?)d,"
C ='9)( < 9  j7 #!M			3	7	1	$	/	@	;	;	:	!	)	;	;	3	,	 		pd^F+O,:$#6b|
34 mbOHB+sjnaWRD;-%unVOI74+2~}ocK#t5ogxuQY9C<3(	 mpl`r\pEuWFx}q:sC-3A.U2/S6	A 7
= )    j  x+\												xmYI<2zk&RZ	ahk]^^F6($|}jYPMI@60%zvn[R<5/{{piiZO8X^Zlg@J,:'&{hYzZ~ZeU`5oP9pqi?o8/$; =-(D	8  
C (8 7     f  di<c|jgaSA/#tcV99	wnk][XFF*%
uydTKHF:1,vmmaNF0)#upxmc\[LA*F~[Vkg??24.# kl~dffUs?kZ@r}w:u630A+
X#2Q 6 ? 7+s d  (  ^  `f 3_rb`VK6%k^M}$	vxvhc^DA1-qbTRRA:5'yr_U@74# ~rlk^O:X!
g`xlLT8?63
(kkrkf^pCqb?sqCoB8(D.X12b= "V X+x k  % j &0HVXhl%)2/@=CIMRSZYf`fenlnpuqjv.Tq~[		<?CHWbgx". 12=<LZRv 9;,#(G>AJSO^USdx}:P*}-=YGc:1n9uXdi	)	7	_	/T	G
y	Z	Z	J

Q

	
|

  
> b"&?<FKd_msv
" BI)2;9?JLNXaot{w=%VWz	#8GKTbYaactq  -6?FOS^dhrjt#e4S Z185)-FW-sWdg#[%y9d5J:b3ZhZgq6uVHPM{-W<,\	1(w;	F'	l	iH				(
 g D2.:@CMNiVdkqy{
&.5B?W^pl3SNQPUdZn~p&&4JTY`Zhlvu 
#0&=2BIHej^YY|ss}x:#!
1K"kvO^/Um4+Y'Tn :G)19luU[&=k	/kN
s	>		q	
 * wB
3.<BENOjYflt{~
#37?>S\g|-HLIGQ\Sd{i /BFRZR]`lp{ "5)8AB\bUORpiku}l+ 
);5Nv7ZA\{02
|#L$G{P= z>%e!.	]b
x~	I	k
	
g  	l %`dw~2!.5:BDGNU]`gfspty}"<ETvD'%%!9;UVRZess{$&2:5eZfgwt|' )11?98GiU]kufb#3n-VMc&PUSXr(@&]X%=xz|w]1	Pk	?	;tx	YFRWhp| &-/3:AHJQP\[^chkmrr|y}}
(3X$  )*(1=A@PYXat~* --<9BYchnv| %-2!>IuWa/pbiYPpcGSh}yoaf~YiZP4`W/;KkXfHBhwG4^P@Ss@	]J>lGd	H6

l	 	
(=BRYelt %'-,86:>CEGLMVSXW`^bdhfbmv	"Eg}|
!+:MGO\PYX[hfv#'-5=@JGVO[ca|unp=( 63 C-0\9n" i[H_!rIn"j/1Il'd~H0&thwYr
I	 g	Y. NSelx 	!(+.5:CEKJWUY]befklurxw,Gsd(,1@BHQ^ko|y-)0COV_fkt~!/=w.qgGV>\ErlOmJewbiRB~fbOP%fKll)T@la[>Q*.MuH*sTi	BJG
P	T	 8lFEJ\bov~ &,46<;GEIMQSU[\d`fdnmpqvsq}5Xkp
#**2>H\Wanfnop|!5BEPX]frr}v
'/g<aGN6O<4`i?b7QmqMFIq?qO\VfWebvOW0VGA&'T5=59Q]|}B0$c5
v		  ;( W\pw
+&-3:<?GMUW^\igknsux}~"-L_|.	 '.9<DOO]^yu{~ !4-2JU\djry %8D})kaNGORVODejlgfiecW3
}}tJ-)l1HtFvWQvL:q<M?Rg>h}	S	
H|y	@ UYls
% '.469@FNPWUa_bgknotu|$<Wr  
!!%,2=>JQQWfuz"%40:PY_eot#).BHV|pauLhTeacpjuall`p>p}N2)A]M$MFu!;C]29?c:v2=<vX	O
t	f[_sz

.*16=@DKQY[b`mjnrwz{'2Eb1 	2<=7EOTZdfr~=5@ETRYox
%F8AJTCcl;oC{n|k~}P3lb(%SD.XpR:3{+9\2\+@
8	

+	O?k Z^rz-)06<?BJPYZb`mkouy{}&3Ns< 
'59<:>LRY`dq~

9+89ILSgpv{	5(/;D2OX/zZ/yyySt^kb{z{ouw :6plL
CE]1O\Mf<[;bW8Id=?v-kfq	|F
Gu		x; !Y^sz	*%,18:>DKRU\Ygdhnqtvz{)CY&{%"14=DJR[pmv~~}'%+?HNX[`mswy  $sttWI:?;=>4r\SPN$7d_>:yw>xy;q><' 
SjGz'JY8>
IY1)9\H6g	Pi+5Z	v YL"&?;GMPXZvcov}	
 
&+29?TVg!aBFFSYWaxo 

*;BMOK[]giu~w."39;U\LGKm`emzwxzg=
 
W8&$\s?	)Gn_<nvo9qwfP}(?{fc	r,u		-t	
*
d  
7 Ei-2LFRVokx
" DI)4:8<HMLS]lr~t<
+)*>Z	
#86BRGQRUbbv /9@JRY_lp{t
$3\2FNE/)89X\>RZ/0g1Oz6br#E@&zMo"W0^.v$6+`TGQ(sV{N9,|mO	7	

}	 #;GIY^zu *',27;<CCOJOOYY[]c]Ygszy;^nh`^{*26DIR\lM:JK^Zd
 -)8,,<bOUjs^_5lf!e$G7
xS;gP?u@@8
	.		~SpXG	tn	J
		&	x

,
|"
kH:	 2:MWc~ 3,5=GINYamoyv#$40QYk&2vUPMObfw}2.AOGMPSg_x
1,5T^jr}/&!2aKOio[a'2|WvmrEs(KWgOJOPj	u		X	
		
1	0	1	 	"
L		U
		+
Y		w
5	
i
*	
e3<OYe8 0;CLOS^gsu| .66Ran*)4	'g7D<PW[iyo .:38><NMb{9@OS`dsz~7#/BK2_t4`5\z~][m{wMI|T'Pf1Ab@	!j		(|	X

}
 
1	"	4	os
p
	F	
	j	
	0_	P
^
*	
s
6(18Wau(05ABfN^iq{	29*&*8?=JUghzy-p8l
 *8=I_~z 
"-$iSedzs}9>,#(TEJTe`occuOps4Oz%O)I	+9
LZ[v3			D		
/	 			J	.


	_
		E	Q		

0	|	U	%
@
f	E	{

:e	1 !,DQSdh %'/.@=BGNST\]kfljvvz}{
&:Qk`%"IQQWanw~	!&3:2EJTUcoj-!:/CIKltc[\z~+1EoFe<^($@!N\[rw+u2	5`K	v		:.	RUe		
v			F'




8e F ";6CJMVXsanu|%&)37HJUViw 
(ErVa[gvqt+!&'0;;O]eqyq~ 
%)4>ALA[Pafh{x{	p138$#/)L703;7r)#(N)q"$.r-fNPTP;'Rd|4|@FSxx	X7	$vW	o{z[	V
/	
	:		7
)	M?~
($169CE^M[bhorv}  *3:>O]oh0bE9CMUOWpg%:;EPDTXaep{u
)/44NZIBGd]bjws{wf|-#95;N sLt[	h1(!R4a
~~9808?]6Y_VMr/
m *h		
.
Z		

	O&
yF ":6CIMUWr`nv|!%%07CHONfmMnGQYd`gu{}  #3.CT]amesw%,/;1J@OVWsykfe~N19!0#	&^#DQK	OiAoD78RTUht r:4FSCM7
Z#	:3	:X[				9	;/
y YH!&>;HOQZ\xft{ '&/,:ALRW]u+1[|^kbtjsx	*!'33BV[elcst~| 
 %.&:2BHGbl[TVwnr|tH>
8,G
AW^`{W7dSC<qHm2l}_
>Y7OswX
	X)T6u	Xw)		;
g)		 O%*B=KPS\^ygt{ !*!..3<FPQ`by:=migxy#"-=4;=@POav~%/6>FNY]i`wm}"0~@XRT^9HJdVVx=KrEu=CQJ>LtfO`8$,o}|{K*=S^l=	TZT	
H	9v	z9	4	?	
-	
		 N
#)-FBOUXbcm{ 	+1$#(4::EMY[ii}A1Erst| ,+5D:AFHWTh}")0;CHR[^iawn"0l,FQ7E/;;Y^1z2@qlBZ1{IzH0::
lry6q"65  `QI9V6EO_w	%7[e	v	4	y	D
G!6	F
 M!',D?LSW`a}ky 
+3'%+7:9GPZ_ok"G?]ut3-;KGHKK[^p
&-8>GMVbcner	&7c0Z#QVV8@^Qe[z=_bZF`z^T:L#f>`^6"51o}7#eXSq	9=e8		Z	e		w
G
t	83   _ &@;FKd`nux	$"%*-+P&Y5@KJNY`ajq#F70[n*17Me]k{qu||$!!60:TZdjw{1"':H/Ta. j3skykf|fttvk@yc@lHQ_>k#3a	W	(u	
l

	s	Yk	
a	*!t(	K cU,(37PLZacnox9D#,968FJKXbms3GTk$0A@N[PZ]]mo~29CJTXdkn}q|
-7Mh!]gg=jGkzKKo|\tK`dW_Hnl7>59&5?oVq8_UUW	S(uu	8	}	S:y
	
-	
pt	8>	r a#'@<GLfaovz))-/61V.a=HRPVaefs|%[:;gh(0<>Q^sq>.=?RMTmw	 #H2APWBgv?|E\z{sfzvN=HQ5Z=LCk	`lK	+	$	L	0)	U	Siy
H
	
L
w
w	>$ U .)49QN\benqz>G'2<;>MQO_dov96^o$6QL[g[ifiyy& 'CKSZdhs|}#-AKp~3|~dZ`ewe^dZsjp|n<2 7;UG&4HD(63q5f			8ky	q
6	S9X>
q>
 
.
`w$a"'A<GLfaovy(),.31V,^=HQOS^ecrzP%'VUz!%2=DO_uo;)79NHQjs}%M7@S\GkzIX
v-P-obCgZmuU7~MSv	1	7	t>	>+k
~s!	I	T
a



	
	5
&,7	r
f+/JFQVpky*&,,66:;C?d:kHU^^cnvx"Gn5:Tm	$/7@ERYl I6HG\W]z+/TCK[eNtQl~
"sGrBQ+x8`h51			 M	W	+
d	3	3

	

B	
elg { ,9;IOjepv
&$*06:<DESNUS^^bdkhet8Qv{
*,76CNXbqo 
*&6B:p^nn|"':.1:HGRKGXls|~9O>- )}G&Rk1G{sU	bd	/	i	0	k)?	
5~	n
q
\	
	jR
> vu ".0@D_Zfk %+,34A=DDNMQUZU}Raoxuy	 <RlDU[})5;DPW_m	!Q@LNa]d~".$"4XFPdiW|X,nN)K!s!}bPc8W<R!t"		!	O	
		f	


   p%(6;VQ\a{v

!")+83::DCHJPLsHzVcmlo3UW?kro$*64JOU`qG4@BUPVpx
C37KP=ao<R~Q,S=;llUeK&u]w*			i	V	*}	]		^
`
[
		
wl m#&49TOZ^yu
&(4165@@DHLHoFxVcjjlz 0CrI5fc /;;MQSiw 
%UCNPc^g'$1))7_JUgn[\&wnNE3~oK
y<	
cuZ			0+	d4?	
}%		S,t
K	 g
	 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@p@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@H@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@H@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@p@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                                                          @@@@@@@@@@@@@@@@@@@      m                                                                                    O                                                                                                               @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@H@@@@                                                                          @@@@@@@@@@@@@@@@@@@      m                                                                                    O                                                                                                               @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                                                          @@@@@@@@@@@@@@@@@@@      m                                                                                    O                                                                                                               @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@r@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@H@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@p@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@r@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@r@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@r@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                                                          @@@@@@@@@@@@@@@@@@@      k                                                                                    O                                                                                                               @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@q@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ N!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@p@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@H@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@p@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ N!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@p@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@q@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@q@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ N!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                                                          @@@@@@@@@@@@@@@@@@@      m                                                                                    O                                                                                                               @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@A@@@@@@@o@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@!@!@!@ O!@!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@