# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'USGSCSM'
copyright = '2021, USGS Astrogeology Software Team'
author = 'USGS Astrogeology Software Team'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['breathe'] #, 'exhale']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'alabaster'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []

# breathe (doxygen -> sphinx package) settings
breathe_projects = { "USGSCSM": "../xml/" }
breathe_default_project = "USGSCSM"

import subprocess, os

# build doxygen on readthedocs
read_the_docs_build = os.environ.get('READTHEDOCS', None) == 'True'
if read_the_docs_build:
    subprocess.call('cd ..; doxygen Doxyfile', shell=True)

# Setup the exhale extension
#exhale_args = {
#    # These arguments are required
#    "containmentFolder":     "./library",
#    "rootFileName":          "index.rst",
#    "rootFileTitle":         "USGSCSM API",
#    "doxygenStripFromPath":  "..",
#    # Suggested optional arguments
#    "createTreeView":        True,
#    # TIP: if using the sphinx-bootstrap-theme, you need
#    # "treeViewIsBootstrap": True,
#    "exhaleExecutesDoxygen": True,
#    "exhaleDoxygenStdin":    "INPUT = ../../include"
#}

# Tell sphinx what the primary language being documented is.
primary_domain = 'cpp'

# Tell sphinx what the pygments highlight language should be.
highlight_language = 'cpp'

