# AGILE: AGN In the LSST Era

This repository contains the sources code for the LSST INAF in-kind
contribution for creating a photometric AGN, galaxy and star catalog

# Main authors and contact

The code has been developed in INAF-OAR with significant contributions from the
following people:

	+ Akke Viitanen (akke.viitanen@inaf.it)
	+ Angela Bongiorno 
	+ Ivano Saccheo 
	+ Andrea Grazian 

# Installation

The code builds on top of several external software. Namely:

	+ egg: https://cschreib.github.io/egg/
	+ LSST Science Pipelines: https://pipelines.lsst.io/
	+ DESC imSim: http://lsstdesc.org/imSim/
	+ quasarlf: https://ui.adsabs.harvard.edu/abs/2020MNRAS.495.3252S/abstract
	+ QSOGEN: https://ui.adsabs.harvard.edu/abs/2022ascl.soft05003T/abstract
	+ AGN_lightcurve_simulations: INAF-OAC, Petrecca, Paolillo+, in prep.
	+ GrowBHs: University of Southampton: Roberts, Shankar+ in prep.

For retrieving the extenal libraries in preparation, please contact
akke.viitanen@inaf.it.

# Running the code

Running the command

	$ sh run.sh

Will create a small EGG galaxy catalog, an AGN catalog on top of the EGG catalog, and a stellar catalog. Then, it creates 6 instance catalogs (one per each filter in ugrizy), which can be simulated using imSim. Finally, it will create validation plots based on the products.

See the file 'config.ini' on the available options for modifying the behavior of the code.
