#!/usr/bin/env python3
# encoding: utf-8
# Author: Akke Viitanen
# Email: akke.viitanen@helsinki.fi
# Date:

"""
"""


import argparse
import glob
import math
import os
import random
import re
import subprocess
import sys
import time

import astropy as ap
import astropy.coordinates as c
import astropy.units as u
import fitsio
import matplotlib as mpl
import matplotlib.pyplot as plt
import numpy as np
import scipy as sp

filename = "red.csv"

def write1(filename):
    d = np.loadtxt(filename, delimiter=',')
    d = d[np.argsort(d[:, 0])]
    x = []
    ylo = []
    ymi = []
    yhi = []

    for i in range(0, len(d), 3):

        xs = d[i:i+3, 0]
        ys = np.sort(d[i:i+3, 1])

        x.append(np.mean(xs))
        ylo.append(ys[0])
        ymi.append(ys[1])
        yhi.append(ys[2])

    ylo = np.array(ylo)
    ymi = np.array(ymi)
    yhi = np.array(yhi)

    np.savetxt(
        filename.replace(".csv", "_fixed.dat"),
        np.vstack([x, ymi, yhi - ymi, ymi - ylo]).T
    )

def write2(filename):
    d = np.loadtxt(filename, delimiter=',')
    d = d[np.argsort(d[:, 0])]
    x = d[:, 0]
    y = d[:, 1]
    np.savetxt(
        filename.replace(".csv", "_fixed.dat"),
        np.vstack([x, y]).T
    )

write1("red.csv")
write1("pink.csv")
write1("green.csv")

write2("blue.csv")
write2("purple.csv")
