from argparse import ArgumentParser
from sys import argv
import os

import matplotlib.pyplot as plt
from astropy import coordinates
from astropy import units as u
import fitsio
import numpy as np

class Imsim:

    def __init__(self):
        return

    def run(
        self,
        filename_imsim_yaml,
        filename_instance_catalog,
        directory_output,
        directory_checkpoint,
        det_first,
        nfiles,
        nobjects=None
    ):
        imsim_yaml = f"""\
modules:
    - imsim
template: imsim-config-instcat
input.instance_catalog.file_name: {filename_instance_catalog}
input.instance_catalog.sort_mag: False
input.checkpoint.dir: {directory_checkpoint}
output.dir: {directory_output}
output.det_num.first: {det_first}
output.nfiles: {nfiles}
output.nproc: {nfiles}
output.timeout: 36000
""" + f"image.nobjects: {nobjects}" * (args.nobjects is not None)
        print(imsim_yaml, file=open("imsim-user-instcat.yaml", 'w'))
        os.system("galsim imsim-user-instcat.yaml 1> galsim.out 2> galsim.err")
