#!/usr/bin/env python3
# encoding: utf-8
# Author: Akke Viitanen
# Email: akke.viitanen@helsinki.fi
# Date: EGGify the LSST catalog


import argparse
import glob
import math
import os
import random
import re
import subprocess
import sys
import time

import astropy as ap
import astropy.coordinates as c
import astropy.units as u
import fitsio
import matplotlib as mpl
import matplotlib.pyplot as plt
import numpy as np
import scipy as sp

bands = 'ugrizy'
lam = 0.368483, 0.480199, 0.623119, 0.754169, 0.869047, 0.973638

def main():

    catalog = fitsio.read("catalog.fits")
    select = catalog["is_pointsource"] == 1
    catalog = catalog[select]

    egg = {
        "ID":           np.array([np.arange(catalog.size)]),
        "RA":           np.array([catalog["ra"]], dtype=np.float32),
        "DEC":          np.array([catalog["dec"]], dtype=np.float32),
        "BULGE_RADIUS": np.array([np.full(catalog.size, 1e-5, dtype=np.float32)]),
        "BULGE_RATIO":  np.array([np.full(catalog.size, 1e-5, dtype=np.float32)]),
        "BULGE_ANGLE":  np.array([np.full(catalog.size, 0.00, dtype=np.float32)]),
        "DISK_RADIUS":  np.array([np.full(catalog.size, 1e-5, dtype=np.float32)]),
        "DISK_RATIO":   np.array([np.full(catalog.size, 1e-5, dtype=np.float32)]),
        "DISK_ANGLE":   np.array([np.full(catalog.size, 0.00, dtype=np.float32)]),
        "BANDS":        np.array([[f"lsst-{band}" for band in bands]]),
        "LAMBDA":       np.array([[l for l in lam]], dtype=np.float32),
        "FLUX":         0.001 * np.transpose(np.array([[catalog[f"flux_{band}"] for band in bands]], dtype=np.float32), (0, 2, 1)),
        "FLUX_BULGE":   0.001 * np.transpose(np.array([[catalog[f"flux_{band}"] for band in bands]], dtype=np.float32), (0, 2, 1)),
        "FLUX_DISK":    0.000 * np.transpose(np.array([[catalog[f"flux_{band}"] for band in bands]], dtype=np.float32), (0, 2, 1)),
    }

    fitsio.write("egg.fits", egg, clobber=True)



if __name__ == "__main__":
    main()
