#!/usr/bin/env python3
# encoding: utf-8
# Author: Akke Viitanen
# Email: akke.viitanen@helsinki.fi
# Date: 2023-07-03 18:13:09

"""
Write the psf in a more convenient format
"""


import argparse
import glob
import math
import os
import random
import re
import subprocess
import sys
import time

import astropy as ap
import astropy.coordinates as c
import astropy.units as u
import fitsio
import matplotlib as mpl
import matplotlib.pyplot as plt
import numpy as np
import scipy as sp


def main():
    for fname in glob.glob("*_psf.fits"):
        _, head = fitsio.read(fname, header=True, ext=1)
        fits, _ = fitsio.read(fname, header=True, ext=4)
        fitsio.write(fname.replace("_psf.fits", ".psf"), fits, header=head, clobber=True)


if __name__ == "__main__":
    main()
