import numpy as np

def get_log_L_2_keV(log_LX_2_10, Gamma=1.9, wavelength=6.2):
    """
    Returns monochromatic X-ray luminosity at lambda = wavelength  in erg/s Hz^-1 to be used for the alpha_ox
    Lx = restframe 2-10 kev luminosity.
    maybe we can work directly with frequencies and have it in one line
    """
    log_LX_2_10 = np.atleast_1d(log_LX_2_10)
    Lx = 10 ** log_LX_2_10
    K = (Lx / (6.2 ** (Gamma - 2) - 1.24 ** (Gamma - 2))) * (Gamma - 2)  #6.2, 1.24 = 2kev, 10kev in A°
    return np.log10((K * wavelength ** (Gamma - 1)) / 2.998e18)

def get_log_L_2500(log_L_2_keV, alpha=0.952, beta=2.138, scatter=True):

    """
    Returns the 2500 ang° monochromatic luminosity (in erg/s). It uses
    Lusso+10 eq. 5 (inverted) Lx = alpha L_opt - beta
    """

    log_L_2_keV = np.atleast_1d(log_L_2_keV)

    log_L_2500 = (log_L_2_keV + beta) / alpha
    assert np.allclose(alpha * log_L_2500 - beta, log_L_2_keV)

    # TODO: implement realistic scatter
    if scatter:
        log_L_2500 += np.random.normal(loc=0, scale=0.4, size=log_L_2_keV.size)

    return log_L_2500
    #return (10 ** L_2500) * 2.998e18 / 2500
